/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.transport;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.jersey3.AbstractJersey3EurekaHttpClient;
import com.netflix.discovery.shared.transport.jersey3.EurekaIdentityHeaderFilter;
import com.netflix.discovery.shared.transport.jersey3.EurekaJersey3Client;
import com.netflix.discovery.shared.transport.jersey3.EurekaJersey3ClientImpl;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerIdentity;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.protocol.ReplicationList;
import com.netflix.eureka.cluster.protocol.ReplicationListResponse;
import com.netflix.eureka.resources.ASGResource;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.Jersey3DynamicGZIPContentEncodingFilter;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jersey3ReplicationClient
extends AbstractJersey3EurekaHttpClient
implements HttpReplicationClient {
    private static final Logger logger = LoggerFactory.getLogger(Jersey3ReplicationClient.class);
    private final EurekaJersey3Client eurekaJersey3Client;

    public Jersey3ReplicationClient(EurekaJersey3Client eurekaJersey3Client, String serviceUrl) {
        super(eurekaJersey3Client.getClient(), serviceUrl);
        this.eurekaJersey3Client = eurekaJersey3Client;
    }

    protected void addExtraHeaders(Invocation.Builder webResource) {
        webResource.header("x-netflix-discovery-replication", (Object)"true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EurekaHttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        EurekaHttpResponse eurekaHttpResponse;
        String urlPath = "apps/" + appName + '/' + id;
        Response response = null;
        try {
            WebTarget webResource = this.jerseyClient.target(this.serviceUrl).path(urlPath).queryParam("status", new Object[]{info.getStatus().toString()}).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()});
            if (overriddenStatus != null) {
                webResource = webResource.queryParam("overriddenstatus", new Object[]{overriddenStatus.name()});
            }
            Invocation.Builder requestBuilder = webResource.request();
            this.addExtraHeaders(requestBuilder);
            response = requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.entity((Object)"{}", (MediaType)MediaType.APPLICATION_JSON_TYPE));
            InstanceInfo infoFromPeer = null;
            if (response.getStatus() == Response.Status.CONFLICT.getStatusCode() && response.hasEntity()) {
                infoFromPeer = (InstanceInfo)response.readEntity(InstanceInfo.class);
            }
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus(), infoFromPeer).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[heartbeat] Jersey HTTP PUT {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[heartbeat] Jersey HTTP PUT {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EurekaHttpResponse<Void> statusUpdate(String asgName, ASGResource.ASGStatus newStatus) {
        try (Response response = null;){
            String urlPath = "asg/" + asgName + "/status";
            response = this.jerseyClient.target(this.serviceUrl).path(urlPath).queryParam("value", new Object[]{newStatus.name()}).request().header("x-netflix-discovery-replication", (Object)"true").put(Entity.text((Object)""));
            EurekaHttpResponse eurekaHttpResponse = EurekaHttpResponse.status((int)response.getStatus());
            return eurekaHttpResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EurekaHttpResponse<ReplicationListResponse> submitBatchUpdates(ReplicationList replicationList) {
        try (Response response = null;){
            response = this.jerseyClient.target(this.serviceUrl).path("peerreplication/batch/").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)replicationList));
            if (!Jersey3ReplicationClient.isSuccess(response.getStatus())) {
                EurekaHttpResponse eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus(), ReplicationListResponse.class).build();
                return eurekaHttpResponse;
            }
            ReplicationListResponse batchResponse = (ReplicationListResponse)response.readEntity(ReplicationListResponse.class);
            EurekaHttpResponse eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus(), (Object)batchResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
            return eurekaHttpResponse;
        }
    }

    public void shutdown() {
        super.shutdown();
        this.eurekaJersey3Client.destroyResources();
    }

    public static Jersey3ReplicationClient createReplicationClient(EurekaServerConfig config, ServerCodecs serverCodecs, String serviceUrl) {
        EurekaJersey3Client jerseyClient;
        String name = Jersey3ReplicationClient.class.getSimpleName() + ": " + serviceUrl + "apps/: ";
        try {
            String hostname;
            try {
                hostname = new URL(serviceUrl).getHost();
            }
            catch (MalformedURLException e) {
                hostname = serviceUrl;
            }
            String jerseyClientName = "Discovery-PeerNodeClient-" + hostname;
            EurekaJersey3ClientImpl.EurekaJersey3ClientBuilder clientBuilder = new EurekaJersey3ClientImpl.EurekaJersey3ClientBuilder().withClientName(jerseyClientName).withUserAgent("Java-EurekaClient-Replication").withEncoderWrapper((EncoderWrapper)serverCodecs.getFullJsonCodec()).withDecoderWrapper((DecoderWrapper)serverCodecs.getFullJsonCodec()).withConnectionTimeout(config.getPeerNodeConnectTimeoutMs()).withReadTimeout(config.getPeerNodeReadTimeoutMs()).withMaxConnectionsPerHost(config.getPeerNodeTotalConnectionsPerHost()).withMaxTotalConnections(config.getPeerNodeTotalConnections()).withConnectionIdleTimeout(config.getPeerNodeConnectionIdleTimeoutSeconds());
            if (serviceUrl.startsWith("https://") && "true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
                clientBuilder.withSystemSSLConfiguration();
            }
            jerseyClient = clientBuilder.build();
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot Create new Replica Node :" + name, e);
        }
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warn("Cannot find localhost ip", (Throwable)e);
        }
        Client jerseyApacheClient = jerseyClient.getClient();
        jerseyApacheClient.register((Object)new Jersey3DynamicGZIPContentEncodingFilter(config));
        EurekaServerIdentity identity = new EurekaServerIdentity(ip);
        jerseyApacheClient.register((Object)new EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
        return new Jersey3ReplicationClient(jerseyClient, serviceUrl);
    }

    private static boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }
}

