/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.SuspendedProcess;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.registry.InstanceRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AwsAsgUtil {
    private static final Logger logger = LoggerFactory.getLogger(AwsAsgUtil.class);
    private static final String PROP_ADD_TO_LOAD_BALANCER = "AddToLoadBalancer";
    private static final String accountId = AwsAsgUtil.getAccountId();
    private Map<String, Credentials> stsCredentials = new HashMap<String, Credentials>();
    private final ExecutorService cacheReloadExecutor = new ThreadPoolExecutor(1, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Eureka-AWS-isASGEnabled");
            thread.setDaemon(true);
            return thread;
        }
    });
    private ListeningExecutorService listeningCacheReloadExecutor = MoreExecutors.listeningDecorator((ExecutorService)this.cacheReloadExecutor);
    private final java.util.Timer timer = new java.util.Timer("Eureka-ASGCacheRefresh", true);
    private final Timer loadASGInfoTimer = Monitors.newTimer((String)"Eureka-loadASGInfo");
    private final EurekaServerConfig serverConfig;
    private final EurekaClientConfig clientConfig;
    private final InstanceRegistry registry;
    private final LoadingCache<CacheKey, Boolean> asgCache;
    private final AmazonAutoScaling awsClient;

    @Inject
    public AwsAsgUtil(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, InstanceRegistry registry) {
        this.serverConfig = serverConfig;
        this.clientConfig = clientConfig;
        this.registry = registry;
        this.asgCache = CacheBuilder.newBuilder().initialCapacity(500).expireAfterAccess(serverConfig.getASGCacheExpiryTimeoutMs(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<CacheKey, Boolean>(){

            public Boolean load(CacheKey key) throws Exception {
                return AwsAsgUtil.this.isASGEnabledinAWS(key.asgAccountId, key.asgName);
            }

            public ListenableFuture<Boolean> reload(final CacheKey key, Boolean oldValue) throws Exception {
                return AwsAsgUtil.this.listeningCacheReloadExecutor.submit((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return this.load(key);
                    }
                });
            }
        });
        this.awsClient = this.getAmazonAutoScalingClient();
        this.awsClient.setEndpoint("autoscaling." + clientConfig.getRegion() + ".amazonaws.com");
        this.timer.schedule(this.getASGUpdateTask(), serverConfig.getASGUpdateIntervalMs(), serverConfig.getASGUpdateIntervalMs());
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor :", e);
        }
    }

    public boolean isASGEnabled(InstanceInfo instanceInfo) {
        CacheKey cacheKey = new CacheKey(this.getAccountId(instanceInfo, accountId), instanceInfo.getASGName());
        Boolean result = (Boolean)this.asgCache.getIfPresent((Object)cacheKey);
        if (result != null) {
            return result;
        }
        logger.info("Cache value for asg {} does not exist yet, async refreshing.", (Object)cacheKey.asgName);
        this.asgCache.refresh((Object)cacheKey);
        return true;
    }

    public void setStatus(String asgName, boolean enabled) {
        String asgAccountId = this.getASGAccount(asgName);
        this.asgCache.put((Object)new CacheKey(asgAccountId, asgName), (Object)enabled);
    }

    private boolean isAddToLoadBalancerSuspended(String asgAccountId, String asgName) {
        AutoScalingGroup asg = asgAccountId == null || asgAccountId.equals(accountId) ? this.retrieveAutoScalingGroup(asgName) : this.retrieveAutoScalingGroupCrossAccount(asgAccountId, asgName);
        if (asg == null) {
            logger.warn("The ASG information for {} could not be found. So returning false.", (Object)asgName);
            return false;
        }
        return this.isAddToLoadBalancerSuspended(asg);
    }

    private boolean isAddToLoadBalancerSuspended(AutoScalingGroup asg) {
        List suspendedProcesses = asg.getSuspendedProcesses();
        for (SuspendedProcess process : suspendedProcesses) {
            if (!PROP_ADD_TO_LOAD_BALANCER.equals(process.getProcessName())) continue;
            return true;
        }
        return false;
    }

    private AutoScalingGroup retrieveAutoScalingGroup(String asgName) {
        if (Strings.isNullOrEmpty((String)asgName)) {
            logger.warn("null asgName specified, not attempting to retrieve AutoScalingGroup from AWS");
            return null;
        }
        DescribeAutoScalingGroupsRequest request = new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{asgName});
        DescribeAutoScalingGroupsResult result = this.awsClient.describeAutoScalingGroups(request);
        List asgs = result.getAutoScalingGroups();
        if (asgs.isEmpty()) {
            return null;
        }
        return (AutoScalingGroup)asgs.get(0);
    }

    private Credentials initializeStsSession(String asgAccount) {
        AWSSecurityTokenServiceClient sts = new AWSSecurityTokenServiceClient((AWSCredentialsProvider)new InstanceProfileCredentialsProvider());
        String region = this.clientConfig.getRegion();
        if (!region.equals("us-east-1")) {
            sts.setEndpoint("sts." + region + ".amazonaws.com");
        }
        String roleName = this.serverConfig.getListAutoScalingGroupsRoleName();
        String roleArn = "arn:aws:iam::" + asgAccount + ":role/" + roleName;
        AssumeRoleResult assumeRoleResult = sts.assumeRole(new AssumeRoleRequest().withRoleArn(roleArn).withRoleSessionName("sts-session-" + asgAccount));
        return assumeRoleResult.getCredentials();
    }

    private AutoScalingGroup retrieveAutoScalingGroupCrossAccount(String asgAccount, String asgName) {
        DescribeAutoScalingGroupsRequest request;
        DescribeAutoScalingGroupsResult result;
        List asgs;
        logger.debug("Getting cross account ASG for asgName: " + asgName + ", asgAccount: " + asgAccount);
        Credentials credentials = this.stsCredentials.get(asgAccount);
        if (credentials == null || credentials.getExpiration().getTime() < System.currentTimeMillis() + 1000L) {
            this.stsCredentials.put(asgAccount, this.initializeStsSession(asgAccount));
            credentials = this.stsCredentials.get(asgAccount);
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration().withConnectionTimeout(this.serverConfig.getASGQueryTimeoutMs());
        AmazonAutoScalingClient autoScalingClient = new AmazonAutoScalingClient((AWSCredentials)new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken()), clientConfiguration);
        String region = this.clientConfig.getRegion();
        if (!region.equals("us-east-1")) {
            autoScalingClient.setEndpoint("autoscaling." + region + ".amazonaws.com");
        }
        if ((asgs = (result = autoScalingClient.describeAutoScalingGroups(request = new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{asgName}))).getAutoScalingGroups()).isEmpty()) {
            return null;
        }
        return (AutoScalingGroup)asgs.get(0);
    }

    private Boolean isASGEnabledinAWS(String asgAccountid, String asgName) {
        try {
            Stopwatch t = this.loadASGInfoTimer.start();
            boolean returnValue = !this.isAddToLoadBalancerSuspended(asgAccountid, asgName);
            t.stop();
            return returnValue;
        }
        catch (Throwable e) {
            logger.error("Could not get ASG information from AWS: ", e);
            return Boolean.TRUE;
        }
    }

    @Monitor(name="numOfElementsinASGCache", description="Number of elements in the ASG Cache", type=DataSourceType.GAUGE)
    public long getNumberofElementsinASGCache() {
        return this.asgCache.size();
    }

    @Monitor(name="numOfASGQueries", description="Number of queries made to AWS to retrieve ASG information", type=DataSourceType.COUNTER)
    public long getNumberofASGQueries() {
        return this.asgCache.stats().loadCount();
    }

    @Monitor(name="numOfASGQueryFailures", description="Number of queries made to AWS to retrieve ASG information and that failed", type=DataSourceType.COUNTER)
    public long getNumberofASGQueryFailures() {
        return this.asgCache.stats().loadExceptionCount();
    }

    private TimerTask getASGUpdateTask() {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    Set cacheKeys = AwsAsgUtil.this.getCacheKeys();
                    logger.debug("Trying to  refresh the keys for {}", (Object)Arrays.toString(cacheKeys.toArray()));
                    for (CacheKey key : cacheKeys) {
                        try {
                            AwsAsgUtil.this.asgCache.refresh((Object)key);
                        }
                        catch (Throwable e) {
                            logger.error("Error updating the ASG cache for {}", (Object)key, (Object)e);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error("Error updating the ASG cache", e);
                }
            }
        };
    }

    private Set<CacheKey> getCacheKeys() {
        HashSet<CacheKey> cacheKeys = new HashSet<CacheKey>();
        Applications apps = this.registry.getApplicationsFromLocalRegionOnly();
        for (Application app : apps.getRegisteredApplications()) {
            for (InstanceInfo instanceInfo : app.getInstances()) {
                String localAccountId = this.getAccountId(instanceInfo, accountId);
                String asgName = instanceInfo.getASGName();
                if (asgName == null) continue;
                CacheKey key = new CacheKey(localAccountId, asgName);
                cacheKeys.add(key);
            }
        }
        return cacheKeys;
    }

    private String getASGAccount(String asgName) {
        Applications apps = this.registry.getApplicationsFromLocalRegionOnly();
        for (Application app : apps.getRegisteredApplications()) {
            for (InstanceInfo instanceInfo : app.getInstances()) {
                String localAccountId;
                String thisAsgName = instanceInfo.getASGName();
                if (thisAsgName == null || !thisAsgName.equals(asgName) || (localAccountId = this.getAccountId(instanceInfo, null)) == null) continue;
                return localAccountId;
            }
        }
        logger.info("Couldn't get the ASG account for {}, using the default accountId instead", (Object)asgName);
        return accountId;
    }

    private String getAccountId(InstanceInfo instanceInfo, String fallbackId) {
        String localAccountId = null;
        DataCenterInfo dataCenterInfo = instanceInfo.getDataCenterInfo();
        if (dataCenterInfo instanceof AmazonInfo) {
            localAccountId = ((AmazonInfo)dataCenterInfo).get(AmazonInfo.MetaDataKey.accountId);
        }
        return localAccountId == null ? fallbackId : localAccountId;
    }

    private AmazonAutoScaling getAmazonAutoScalingClient() {
        String aWSAccessId = this.serverConfig.getAWSAccessId();
        String aWSSecretKey = this.serverConfig.getAWSSecretKey();
        ClientConfiguration clientConfiguration = new ClientConfiguration().withConnectionTimeout(this.serverConfig.getASGQueryTimeoutMs());
        if (null != aWSAccessId && !"".equals(aWSAccessId) && null != aWSSecretKey && !"".equals(aWSSecretKey)) {
            return new AmazonAutoScalingClient((AWSCredentials)new BasicAWSCredentials(aWSAccessId, aWSSecretKey), clientConfiguration);
        }
        return new AmazonAutoScalingClient((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(), clientConfiguration);
    }

    private static String getAccountId() {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        return ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.accountId);
    }

    private static class CacheKey {
        final String asgAccountId;
        final String asgName;

        CacheKey(String asgAccountId, String asgName) {
            this.asgAccountId = asgAccountId;
            this.asgName = asgName;
        }

        public String toString() {
            return "CacheKey{asgName='" + this.asgName + '\'' + ", asgAccountId='" + this.asgAccountId + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.asgAccountId != null ? !this.asgAccountId.equals(cacheKey.asgAccountId) : cacheKey.asgAccountId != null) {
                return false;
            }
            return !(this.asgName != null ? !this.asgName.equals(cacheKey.asgName) : cacheKey.asgName != null);
        }

        public int hashCode() {
            int result = this.asgName != null ? this.asgName.hashCode() : 0;
            result = 31 * result + (this.asgAccountId != null ? this.asgAccountId.hashCode() : 0);
            return result;
        }
    }
}

