/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.sla;

import com.netflix.fenzo.sla.ResAllocs;

public class ResAllocsBuilder {
    private double cores = Double.MAX_VALUE;
    private double memory = Double.MAX_VALUE;
    private double networkMbps = Double.MAX_VALUE;
    private double disk = Double.MAX_VALUE;
    private final String taskGroupName;

    public ResAllocsBuilder(String taskGroupName) {
        this.taskGroupName = taskGroupName;
    }

    public ResAllocsBuilder withCores(double cores) {
        this.cores = cores;
        return this;
    }

    public ResAllocsBuilder withMemory(double memory) {
        this.memory = memory;
        return this;
    }

    public ResAllocsBuilder withNetworkMbps(double networkMbps) {
        this.networkMbps = networkMbps;
        return this;
    }

    public ResAllocsBuilder withDisk(double disk) {
        this.disk = disk;
        return this;
    }

    public ResAllocs build() {
        final double c = this.cores;
        final double m = this.memory;
        final double n = this.networkMbps;
        final double d = this.disk;
        return new ResAllocs(){

            @Override
            public String getTaskGroupName() {
                return ResAllocsBuilder.this.taskGroupName;
            }

            @Override
            public double getCores() {
                return c;
            }

            @Override
            public double getMemory() {
                return m;
            }

            @Override
            public double getNetworkMbps() {
                return n;
            }

            @Override
            public double getDisk() {
                return d;
            }
        };
    }
}

