/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixObservable;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.collapser.CollapserTimer;
import com.netflix.hystrix.collapser.HystrixCollapserBridge;
import com.netflix.hystrix.collapser.RealCollapserTimer;
import com.netflix.hystrix.collapser.RequestCollapser;
import com.netflix.hystrix.collapser.RequestCollapserFactory;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.schedulers.Schedulers;
import rx.subjects.ReplaySubject;

public abstract class HystrixObservableCollapser<K, BatchReturnType, ResponseType, RequestArgumentType>
implements HystrixObservable<ResponseType> {
    static final Logger logger = LoggerFactory.getLogger(HystrixObservableCollapser.class);
    private final RequestCollapserFactory<BatchReturnType, ResponseType, RequestArgumentType> collapserFactory;
    private final HystrixRequestCache requestCache;
    private final HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> collapserInstanceWrapper;
    private final HystrixCollapserMetrics metrics;
    private static ConcurrentHashMap<Class<? extends HystrixObservableCollapser>, String> defaultNameCache = new ConcurrentHashMap();

    protected HystrixObservableCollapser() {
        this(Setter.withCollapserKey(null).andScope(Scope.REQUEST));
    }

    protected HystrixObservableCollapser(HystrixCollapserKey collapserKey) {
        this(Setter.withCollapserKey(collapserKey).andScope(Scope.REQUEST));
    }

    protected HystrixObservableCollapser(Setter setter) {
        this(setter.collapserKey, setter.scope, new RealCollapserTimer(), setter.propertiesSetter, null);
    }

    HystrixObservableCollapser(HystrixCollapserKey collapserKey, Scope scope, CollapserTimer timer, HystrixCollapserProperties.Setter propertiesBuilder, HystrixCollapserMetrics metrics) {
        if (collapserKey == null || collapserKey.name().trim().equals("")) {
            String defaultKeyName = HystrixObservableCollapser.getDefaultNameFromClass(this.getClass());
            collapserKey = HystrixCollapserKey.Factory.asKey(defaultKeyName);
        }
        HystrixCollapserProperties properties = HystrixPropertiesFactory.getCollapserProperties(collapserKey, propertiesBuilder);
        this.collapserFactory = new RequestCollapserFactory(collapserKey, (RequestCollapserFactory.Scope)scope, timer, properties);
        this.requestCache = HystrixRequestCache.getInstance(collapserKey, HystrixPlugins.getInstance().getConcurrencyStrategy());
        this.metrics = metrics == null ? HystrixCollapserMetrics.getInstance(collapserKey, properties) : metrics;
        final HystrixObservableCollapser self = this;
        HystrixMetricsPublisherFactory.createOrRetrievePublisherForCollapser(collapserKey, this.metrics, properties);
        this.collapserInstanceWrapper = new HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType>(){

            @Override
            public Collection<Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>>> shardRequests(Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                Collection shards = self.shardRequests(requests);
                self.metrics.markShards(shards.size());
                return shards;
            }

            @Override
            public Observable<BatchReturnType> createObservableCommand(Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                HystrixObservableCommand command = self.createCommand(requests);
                command.markAsCollapsedCommand(requests.size());
                self.metrics.markBatch(requests.size());
                return command.toObservable();
            }

            @Override
            public Observable<Void> mapResponseToRequests(Observable<BatchReturnType> batchResponse, Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                Func1 requestKeySelector = self.getRequestArgumentKeySelector();
                final Func1 batchResponseKeySelector = self.getBatchReturnTypeKeySelector();
                final Func1 mapBatchTypeToResponseType = self.getBatchReturnTypeToResponseTypeMapper();
                final HashMap requestsByKey = new HashMap(requests.size());
                for (HystrixCollapser.CollapsedRequest cr : requests) {
                    requestsByKey.put(requestKeySelector.call(cr.getArgument()), cr);
                }
                return batchResponse.flatMap(new Func1<BatchReturnType, Observable<Void>>(){

                    public Observable<Void> call(BatchReturnType r) {
                        Object responseKey = batchResponseKeySelector.call(r);
                        HystrixCollapser.CollapsedRequest requestForResponse = (HystrixCollapser.CollapsedRequest)requestsByKey.get(responseKey);
                        requestForResponse.setResponse(mapBatchTypeToResponseType.call(r));
                        requestsByKey.remove(responseKey);
                        return Observable.empty();
                    }
                }).doOnTerminate(new Action0(){

                    public void call() {
                        for (HystrixCollapser.CollapsedRequest cr : requestsByKey.values()) {
                            HystrixObservableCollapser.this.onMissingResponse(cr);
                        }
                    }
                });
            }

            @Override
            public HystrixCollapserKey getCollapserKey() {
                return self.getCollapserKey();
            }
        };
    }

    private HystrixCollapserProperties getProperties() {
        return this.collapserFactory.getProperties();
    }

    public HystrixCollapserKey getCollapserKey() {
        return this.collapserFactory.getCollapserKey();
    }

    public Scope getScope() {
        return Scope.valueOf(this.collapserFactory.getScope().name());
    }

    public HystrixCollapserMetrics getMetrics() {
        return this.metrics;
    }

    public abstract RequestArgumentType getRequestArgument();

    protected abstract HystrixObservableCommand<BatchReturnType> createCommand(Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> var1);

    protected Collection<Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>>> shardRequests(Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
        return Collections.singletonList(requests);
    }

    protected abstract Func1<BatchReturnType, K> getBatchReturnTypeKeySelector();

    protected abstract Func1<RequestArgumentType, K> getRequestArgumentKeySelector();

    protected abstract void onMissingResponse(HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType> var1);

    protected abstract Func1<BatchReturnType, ResponseType> getBatchReturnTypeToResponseTypeMapper();

    @Override
    public Observable<ResponseType> observe() {
        ReplaySubject subject = ReplaySubject.create();
        this.toObservable().subscribe((Observer)subject);
        return subject;
    }

    @Override
    public Observable<ResponseType> toObservable() {
        return this.toObservable(Schedulers.computation());
    }

    public Observable<ResponseType> toObservable(Scheduler observeOn) {
        Observable fromCache;
        if (this.getProperties().requestCacheEnabled().get().booleanValue() && (fromCache = this.requestCache.get(this.getCacheKey())) != null) {
            this.metrics.markResponseFromCache();
            return fromCache;
        }
        RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> requestCollapser = this.collapserFactory.getRequestCollapser(this.collapserInstanceWrapper);
        Observable response = requestCollapser.submitRequest(this.getRequestArgument());
        this.metrics.markRequestBatched();
        if (this.getProperties().requestCacheEnabled().get().booleanValue()) {
            Observable o = response.cache();
            Observable fromCache2 = this.requestCache.putIfAbsent(this.getCacheKey(), o);
            response = fromCache2 == null ? o : fromCache2;
        }
        return response;
    }

    protected String getCacheKey() {
        return null;
    }

    static void reset() {
        RequestCollapserFactory.reset();
    }

    private static String getDefaultNameFromClass(Class<? extends HystrixObservableCollapser> cls) {
        String fromCache = defaultNameCache.get(cls);
        if (fromCache != null) {
            return fromCache;
        }
        String name = cls.getSimpleName();
        if (name.equals("")) {
            name = cls.getName();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
        }
        defaultNameCache.put(cls, name);
        return name;
    }

    public static class Setter {
        private final HystrixCollapserKey collapserKey;
        private Scope scope = Scope.REQUEST;
        private HystrixCollapserProperties.Setter propertiesSetter;

        private Setter(HystrixCollapserKey collapserKey) {
            this.collapserKey = collapserKey;
        }

        public static Setter withCollapserKey(HystrixCollapserKey collapserKey) {
            return new Setter(collapserKey);
        }

        public Setter andScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Setter andCollapserPropertiesDefaults(HystrixCollapserProperties.Setter propertiesSetter) {
            this.propertiesSetter = propertiesSetter;
            return this;
        }
    }

    public static enum Scope implements RequestCollapserFactory.Scope
    {
        REQUEST,
        GLOBAL;

    }
}

