/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import java.util.concurrent.ConcurrentHashMap;

public interface HystrixThreadPoolKey {
    public String name();

    public static class Factory {
        private static ConcurrentHashMap<String, HystrixThreadPoolKey> intern = new ConcurrentHashMap();

        private Factory() {
        }

        public static HystrixThreadPoolKey asKey(String name) {
            HystrixThreadPoolKey k = intern.get(name);
            if (k == null) {
                intern.putIfAbsent(name, new HystrixThreadPoolKeyDefault(name));
            }
            return intern.get(name);
        }

        private static class HystrixThreadPoolKeyDefault
        implements HystrixThreadPoolKey {
            private String name;

            private HystrixThreadPoolKeyDefault(String name) {
                this.name = name;
            }

            @Override
            public String name() {
                return this.name;
            }
        }
    }
}

