/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.dashboard.stream;

import com.netflix.hystrix.dashboard.stream.ProxyStreamServlet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProxyStreamServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ProxyStreamServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String origin = request.getParameter("origin");
        String authorization = request.getParameter("authorization");
        if (origin == null) {
            response.setStatus(500);
            response.getWriter().println("Required parameter 'origin' missing. Example: 107.20.175.135:7001");
            return;
        }
        origin = origin.trim();
        HttpGet httpget = null;
        InputStream is = null;
        boolean hasFirstParameter = false;
        StringBuilder url = new StringBuilder();
        if (!origin.startsWith("http")) {
            url.append("http://");
        }
        url.append(origin);
        if (origin.contains("?")) {
            hasFirstParameter = true;
        }
        Map params = request.getParameterMap();
        for (String key : params.keySet()) {
            if (key.equals("origin") || key.equals("authorization")) continue;
            String[] values = (String[])params.get(key);
            String value = values[0].trim();
            if (hasFirstParameter) {
                url.append("&");
            } else {
                url.append("?");
                hasFirstParameter = true;
            }
            url.append(key).append("=").append(value);
        }
        String proxyUrl = url.toString();
        logger.info("\n\nProxy opening connection to: {}\n\n", (Object)proxyUrl);
        try {
            HttpClient client;
            HttpResponse httpResponse;
            int statusCode;
            httpget = new HttpGet(proxyUrl);
            if (authorization != null) {
                httpget.addHeader("Authorization", authorization);
            }
            if ((statusCode = (httpResponse = (client = ProxyConnectionManager.access$000()).execute((HttpUriRequest)httpget)).getStatusLine().getStatusCode()) != 200) return;
            is = httpResponse.getEntity().getContent();
            for (Header header : httpResponse.getAllHeaders()) {
                if ("Transfer-Encoding".equals(header.getName())) continue;
                response.addHeader(header.getName(), header.getValue());
            }
            ServletOutputStream os = response.getOutputStream();
            int b = -1;
            while ((b = is.read()) != -1) {
                try {
                    os.write(b);
                    if (b != 10) continue;
                    os.flush();
                }
                catch (Exception e) {
                    if (!e.getClass().getSimpleName().equalsIgnoreCase("ClientAbortException")) throw new RuntimeException(e);
                    logger.debug("Connection closed by client. Will stop proxying ...");
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error proxying request: " + url, (Throwable)e);
            return;
        }
        finally {
            if (httpget != null) {
                try {
                    httpget.abort();
                }
                catch (Exception e) {
                    logger.error("failed aborting proxy connection.", (Throwable)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }
}

