/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils.ajc;

import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.aspectj.lang.reflect.MethodSignature;

public final class AjcUtils {
    private AjcUtils() {
        throw new UnsupportedOperationException("it's prohibited to create instances of this class");
    }

    public static Method getAjcMethod(Class<?> target, String methodName, AdviceType adviceType, Class<?> ... pTypes) {
        for (Method method : target.getDeclaredMethods()) {
            if (!method.getName().startsWith(methodName + adviceType.getPostfix()) || !Modifier.isFinal(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (pTypes.length == 0 && parameterTypes.length == 0) {
                return method;
            }
            if (pTypes.length != parameterTypes.length - 2) continue;
            boolean match = true;
            Class<?>[] origParamTypes = AjcUtils.removeAspectjArgs(parameterTypes);
            int index = 0;
            for (Class<?> pType : origParamTypes) {
                Class<?> expected;
                if (pType == (expected = pTypes[index++])) continue;
                match = false;
            }
            if (!match) continue;
            return method;
        }
        if (target.getSuperclass() != null) {
            return AjcUtils.getAjcMethod(target.getSuperclass(), methodName, adviceType, pTypes);
        }
        return null;
    }

    public static Method getAjcMethodAroundAdvice(Class<?> target, String methodName, Class<?> ... pTypes) {
        return AjcUtils.getAjcMethod(target, methodName, AdviceType.Around, pTypes);
    }

    public static Method getAjcMethodAroundAdvice(Class<?> target, MethodSignature signature) {
        return AjcUtils.getAjcMethodAroundAdvice(target, signature.getMethod().getName(), signature.getParameterTypes());
    }

    public static Method getAjcMethodAroundAdvice(Class<?> target, Method method) {
        return AjcUtils.getAjcMethodAroundAdvice(target, method.getName(), method.getParameterTypes());
    }

    public static Object invokeAjcMethod(Method method, Object target, MetaHolder metaHolder, Object ... args) throws InvocationTargetException, IllegalAccessException {
        method.setAccessible(true);
        Object[] extArgs = new Object[args.length + 2];
        extArgs[0] = target;
        System.arraycopy(args, 0, extArgs, 1, args.length);
        extArgs[extArgs.length - 1] = metaHolder.getJoinPoint();
        return method.invoke(target, extArgs);
    }

    private static Class<?>[] removeAspectjArgs(Class<?>[] parameterTypes) {
        Class[] origParamTypes = new Class[parameterTypes.length - 2];
        System.arraycopy(parameterTypes, 1, origParamTypes, 0, parameterTypes.length - 2);
        return origParamTypes;
    }

    public static enum AdviceType {
        Around("_aroundBody");

        private String postfix;

        private AdviceType(String postfix) {
            this.postfix = postfix;
        }

        public String getPostfix() {
            return this.postfix;
        }
    }
}

