/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.command.AbstractHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandBuilder;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.exception.ExceptionUtils;
import com.netflix.hystrix.contrib.javanica.exception.FallbackInvocationException;
import com.netflix.hystrix.contrib.javanica.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BatchHystrixCommand
extends AbstractHystrixCommand<List<Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchHystrixCommand.class);

    public BatchHystrixCommand(HystrixCommandBuilder builder) {
        super(builder);
    }

    @Override
    protected List<Object> run() throws Exception {
        Object[] args = this.toArgs(this.getCollapsedRequests());
        return (List)this.process(args);
    }

    private Object process(final Object[] args) throws Exception {
        return this.process(new AbstractHystrixCommand.Action(){

            @Override
            Object execute() {
                return BatchHystrixCommand.this.getCommandAction().executeWithArgs(BatchHystrixCommand.this.getExecutionType(), args);
            }
        });
    }

    @Override
    protected List<Object> getFallback() {
        if (this.getFallbackAction() != null) {
            final CommandAction commandAction = this.getFallbackAction();
            try {
                return (List)this.process(new AbstractHystrixCommand.Action(){

                    @Override
                    Object execute() {
                        MetaHolder metaHolder = commandAction.getMetaHolder();
                        Object[] args = BatchHystrixCommand.this.toArgs(BatchHystrixCommand.this.getCollapsedRequests());
                        args = CommonUtils.createArgsForFallback(args, metaHolder, BatchHystrixCommand.this.getExecutionException());
                        return commandAction.executeWithArgs(commandAction.getMetaHolder().getFallbackExecutionType(), args);
                    }
                });
            }
            catch (Throwable e) {
                LOGGER.error(AbstractHystrixCommand.FallbackErrorMessageBuilder.create().append(commandAction, e).build());
                throw new FallbackInvocationException(ExceptionUtils.unwrapCause(e));
            }
        }
        return (List)super.getFallback();
    }

    private Object[] toArgs(Collection<HystrixCollapser.CollapsedRequest<Object, Object>> requests) {
        return new Object[]{this.collect(requests)};
    }

    private List<Object> collect(Collection<HystrixCollapser.CollapsedRequest<Object, Object>> requests) {
        ArrayList<Object> commandArgs = new ArrayList<Object>();
        for (HystrixCollapser.CollapsedRequest<Object, Object> request : requests) {
            Object[] args = (Object[])request.getArgument();
            commandArgs.add(args[0]);
        }
        return commandArgs;
    }
}

