/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.data;

import com.netflix.turbine.data.DataFromSingleInstance;
import com.netflix.turbine.data.StatsRollingNumber;
import com.netflix.turbine.data.TurbineData;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import com.netflix.turbine.utils.AppDeploymentConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.util.MinimalPrettyPrinter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggDataFromCluster
extends TurbineData {
    private static final Logger logger = LoggerFactory.getLogger(AggDataFromCluster.class);
    private static final String reportingHosts = "reportingHosts";
    private ConcurrentHashMap<String, HostDataHolder> reportingHostsWithLastData = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> numericAttributes = new ConcurrentHashMap();
    private ConcurrentHashMap<String, StringDataValue> stringAttributes = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> nestedMapAttributes = new ConcurrentHashMap();
    private final ObjectReader objectReader;
    private final ObjectWriter objectWriter;

    public AggDataFromCluster(TurbineDataMonitor<AggDataFromCluster> monitor, String type, String name) {
        super(monitor, type, name);
        ObjectMapper objectMapper = new ObjectMapper();
        this.objectReader = objectMapper.reader(Map.class);
        this.objectWriter = objectMapper.prettyPrintingWriter((PrettyPrinter)new MinimalPrettyPrinter());
    }

    @Override
    public HashMap<String, Long> getNumericAttributes() {
        HashMap<String, Long> values = new HashMap<String, Long>();
        for (String attributeName : this.numericAttributes.keySet()) {
            AtomicLong nValue = this.numericAttributes.get(attributeName);
            if (nValue == null) continue;
            values.put(attributeName, nValue.get());
        }
        return values;
    }

    @Override
    public HashMap<String, String> getStringAttributes() {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String attributeName : this.stringAttributes.keySet()) {
            StringDataValue sValue = this.stringAttributes.get(attributeName);
            if (sValue == null) continue;
            values.put(attributeName, sValue.getValue());
        }
        return values;
    }

    @Override
    public HashMap<String, Map<String, ? extends Number>> getNestedMapAttributes() {
        HashMap<String, Map<String, ? extends Number>> values = new HashMap<String, Map<String, ? extends Number>>();
        for (String nestedAttrName : this.nestedMapAttributes.keySet()) {
            HashMap<String, Long> nestedMap = new HashMap<String, Long>();
            ConcurrentHashMap<String, AtomicLong> concurrentMap = this.nestedMapAttributes.get(nestedAttrName);
            for (String attrName : concurrentMap.keySet()) {
                nestedMap.put(attrName, concurrentMap.get(attrName).longValue());
            }
            values.put(nestedAttrName, nestedMap);
        }
        return values;
    }

    public int getReportingHostsCount() {
        return this.reportingHostsWithLastData.keySet().size();
    }

    public void performPostProcessing() {
        Long sum = 0L;
        for (HostDataHolder holder : this.reportingHostsWithLastData.values()) {
            sum = sum + holder.numReportingHosts.get();
        }
        this.numericAttributes.put(reportingHosts, new AtomicLong(sum));
    }

    public String getReportingDataDebug() {
        StringBuilder sb = new StringBuilder();
        Long sum = 0L;
        for (String hostname : this.reportingHostsWithLastData.keySet()) {
            sb.append(" " + hostname);
            HostDataHolder holder = this.reportingHostsWithLastData.get(hostname);
            sb.append("= " + holder.numReportingHosts.get());
            sb.append(", " + (System.currentTimeMillis() - holder.lastEventTime.get()) + "ms");
            sum = sum + holder.numReportingHosts.get();
        }
        sb.append(" Total: " + sum);
        return sb.toString();
    }

    public void addStatsDataFromSingleServer(DataFromSingleInstance data) {
        long latency;
        HostDataHolder historicalDataHolder = this.reportingHostsWithLastData.get(data.getHost().getHostname());
        if (historicalDataHolder == null && (historicalDataHolder = this.reportingHostsWithLastData.putIfAbsent(data.getHost().getHostname(), new HostDataHolder())) == null) {
            historicalDataHolder = this.reportingHostsWithLastData.get(data.getHost().getHostname());
        }
        historicalDataHolder.lastEventTime.set(System.currentTimeMillis());
        DataFromSingleInstance historical = historicalDataHolder.lastData.get();
        if (logger.isDebugEnabled() && (latency = System.currentTimeMillis() - data.getCreationTime()) > 1L && logger.isDebugEnabled()) {
            logger.debug("Latency on SingleInstanceData: " + latency);
        }
        this.aggregateNumericMap(data.getNumericAttributes(), this.numericAttributes, historical != null ? historical.getNumericAttributes() : null);
        if (data.getNestedMapAttributes().size() > 0) {
            for (String nestedMapKey : data.getNestedMapAttributes().keySet()) {
                HashMap<String, Map<String, ? extends Number>> historicalNestedMapAttrs;
                ConcurrentHashMap<String, AtomicLong> aggNestedMap = this.nestedMapAttributes.get(nestedMapKey);
                if (aggNestedMap == null) {
                    aggNestedMap = new ConcurrentHashMap();
                    this.nestedMapAttributes.putIfAbsent(nestedMapKey, aggNestedMap);
                    aggNestedMap = this.nestedMapAttributes.get(nestedMapKey);
                }
                Map<String, ? extends Number> sourceMap = data.getNestedMapAttributes().get(nestedMapKey);
                Map<String, ? extends Number> historicalNestedMap = null;
                if (historical != null && (historicalNestedMapAttrs = historical.getNestedMapAttributes()) != null) {
                    historicalNestedMap = historicalNestedMapAttrs.get(nestedMapKey);
                }
                this.aggregateNumericMap(sourceMap, aggNestedMap, historicalNestedMap);
            }
        }
        HashMap<String, String> sAttrs = data.getStringAttributes();
        for (String attributeName : sAttrs.keySet()) {
            StringDataValue stringValue = this.stringAttributes.get(attributeName);
            if (stringValue == null) {
                this.stringAttributes.putIfAbsent(attributeName, new StringDataValue());
                stringValue = this.stringAttributes.get(attributeName);
            }
            String historicalStringValue = null;
            if (historical != null) {
                historicalStringValue = historical.getStringAttributes().get(attributeName);
            }
            stringValue.setValue(sAttrs.get(attributeName), historicalStringValue);
        }
        historicalDataHolder.lastData.set(data);
        historicalDataHolder.numReportingHosts.set(data.getNumericAttributes().get(reportingHosts));
        historicalDataHolder.hostActivityCounter.increment(StatsRollingNumber.Type.EVENT_PROCESSED);
    }

    private void aggregateNumericMap(Map<String, ? extends Number> sourceAttrs, ConcurrentHashMap<String, AtomicLong> targetAttrs, Map<String, ? extends Number> historicalAttrs) {
        for (String attributeName : sourceAttrs.keySet()) {
            Number historicalNumericalValue;
            AtomicLong sum = targetAttrs.get(attributeName);
            if (sum == null) {
                targetAttrs.putIfAbsent(attributeName, new AtomicLong(0L));
                sum = targetAttrs.get(attributeName);
            }
            int valueToAdd = sourceAttrs.get(attributeName).intValue();
            if (historicalAttrs != null && (historicalNumericalValue = historicalAttrs.get(attributeName)) != null) {
                valueToAdd -= historicalNumericalValue.intValue();
            }
            sum.addAndGet(valueToAdd);
            long sumVal = sum.get();
            if (sumVal >= 0L) continue;
            sum.compareAndSet(sumVal, 0L);
        }
    }

    public void removeDataForHost(Instance host) {
        HostDataHolder historicalDataHolder = this.reportingHostsWithLastData.remove(host.getHostname());
        if (historicalDataHolder == null || historicalDataHolder.lastData.get() == null) {
            return;
        }
        DataFromSingleInstance historical = historicalDataHolder.lastData.get();
        this.removeNumericAttributes(historical.getNumericAttributes(), this.numericAttributes);
        HashMap<String, Map<String, ? extends Number>> historicalNestedMapAttrs = historical.getNestedMapAttributes();
        if (historicalNestedMapAttrs != null && historicalNestedMapAttrs.keySet().size() > 0) {
            for (String nestedKey : historicalNestedMapAttrs.keySet()) {
                this.removeNumericAttributes((Map)historicalNestedMapAttrs.get(nestedKey), this.nestedMapAttributes.get(nestedKey));
            }
        }
        HashMap<String, String> sAttrs = historical.getStringAttributes();
        for (String attributeName : sAttrs.keySet()) {
            StringDataValue stringValue = this.stringAttributes.get(attributeName);
            if (stringValue == null) continue;
            stringValue.setValue(null, sAttrs.get(attributeName));
        }
    }

    private void removeNumericAttributes(Map<String, ? extends Number> historicalAttrs, ConcurrentHashMap<String, AtomicLong> targetAttrs) {
        if (historicalAttrs == null || targetAttrs == null) {
            return;
        }
        for (String attributeName : historicalAttrs.keySet()) {
            Number numericValue = historicalAttrs.get(attributeName);
            AtomicLong sum = targetAttrs.get(attributeName);
            if (sum == null) continue;
            int valueToRemove = numericValue.intValue();
            sum.addAndGet(valueToRemove * -1);
        }
    }

    public AtomicLong putIfAbsent(String key, Long value) {
        return this.numericAttributes.putIfAbsent(key, new AtomicLong(value));
    }

    public static class UnitTest {
        @Mock
        volatile TurbineDataMonitor<AggDataFromCluster> monitor;
        @Mock
        volatile TurbineDataMonitor<DataFromSingleInstance> hostMonitor;
        String name = "TEST_STATS_DATA";
        volatile AggDataFromCluster clusterData = new AggDataFromCluster(this.monitor, "TEST_TYPE", this.name);
        final String[] arrayNumeric = new String[]{"A", "B", "C", "D", "E", "F"};
        final String[] arrayString = new String[]{"G", "H", "I", "J", "K", "L"};

        @Test
        public void testCombineDataUsingMultipleThreads() throws Exception {
            int numThreads = 50;
            ArrayList<TestWorker> workers = new ArrayList<TestWorker>(numThreads);
            ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
            for (int i = 0; i < numThreads; ++i) {
                TestWorker worker = new TestWorker();
                workers.add(worker);
                threadPool.submit(worker);
            }
            Thread.sleep(3000L);
            threadPool.shutdownNow();
            this.clusterData.performPostProcessing();
            boolean terminated = threadPool.awaitTermination(100L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)"Threadpool NOT terminated!", (boolean)terminated);
            System.out.println("Num reporting hosts: " + this.clusterData.getReportingHostsCount());
            Assert.assertEquals((long)numThreads, (long)this.clusterData.getReportingHostsCount());
            int totalEvents = 0;
            HashMap<String, Long> totalSum = new HashMap<String, Long>();
            List<String> stringAttrs = Arrays.asList(this.arrayString);
            HashMap strAttrsMap = new HashMap();
            for (String strAttr : stringAttrs) {
                strAttrsMap.put(strAttr, new HashMap());
            }
            for (TestWorker worker : workers) {
                totalEvents += worker.events;
                worker.addLastNumericValuesToMap(totalSum);
                for (String strAttr : stringAttrs) {
                    worker.addLastStringValuesToMap(strAttr, (Map)strAttrsMap.get(strAttr));
                }
            }
            int recordedEvents = 0;
            for (HostDataHolder dataHolder : this.clusterData.reportingHostsWithLastData.values()) {
                recordedEvents += dataHolder.hostActivityCounter.getCount(StatsRollingNumber.Type.EVENT_PROCESSED);
            }
            System.out.println("Total events: " + totalEvents);
            System.out.println("Num events records: " + recordedEvents);
            totalSum.put(AggDataFromCluster.reportingHosts, Long.valueOf(workers.size()));
            Assert.assertEquals((long)totalEvents, (long)recordedEvents);
            System.out.println(this.clusterData.getNumericAttributes());
            System.out.println(totalSum);
            Assert.assertEquals(totalSum, this.clusterData.getNumericAttributes());
            HashMap<String, String> formattedMap = new HashMap<String, String>();
            for (String strAttr : stringAttrs) {
                formattedMap.put(strAttr, this.getFormattedString((Map)strAttrsMap.get(strAttr)));
            }
            System.out.println(this.clusterData.getStringAttributes());
            System.out.println(formattedMap);
            Assert.assertEquals(formattedMap, this.clusterData.getStringAttributes());
            Map<String, ? extends Number> nestedAttrs1 = this.clusterData.getNestedMapAttributes().get("nested1");
            Assert.assertTrue((500 == nestedAttrs1.get("N1").intValue() ? 1 : 0) != 0);
            Assert.assertTrue((550 == nestedAttrs1.get("N2").intValue() ? 1 : 0) != 0);
            Map<String, ? extends Number> nestedAttrs2 = this.clusterData.getNestedMapAttributes().get("nested2");
            Assert.assertTrue((500 == nestedAttrs2.get("N3").intValue() ? 1 : 0) != 0);
            Assert.assertTrue((550 == nestedAttrs2.get("N4").intValue() ? 1 : 0) != 0);
            threadPool = Executors.newFixedThreadPool(numThreads);
            for (final TestWorker testWorker : workers) {
                threadPool.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        UnitTest.this.clusterData.removeDataForHost(testWorker.host);
                        return null;
                    }
                });
            }
            threadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this.clusterData.performPostProcessing();
            System.out.println(this.clusterData.getNumericAttributes());
            System.out.println(this.clusterData.getStringAttributes());
            System.out.println(this.clusterData.getNestedMapAttributes());
            for (Long l : this.clusterData.getNumericAttributes().values()) {
                Assert.assertTrue((l == 0L ? 1 : 0) != 0);
            }
            for (String string : this.clusterData.getStringAttributes().values()) {
                Assert.assertTrue((string.length() == 0 ? 1 : 0) != 0);
            }
            nestedAttrs1 = this.clusterData.getNestedMapAttributes().get("nested1");
            Assert.assertTrue((0 == nestedAttrs1.get("N1").intValue() ? 1 : 0) != 0);
            Assert.assertTrue((0 == nestedAttrs1.get("N2").intValue() ? 1 : 0) != 0);
            nestedAttrs2 = this.clusterData.getNestedMapAttributes().get("nested2");
            Assert.assertTrue((0 == nestedAttrs2.get("N3").intValue() ? 1 : 0) != 0);
            Assert.assertTrue((0 == nestedAttrs2.get("N4").intValue() ? 1 : 0) != 0);
        }

        private String getFormattedString(Map<String, Long> strMap) throws JsonGenerationException, JsonMappingException, IOException {
            ObjectWriter writer = new ObjectMapper().prettyPrintingWriter((PrettyPrinter)new MinimalPrettyPrinter());
            return writer.writeValueAsString(strMap);
        }

        private class TestWorker
        implements Callable<Void> {
            final Instance host = new Instance(UUID.randomUUID().toString(), "cluster", true);
            final Random random = new Random();
            final List<String> testNumericAttrNames;
            final List<String> testStringAttrNames;
            volatile Map<String, Long> lastNumericValues;
            volatile Map<String, String> lastStringValues;
            volatile int events;
            volatile boolean stopped;

            private TestWorker() {
                this.testNumericAttrNames = Arrays.asList(UnitTest.this.arrayNumeric);
                this.testStringAttrNames = Arrays.asList(UnitTest.this.arrayString);
                this.lastNumericValues = new HashMap<String, Long>();
                this.lastStringValues = new HashMap<String, String>();
                this.stopped = false;
            }

            @Override
            public Void call() throws Exception {
                while (!this.stopped) {
                    try {
                        DataFromSingleInstance singleInstanceData = this.getDataForSingleInstance();
                        UnitTest.this.clusterData.addStatsDataFromSingleServer(singleInstanceData);
                        ++this.events;
                        this.lastNumericValues.clear();
                        for (String key : singleInstanceData.getNumericAttributes().keySet()) {
                            this.lastNumericValues.put(key, singleInstanceData.getNumericAttributes().get(key));
                        }
                        this.lastStringValues.clear();
                        for (String key : singleInstanceData.getStringAttributes().keySet()) {
                            this.lastStringValues.put(key, singleInstanceData.getStringAttributes().get(key));
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.stopped = true;
                    }
                }
                return null;
            }

            private DataFromSingleInstance getDataForSingleInstance() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String attrName : this.testNumericAttrNames) {
                    map.put(attrName, this.random.nextInt(10));
                }
                map.put(AggDataFromCluster.reportingHosts, 1);
                for (String attrName : this.testStringAttrNames) {
                    map.put(attrName, "s" + String.valueOf(this.random.nextInt(2)));
                }
                HashMap<String, Integer> nestedMap = new HashMap<String, Integer>();
                nestedMap.put("N1", 10);
                nestedMap.put("N2", 11);
                HashMap<String, Integer> nestedMap2 = new HashMap<String, Integer>();
                nestedMap2.put("N3", 10);
                nestedMap2.put("N4", 11);
                map.put("nested1", nestedMap);
                map.put("nested2", nestedMap2);
                DataFromSingleInstance data = new DataFromSingleInstance(UnitTest.this.hostMonitor, "TEST_TYPE", UnitTest.this.name, this.host, map, 1L);
                return data;
            }

            private void addLastNumericValuesToMap(Map<String, Long> theMap) {
                for (String key : this.lastNumericValues.keySet()) {
                    Long prevValue = theMap.get(key);
                    if (prevValue == null) {
                        prevValue = 0L;
                    }
                    theMap.put(key, prevValue + this.lastNumericValues.get(key));
                }
            }

            private void addLastStringValuesToMap(String attrName, Map<String, Long> theMap) {
                String attrValue = this.lastStringValues.get(attrName);
                if (attrValue != null) {
                    Long prevCount = theMap.get(attrValue);
                    if (prevCount == null) {
                        prevCount = 0L;
                    }
                    theMap.put(attrValue, prevCount + 1L);
                }
            }
        }
    }

    private static class HostDataHolder {
        public AtomicReference<DataFromSingleInstance> lastData = new AtomicReference();
        public final AtomicReference<Long> numReportingHosts = new AtomicReference<Long>(0L);
        public final AtomicReference<Long> lastEventTime = new AtomicReference<Long>(0L);
        public StatsRollingNumber hostActivityCounter = new StatsRollingNumber(10000, 10);

        private HostDataHolder() {
        }
    }

    private class StringDataValue {
        private ConcurrentHashMap<String, AtomicLong> valueCounts = new ConcurrentHashMap();
        private static final String OPEN_BRACE = "{";
        private static final String EMPTY_STRING = "";

        private StringDataValue() {
        }

        public void setValue(String newValue, String oldValue) {
            if (oldValue != null) {
                this.setValue(oldValue, true);
            }
            if (newValue != null) {
                this.setValue(newValue, false);
            }
        }

        private void setValue(String value, boolean decrement) {
            if (AppDeploymentConfig.aggMode == AppDeploymentConfig.AggregatorMode.MULTI_ZONE && value.startsWith(OPEN_BRACE)) {
                try {
                    Map json = (Map)AggDataFromCluster.this.objectReader.readValue(value);
                    for (String key : json.keySet()) {
                        int keyCount = (Integer)json.get(key);
                        AtomicLong valueCount = this.valueCounts.get(key);
                        if (decrement) {
                            if (valueCount == null) continue;
                            valueCount.addAndGet(-1 * keyCount);
                            continue;
                        }
                        if (valueCount == null) {
                            this.valueCounts.putIfAbsent(key, new AtomicLong(0L));
                            valueCount = this.valueCounts.get(key);
                        }
                        valueCount.addAndGet(keyCount);
                    }
                }
                catch (Throwable t) {}
            } else {
                AtomicLong valueCount = this.valueCounts.get(value);
                if (decrement) {
                    if (valueCount != null) {
                        valueCount.decrementAndGet();
                    }
                } else {
                    if (valueCount == null) {
                        this.valueCounts.putIfAbsent(value, new AtomicLong(0L));
                        valueCount = this.valueCounts.get(value);
                    }
                    valueCount.incrementAndGet();
                }
            }
        }

        public String getValue() {
            if (this.valueCounts.keySet().size() == 1) {
                return String.valueOf(this.valueCounts.keySet().toArray()[0]);
            }
            HashMap<String, Long> temp = new HashMap<String, Long>();
            for (String value : this.valueCounts.keySet()) {
                temp.put(value, this.valueCounts.get(value).get());
            }
            HashSet keys = new HashSet(temp.keySet());
            for (String key : keys) {
                if ((Long)temp.get(key) > 0L) continue;
                temp.remove(key);
            }
            if (temp.keySet().size() == 0) {
                return EMPTY_STRING;
            }
            if (temp.keySet().size() == 1) {
                return String.valueOf(temp.keySet().toArray()[0]);
            }
            try {
                return AggDataFromCluster.this.objectWriter.writeValueAsString(temp);
            }
            catch (JsonGenerationException e) {
            }
            catch (JsonMappingException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return EMPTY_STRING;
        }
    }
}

