/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.data;

import com.netflix.turbine.data.DataFromSingleInstance;
import com.netflix.turbine.data.StatsRollingNumber;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class TurbineData {
    protected final Key key;
    private final TurbineDataMonitor<?> monitor;
    private long creationTime;

    public TurbineData(TurbineDataMonitor<?> monitor, String type, String name) {
        this.monitor = monitor;
        this.key = new Key(type, name);
        this.creationTime = System.currentTimeMillis();
    }

    public Key getKey() {
        return this.key;
    }

    public String getType() {
        return this.key.getType();
    }

    public String getName() {
        return this.key.getName();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
    }

    public StatsRollingNumber getRolling2MinuteStats() {
        return this.monitor.getRolling2MinuteStats(this);
    }

    public TurbineDataMonitor<?> getMonitor() {
        return this.monitor;
    }

    public abstract HashMap<String, Long> getNumericAttributes();

    public abstract HashMap<String, String> getStringAttributes();

    public abstract HashMap<String, Map<String, ? extends Number>> getNestedMapAttributes();

    public Map<String, Object> getAttributes() {
        HashMap<String, String> stringAttributes;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("type", this.getType());
        dataMap.put("name", this.getName());
        HashMap<String, Long> numericAttributes = this.getNumericAttributes();
        if (numericAttributes != null) {
            for (String key : numericAttributes.keySet()) {
                dataMap.put(key, numericAttributes.get(key));
            }
        }
        if ((stringAttributes = this.getStringAttributes()) != null) {
            for (String key : stringAttributes.keySet()) {
                String value = stringAttributes.get(key);
                if (value.equals("true") || value.equals("false")) {
                    dataMap.put(key, Boolean.valueOf(value));
                    continue;
                }
                dataMap.put(key, value);
            }
        }
        return dataMap;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "_" + this.getName();
    }

    public static class UnitTest {
        @Test
        public void testDefaultJSON() {
            TestStatsData stats = new TestStatsData("DEFAULT", "testDefaultJSON");
            try {
                Map<String, Object> o = stats.getAttributes();
                Assert.assertEquals((Object)"DEFAULT", (Object)o.get("type"));
                Assert.assertEquals((Object)"testDefaultJSON", (Object)o.get("name"));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        private static class TestStatsData
        extends DataFromSingleInstance {
            public HashMap<String, Long> numericAttributes = new HashMap();
            public HashMap<String, String> stringAttributes = new HashMap();

            public TestStatsData(String type, String name) {
                super(null, type, name, null, new HashMap<String, Object>(), 1L);
            }

            @Override
            public HashMap<String, Long> getNumericAttributes() {
                return this.numericAttributes;
            }

            @Override
            public HashMap<String, String> getStringAttributes() {
                return this.stringAttributes;
            }
        }
    }

    public static class Key {
        private final String name;
        private final String type;

        public Key(String type, String name) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.getType() + "_" + this.getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            boolean equals;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            boolean bl = this.name != null ? this.name.equals(other.name) : (equals = other.name == null);
            return equals &= this.type != null ? this.type.equals(other.type) : other.type == null;
        }
    }
}

