/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.discovery;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.discovery.InstanceDiscovery;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedInstanceDiscovery
implements InstanceDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedInstanceDiscovery.class);
    private final DynamicStringProperty filePath = DynamicPropertyFactory.getInstance().getStringProperty("turbine.FileBasedInstanceDiscovery.filePath", "");
    private final File file = new File(this.filePath.get());

    @Override
    public Collection<Instance> getInstanceList() {
        List lines = null;
        try {
            lines = FileUtils.readLines((File)this.file);
        }
        catch (IOException e) {
            logger.error("Error reading from file, check config property: " + this.filePath.getName() + "=" + this.filePath.get(), (Throwable)e);
        }
        ArrayList<Instance> instances = new ArrayList<Instance>();
        if (lines != null) {
            for (String line : lines) {
                try {
                    instances.add(this.parseInstance(line));
                }
                catch (Exception e) {
                    logger.error("Error reading from file: " + this.filePath.get(), (Throwable)e);
                }
            }
        }
        return instances;
    }

    private Instance parseInstance(String line) throws Exception {
        String[] parts = line.split(",");
        if (parts == null || parts.length != 3) {
            throw new Exception("Bad file format: " + line);
        }
        return new Instance(parts[0], parts[1], parts[2].equalsIgnoreCase("up"));
    }
}

