/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.monitor.cluster;

import com.netflix.turbine.discovery.Instance;
import org.junit.Assert;
import org.junit.Test;

public interface ObservationCriteria {
    public String getName();

    public boolean observeHost(Instance var1);

    public static class ClusterBasedObservationCriteria
    implements ObservationCriteria {
        private final String clusterName;

        public ClusterBasedObservationCriteria(String cluster) {
            this.clusterName = cluster;
        }

        @Override
        public String getName() {
            return this.clusterName;
        }

        @Override
        public boolean observeHost(Instance host) {
            if (this.clusterName == null) {
                return false;
            }
            return this.clusterName.equals(host.getCluster());
        }

        public static class UnitTest {
            @Test
            public void testObserve() throws Exception {
                ClusterBasedObservationCriteria criteria = new ClusterBasedObservationCriteria("cluster1");
                Instance host1 = new Instance("host", "cluster1", true);
                Assert.assertTrue((boolean)criteria.observeHost(host1));
                Instance host2 = new Instance("host", "cluster2", true);
                Assert.assertFalse((boolean)criteria.observeHost(host2));
                Instance host3 = new Instance("host", null, true);
                Assert.assertFalse((boolean)criteria.observeHost(host3));
                ClusterBasedObservationCriteria criteria2 = new ClusterBasedObservationCriteria(null);
                Assert.assertFalse((boolean)criteria2.observeHost(host1));
                Assert.assertFalse((boolean)criteria2.observeHost(host2));
                Assert.assertFalse((boolean)criteria2.observeHost(host3));
            }
        }
    }
}

