/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.monitor.cluster;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeBoundCache<T> {
    private static final Logger logger = LoggerFactory.getLogger(TimeBoundCache.class);
    private final String name;
    private final ConcurrentHashMap<T, AtomicLong> cache;
    private final Timer timer;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private static final DynamicIntProperty expirySeconds = DynamicPropertyFactory.getInstance().getIntProperty("turbine.TimeBoundCache.expirySeconds", 15);
    private static final DynamicIntProperty pollDelaySeconds = DynamicPropertyFactory.getInstance().getIntProperty("turbine.TimeBoundCache.pollDelaySeconds", 5);

    TimeBoundCache(String name) {
        this(name, 300000);
    }

    private TimeBoundCache(String name, int sleepMillisForJanitor) {
        this.name = name;
        this.cache = new ConcurrentHashMap();
        this.timer = new Timer();
    }

    void startCache() throws Exception {
        if (!this.started.get()) {
            CacheJanitor task = new CacheJanitor();
            this.timer.schedule((TimerTask)task, pollDelaySeconds.get() * 1000, (long)(pollDelaySeconds.get() * 1000));
            this.started.set(true);
        }
    }

    void stopCache() {
        this.timer.cancel();
        this.started.set(false);
    }

    void put(T cacheKey) {
        Long currentTime = System.currentTimeMillis();
        while (true) {
            AtomicLong prevKeyTime;
            if ((prevKeyTime = this.cache.get(cacheKey)) != null) {
                Long prevTime = prevKeyTime.get();
                if (currentTime < prevTime) {
                    return;
                }
                boolean success = prevKeyTime.compareAndSet(prevTime, currentTime);
                if (!success) continue;
                return;
            }
            AtomicLong prevTimeObj = this.cache.putIfAbsent(cacheKey, new AtomicLong(currentTime));
            if (prevTimeObj == null) break;
        }
    }

    boolean lookup(T cacheKey) {
        AtomicLong timestamp = this.cache.get(cacheKey);
        return timestamp != null;
    }

    String print() {
        return this.cache.keySet().toString();
    }

    public static class UnitTest {
        private static final List<String> randomStrings = new ArrayList<String>();
        private static final int numStrings = 100;
        private static final TimeBoundCache<String> cache = new TimeBoundCache("test", 100);

        @Test
        public void testCache() throws Exception {
            ConfigurationManager.getConfigInstance().setProperty("turbine.TimeBoundCache.expirySeconds", (Object)2);
            ConfigurationManager.getConfigInstance().setProperty("turbine.TimeBoundCache.pollDelaySeconds", (Object)2);
            int numThreads = 100;
            ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
            for (int i = 0; i < 100; ++i) {
                String randomString = UUID.randomUUID().toString();
                randomStrings.add(randomString);
                cache.put(randomString);
            }
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(numThreads);
            for (int i = 0; i < numThreads; ++i) {
                futures.add(threadPool.submit(new TestWorker(true)));
            }
            cache.startCache();
            Thread.sleep(1000L);
            for (Future future : futures) {
                Assert.assertTrue((boolean)((Boolean)future.get()));
            }
            Thread.sleep(2500L);
            futures.clear();
            for (int i = 0; i < numThreads; ++i) {
                futures.add(threadPool.submit(new TestWorker(false)));
            }
            Thread.sleep(1000L);
            for (Future future : futures) {
                Assert.assertTrue((boolean)((Boolean)future.get()));
            }
            for (String string : randomStrings) {
                cache.put(string);
            }
            futures.clear();
            for (int i = 0; i < numThreads; ++i) {
                futures.add(threadPool.submit(new TestWorker(true)));
            }
            Thread.sleep(1000L);
            for (Future future : futures) {
                Assert.assertTrue((boolean)((Boolean)future.get()));
            }
            cache.stopCache();
        }

        private static class TestWorker
        implements Callable<Boolean> {
            private final boolean expected;

            private TestWorker(boolean expectHit) {
                this.expected = expectHit;
            }

            @Override
            public Boolean call() throws Exception {
                Random random = new Random();
                for (int i = 0; i < 1000; ++i) {
                    int index = random.nextInt(100);
                    String randomString = (String)randomStrings.get(index);
                    boolean hit = cache.lookup(randomString);
                    if (hit == this.expected) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private class CacheJanitor
    extends TimerTask {
        private CacheJanitor() {
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("Checking for stale entries in cache for cluster: " + TimeBoundCache.this.name);
            }
            Long now = System.currentTimeMillis();
            ArrayList markForDeletion = new ArrayList();
            for (Object key : TimeBoundCache.this.cache.keySet()) {
                long delay = now - ((AtomicLong)TimeBoundCache.this.cache.get(key)).get();
                if (delay <= (long)(expirySeconds.get() * 1000)) continue;
                markForDeletion.add(key);
            }
            for (Object key : markForDeletion) {
                TimeBoundCache.this.cache.remove(key);
            }
        }
    }
}

