/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThreadSafeMultiMap<K, V> {
    private ConcurrentHashMap<K, ConcurrentHashMap<V, V>> mapOfMaps = new ConcurrentHashMap();

    public V putIfAbsent(K key, V value) {
        V oldValue;
        ConcurrentHashMap<V, V> oldMapValue;
        ConcurrentHashMap<Object, V> innerMap = this.mapOfMaps.get(key);
        if (innerMap == null && (oldMapValue = this.mapOfMaps.putIfAbsent(key, innerMap = new ConcurrentHashMap())) != null) {
            innerMap = oldMapValue;
        }
        if ((oldValue = innerMap.get(value)) == null) {
            oldValue = innerMap.putIfAbsent(value, value);
            return oldValue;
        }
        return oldValue;
    }

    public V remove(K key, V value) {
        ConcurrentHashMap<V, V> innerMap = this.mapOfMaps.get(key);
        if (innerMap == null) {
            return null;
        }
        return innerMap.remove(value);
    }

    public Set<K> keySet() {
        return this.mapOfMaps.keySet();
    }

    public List<V> getValues(K key) {
        ConcurrentHashMap<V, V> innerMap = this.mapOfMaps.get(key);
        if (innerMap == null) {
            return null;
        }
        return new ArrayList<V>(innerMap.values());
    }

    public V getValue(K key, V value) {
        ConcurrentHashMap<V, V> innerMap = this.mapOfMaps.get(key);
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(value);
    }

    public static class UnitTest {
        private ThreadSafeMultiMap<String, Integer> multiMap;
        private List<String> input;
        private volatile boolean stopped;
        private ExecutorService producerPool;
        private int numKeys = 100;
        private int numProducers = 100;

        @Before
        public void before() {
            this.multiMap = new ThreadSafeMultiMap();
            this.input = new ArrayList<String>(this.numKeys);
            for (int i = 0; i < this.numKeys; ++i) {
                this.input.add(UUID.randomUUID().toString());
            }
            this.stopped = false;
            this.producerPool = Executors.newFixedThreadPool(this.numProducers);
        }

        @Test
        public void testAddKeysAtRandom() throws Exception {
            ArrayList<Future<Map<String, Set<Integer>>>> futures = new ArrayList<Future<Map<String, Set<Integer>>>>();
            for (int i = 0; i < this.numProducers; ++i) {
                futures.add(this.producerPool.submit(new AddRandomKeyValue()));
            }
            Thread.sleep(4000L);
            this.stopped = true;
            this.producerPool.shutdown();
            while (!this.producerPool.isTerminated()) {
                Thread.sleep(100L);
            }
            HashMap totalResult = new HashMap();
            for (Future future : futures) {
                Map resultMap = (Map)future.get();
                for (String key : resultMap.keySet()) {
                    Set resultIntegers = (Set)resultMap.get(key);
                    HashSet totalIntegers = (HashSet)totalResult.get(key);
                    if (totalIntegers == null) {
                        totalIntegers = new HashSet();
                        totalResult.put(key, totalIntegers);
                    }
                    totalIntegers.addAll(resultIntegers);
                }
            }
            for (String string : totalResult.keySet()) {
                Set expected = (Set)totalResult.get(string);
                HashSet<Integer> result = new HashSet<Integer>(this.multiMap.getValues(string));
                Assert.assertEquals((Object)expected, result);
            }
        }

        @Test
        public void testRemoveKeysRandomly() throws Exception {
            for (String key : this.input) {
                for (int i = 0; i < this.numKeys; ++i) {
                    this.multiMap.putIfAbsent(key, i);
                }
            }
            ArrayList<Future<Map<String, Integer>>> futures = new ArrayList<Future<Map<String, Integer>>>();
            for (int i = 0; i < this.numProducers; ++i) {
                futures.add(this.producerPool.submit(new RemoveRandomKeyValue()));
            }
            HashMap<String, Integer> totalResult = new HashMap<String, Integer>();
            for (Future future : futures) {
                Map resultMap = (Map)future.get();
                for (String key : resultMap.keySet()) {
                    Integer resultCount = (Integer)resultMap.get(key);
                    Integer totalCount = (Integer)totalResult.get(key);
                    if (totalCount == null) {
                        totalCount = 0;
                    }
                    totalCount = totalCount + resultCount;
                    totalResult.put(key, totalCount);
                }
            }
            for (String string : totalResult.keySet()) {
                Assert.assertTrue((this.numKeys == (Integer)totalResult.get(string) ? 1 : 0) != 0);
            }
            this.producerPool.shutdownNow();
        }

        private class RemoveRandomKeyValue
        implements Callable<Map<String, Integer>> {
            private Map<String, Integer> result = new HashMap<String, Integer>();

            private RemoveRandomKeyValue() {
            }

            @Override
            public Map<String, Integer> call() throws Exception {
                for (String key : UnitTest.this.multiMap.keySet()) {
                    int count = 0;
                    this.result.put(key, count);
                    Random random = new Random();
                    boolean done = false;
                    do {
                        List integers;
                        done = (integers = UnitTest.this.multiMap.getValues(key)).size() == 0;
                        Integer removed = UnitTest.this.multiMap.remove(key, random.nextInt(UnitTest.this.numKeys));
                        if (removed == null) continue;
                        this.result.put(key, this.result.get(key) + 1);
                    } while (!done);
                }
                return this.result;
            }
        }

        private class AddRandomKeyValue
        implements Callable<Map<String, Set<Integer>>> {
            private Map<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
            private Random random = new Random();

            private AddRandomKeyValue() {
            }

            @Override
            public Map<String, Set<Integer>> call() throws Exception {
                while (!UnitTest.this.stopped) {
                    String randomString = (String)UnitTest.this.input.get(this.random.nextInt(UnitTest.this.numKeys));
                    Integer randomInt = this.random.nextInt(UnitTest.this.numKeys);
                    UnitTest.this.multiMap.putIfAbsent(randomString, randomInt);
                    Set<Integer> set = this.result.get(randomString);
                    if (set == null) {
                        set = new HashSet<Integer>();
                        this.result.put(randomString, set);
                    }
                    set.add(randomInt);
                }
                return this.result;
            }
        }
    }
}

