/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.aggregator;

import com.netflix.turbine.internal.JsonUtility;
import com.netflix.turbine.internal.NumberListSerializer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=NumberListSerializer.class)
public class NumberList {
    private final Map<String, Long> numbers;

    public static NumberList create(Map<String, Object> numbers) {
        LinkedHashMap<String, Long> values = new LinkedHashMap<String, Long>(numbers.size());
        for (Map.Entry<String, Object> k : numbers.entrySet()) {
            Object v = k.getValue();
            if (v instanceof Number) {
                values.put(k.getKey(), ((Number)v).longValue());
                continue;
            }
            values.put(k.getKey(), Long.valueOf(String.valueOf(v)));
        }
        return new NumberList(values);
    }

    public static NumberList delta(Map<String, Object> currentMap, NumberList previousMap) {
        return NumberList.delta(currentMap, previousMap.numbers);
    }

    public static NumberList delta(NumberList currentMap, NumberList previousMap) {
        return NumberList.delta(currentMap.numbers, previousMap.numbers);
    }

    public static NumberList delta(Map<String, Object> currentMap, Map<String, Object> previousMap) {
        LinkedHashMap<String, Long> values = new LinkedHashMap<String, Long>(currentMap.size());
        if (currentMap.size() != previousMap.size()) {
            throw new IllegalArgumentException("Maps must have the same keys");
        }
        for (Map.Entry<String, Object> k : currentMap.entrySet()) {
            Object v = k.getValue();
            Number current = NumberList.getNumber(v);
            Object p = previousMap.get(k.getKey());
            Number previous = null;
            previous = p == null ? (Number)0 : (Number)NumberList.getNumber(p);
            long d = current.longValue() - previous.longValue();
            values.put(k.getKey(), d);
        }
        return new NumberList(values);
    }

    public static NumberList deltaInverse(Map<String, Object> map) {
        LinkedHashMap<String, Long> values = new LinkedHashMap<String, Long>(map.size());
        for (Map.Entry<String, Object> k : map.entrySet()) {
            Object v = k.getValue();
            Number current = NumberList.getNumber(v);
            long d = -current.longValue();
            values.put(k.getKey(), d);
        }
        return new NumberList(values);
    }

    public NumberList sum(NumberList delta) {
        LinkedHashMap<String, Long> values = new LinkedHashMap<String, Long>(this.numbers.size());
        for (Map.Entry<String, Long> k : this.numbers.entrySet()) {
            Long p = k.getValue();
            Long d = delta.get(k.getKey());
            Long previous = null;
            previous = p == null ? Long.valueOf(0L) : p;
            if (d == null) {
                d = -previous.longValue();
            }
            long sum = d + previous;
            values.put(k.getKey(), sum);
        }
        return new NumberList(values);
    }

    private static Number getNumber(Object v) {
        Long n = null;
        n = v instanceof Number ? Long.valueOf(((Number)v).longValue()) : Long.valueOf(String.valueOf(v));
        return n;
    }

    public static NumberList empty() {
        return NumberList.create(Collections.emptyMap());
    }

    private NumberList(Map<String, Long> numbers) {
        this.numbers = numbers;
    }

    public Map<String, Long> getMap() {
        return this.numbers;
    }

    public Long get(String key) {
        return this.numbers.get(key);
    }

    public Set<Map.Entry<String, Long>> getEntries() {
        return this.numbers.entrySet();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " => " + this.numbers.entrySet();
    }

    public String toJson() {
        return JsonUtility.mapToJson(this.numbers);
    }
}

