/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Identifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;

@NotThreadSafe
public class ResponseType
extends HashSet<Value> {
    public static ResponseType getDefault() {
        ResponseType defaultResponseType = new ResponseType();
        defaultResponseType.add(Value.CODE);
        return defaultResponseType;
    }

    public ResponseType() {
    }

    public ResponseType(String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            this.add(new Value(v));
            ++n2;
        }
    }

    public ResponseType(Value ... values) {
        this.addAll(Arrays.asList(values));
    }

    public static ResponseType parse(String s) throws ParseException {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new ParseException("Null or empty response type string");
        }
        ResponseType rt = new ResponseType();
        StringTokenizer st = new StringTokenizer(s, " ");
        while (st.hasMoreTokens()) {
            rt.add(new Value(st.nextToken()));
        }
        return rt;
    }

    public boolean impliesCodeFlow() {
        return this.contains(Value.CODE) && this.size() == 1;
    }

    public boolean impliesImplicitFlow() {
        return !this.impliesCodeFlow();
    }

    public boolean contains(String value) {
        return this.contains(new Value(value));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Value v : this) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(v.getValue());
        }
        return sb.toString();
    }

    @Immutable
    public static final class Value
    extends Identifier {
        public static final Value CODE = new Value("code");
        public static final Value TOKEN = new Value("token");

        public Value(String value) {
            super(value);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Value && this.toString().equals(object.toString());
        }
    }
}

