/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.service.captchastore;

import com.octo.captcha.Captcha;
import com.octo.captcha.MockCaptcha;
import com.octo.captcha.service.captchastore.CaptchaStore;
import java.util.Collection;
import java.util.Locale;
import junit.framework.TestCase;

public abstract class CaptchaStoreTestAbstract
extends TestCase {
    protected CaptchaStore store;
    private Captcha captcha;
    public static final int SIZE = 10000;

    protected void setUp() throws Exception {
        super.setUp();
        this.store = this.getStore();
        this.store.initAndStart();
        this.captcha = new MockCaptcha(Locale.getDefault());
    }

    protected void tearDown() {
        this.store.cleanAndShutdown();
    }

    public abstract CaptchaStore getStore();

    public void testHasCaptcha() throws Exception {
        CaptchaStoreTestAbstract.assertFalse((String)"should not have", (boolean)this.store.hasCaptcha("1"));
        this.store.storeCaptcha("2", this.captcha);
        this.store.storeCaptcha("1 ", this.captcha);
        this.store.storeCaptcha(" 1", this.captcha);
        CaptchaStoreTestAbstract.assertFalse((String)"should not have", (boolean)this.store.hasCaptcha("1"));
        this.store.storeCaptcha("1", this.captcha);
        CaptchaStoreTestAbstract.assertTrue((String)"should", (boolean)this.store.hasCaptcha("1"));
    }

    public void testStoreCaptcha() throws Exception {
        int i;
        for (i = 0; i < 10000; ++i) {
            this.store.storeCaptcha(String.valueOf(i), this.captcha);
        }
        for (i = 0; i < 10000; ++i) {
            CaptchaStoreTestAbstract.assertNotNull((Object)this.store.getCaptcha(String.valueOf(i)));
        }
    }

    public void testStoreCaptchaAndLocale() throws Exception {
        int i;
        for (i = 0; i < 10000; ++i) {
            this.store.storeCaptcha(String.valueOf(i), this.captcha, Locale.FRENCH);
        }
        for (i = 0; i < 10000; ++i) {
            CaptchaStoreTestAbstract.assertEquals((Object)Locale.FRENCH, (Object)this.store.getLocale(String.valueOf(i)));
        }
    }

    public void testRemoveCaptcha() throws Exception {
        int i;
        for (i = 0; i < 10000; ++i) {
            this.store.storeCaptcha(String.valueOf(i), this.captcha);
        }
        CaptchaStoreTestAbstract.assertEquals((String)"should have a size of 10000", (int)this.store.getSize(), (int)10000);
        for (i = 0; i < 10000; ++i) {
            CaptchaStoreTestAbstract.assertTrue((String)"Should be removed", (boolean)this.store.removeCaptcha(String.valueOf(i)));
        }
        for (i = 0; i < 10000; ++i) {
            CaptchaStoreTestAbstract.assertFalse((String)"Should not be removed", (boolean)this.store.removeCaptcha(String.valueOf(i)));
        }
        CaptchaStoreTestAbstract.assertTrue((String)"should be empty now", (this.store.getSize() == 0 ? 1 : 0) != 0);
    }

    public void testGetSize() throws Exception {
        int i;
        for (i = 0; i < 10000; ++i) {
            this.store.storeCaptcha(String.valueOf(i), this.captcha);
            CaptchaStoreTestAbstract.assertEquals((String)("Size should be : " + i), (int)(i + 1), (int)this.store.getSize());
        }
        CaptchaStoreTestAbstract.assertEquals((String)"should have a size of 10000", (int)this.store.getSize(), (int)10000);
        for (i = 0; i < 10000; ++i) {
            this.store.removeCaptcha(String.valueOf(i));
            CaptchaStoreTestAbstract.assertEquals((String)("Size should be : " + (10000 - i - 1)), (int)(10000 - i - 1), (int)this.store.getSize());
        }
    }

    public void testGetKeys() throws Exception {
        int i;
        for (int i2 = 0; i2 < 10000; ++i2) {
            this.store.storeCaptcha(String.valueOf(i2), this.captcha);
        }
        Collection keys = this.store.getKeys();
        for (i = 0; i < 10000; ++i) {
            CaptchaStoreTestAbstract.assertTrue((String)"store should have key ", (boolean)keys.contains(String.valueOf(i)));
        }
        for (i = 0; i < 10000; ++i) {
            this.store.removeCaptcha(String.valueOf(i));
        }
        CaptchaStoreTestAbstract.assertTrue((String)"keys should be empty", (this.store.getKeys().size() == 0 ? 1 : 0) != 0);
    }

    public void testGetCaptcha() throws Exception {
        int i;
        for (i = 0; i < 10000; ++i) {
            this.store.storeCaptcha(String.valueOf(i), this.captcha);
        }
        for (i = 0; i < 10000; ++i) {
            CaptchaStoreTestAbstract.assertEquals((String)"store should a captcha for this key ", (Object)this.captcha, (Object)this.store.getCaptcha(String.valueOf(i)));
        }
        CaptchaStoreTestAbstract.assertNull((Object)this.store.getCaptcha("unknown"));
    }

    public void testEmpty() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            this.store.storeCaptcha(String.valueOf(i), this.captcha);
        }
        this.store.empty();
        CaptchaStoreTestAbstract.assertEquals((String)"Size should be 0", (int)0, (int)this.store.getSize());
        CaptchaStoreTestAbstract.assertTrue((String)"keys should be empty", (this.store.getKeys().size() == 0 ? 1 : 0) != 0);
    }
}

