/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXAHeteroCloseCallback
implements OracleCloseCallback,
Monitor,
Diagnosable {
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    @Override
    public void beforeClose(OracleConnection conn, Object obj) {
        Monitor.CloseableLock lock = this.acquireCloseableLock();
        Throwable throwable = null;
        if (lock != null) {
            if (throwable != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                lock.close();
            }
        }
    }

    @Override
    public void afterClose(Object privData) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int rmid = ((OracleXAHeteroConnection)privData).getRmid();
            String xaCloseString = ((OracleXAHeteroConnection)privData).getXaCloseString();
            try {
                int status = this.t2cDoXaClose(xaCloseString, rmid, 0, 0);
                if (status != 0) {
                    throw (SQLException)DatabaseError.createSqlException(null, -1 * status).fillInStackTrace();
                }
            }
            catch (SQLException sqlexc) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAHeteroCloseCallback", "afterClose", "t2cDoXaClose hit SQLException: " + sqlexc.getMessage(), null, sqlexc);
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private native int t2cDoXaClose(String var1, int var2, int var3, int var4);

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

