/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CRLInvalidityDateExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_invalidityDate;
    private Date invalidityDate = null;

    public CRLInvalidityDateExtension() {
        super(TYPE);
    }

    public CRLInvalidityDateExtension(Date invalidityDate) {
        this(invalidityDate, false);
    }

    public CRLInvalidityDateExtension(Date invalidityDate, boolean critical) {
        super(TYPE, critical);
        this.invalidityDate = invalidityDate;
        this.setValue(this.toByteArray());
    }

    public CRLInvalidityDateExtension(InputStream is) throws IOException {
        super(is);
    }

    public Date getInvalidityDate() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.invalidityDate;
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Date(this.invalidityDate, true));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            this.invalidityDate = ASN1Date.inputValue((InputStream)new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "CRLInvalidityDateExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getInvalidityDate() + "}";
    }
}

