/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class IssuerAltNameExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_issuerAltName;
    private ArrayList<GeneralName> issuerAltName = new ArrayList();

    public IssuerAltNameExtension() {
        super(TYPE);
    }

    public IssuerAltNameExtension(GeneralName issuerAltName) {
        this(issuerAltName, false);
    }

    public IssuerAltNameExtension(GeneralName issuerAltName, boolean critical) {
        super(TYPE, critical);
        this.issuerAltName.add(issuerAltName);
        this.setValue(this.toByteArray());
    }

    public IssuerAltNameExtension(Vector<GeneralName> issuerAltName) {
        this((List<GeneralName>)issuerAltName);
    }

    public IssuerAltNameExtension(List<GeneralName> issuerAltName) {
        this(issuerAltName, false);
    }

    public IssuerAltNameExtension(Vector<GeneralName> issuerAltName, boolean critical) {
        this((List<GeneralName>)issuerAltName, critical);
    }

    public IssuerAltNameExtension(List<GeneralName> issuerAltName, boolean critical) {
        super(TYPE, critical);
        this.issuerAltName = issuerAltName == null ? null : (issuerAltName instanceof ArrayList ? (ArrayList<Object>)issuerAltName : new ArrayList<GeneralName>(issuerAltName));
        this.setValue(this.toByteArray());
    }

    public IssuerAltNameExtension(InputStream is) throws IOException {
        super(is);
    }

    public ArrayList<GeneralName> getIssuerAltName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuerAltName;
    }

    public Enumeration<GeneralName> issuerAltName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuerAltName == null ? null : new VectorOverArrayList(this.issuerAltName).elements();
    }

    public void addIssuerAltName(GeneralName name) {
        this.issuerAltName.add(name);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Sequence(this.issuerAltName));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            this.issuerAltName = new ArrayList();
            while (sis.hasMoreData()) {
                this.issuerAltName.add(new GeneralName((InputStream)sis));
            }
            sis.terminate();
            if (this.issuerAltName.size() == 0) {
                throw new ASN1FormatException("No GeneralName defined for extension");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("issuerAltNameExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.issuerAltName != null) {
            s.append("issuerAltNames = {");
            boolean mid = false;
            int size = this.issuerAltName.size();
            for (int i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(this.issuerAltName.get(i).toString());
                mid = true;
            }
            s.append("}");
        }
        s.append("]}");
        return s.toString();
    }
}

