/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

class ArrayLocatorResultSet
extends OracleResultSetImpl {
    static int COUNT_UNLIMITED = -1;
    Map map;
    long beginIndex;
    int count;
    long currentIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Nov_04_08:05:20_PDT_2011";
    public static final boolean TRACE = false;

    public ArrayLocatorResultSet(OracleConnection oracleConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, Map map) throws SQLException {
        this(oracleConnection, arrayDescriptor, byArray, 0L, COUNT_UNLIMITED, map);
    }

    public ArrayLocatorResultSet(OracleConnection oracleConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, long l2, int n2, Map map) throws SQLException {
        super((PhysicalConnection)oracleConnection, null);
        if (arrayDescriptor == null || oracleConnection == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.close_statement_on_close = true;
        this.count = n2;
        this.currentIndex = 0L;
        this.beginIndex = l2;
        this.map = map;
        OraclePreparedStatement oraclePreparedStatement = null;
        ARRAY aRRAY = new ARRAY(arrayDescriptor, oracleConnection, (Object)null);
        aRRAY.setLocator(byArray);
        oraclePreparedStatement = arrayDescriptor.getBaseType() == 2002 || arrayDescriptor.getBaseType() == 2008 ? (OraclePreparedStatement)((OraclePreparedStatementWrapper)oracleConnection.prepareStatement((String)new StringBuilder().append((String)"SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(:1 AS ").append((String)arrayDescriptor.getName()).append((String)") )").toString())).preparedStatement : (OraclePreparedStatement)((OraclePreparedStatementWrapper)oracleConnection.prepareStatement((String)new StringBuilder().append((String)"SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(:1 AS ").append((String)arrayDescriptor.getName()).append((String)") )").toString())).preparedStatement;
        oraclePreparedStatement.setArray(1, aRRAY);
        oraclePreparedStatement.executeQuery();
        this.statement = oraclePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.currentIndex < this.beginIndex) {
                while (this.currentIndex < this.beginIndex) {
                    ++this.currentIndex;
                    if (super.next()) continue;
                    return false;
                }
                return true;
            }
            if (this.count == COUNT_UNLIMITED) {
                return super.next();
            }
            if (this.currentIndex < this.beginIndex + (long)this.count - 1L) {
                ++this.currentIndex;
                return super.next();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getObject(n2, this.map);
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (string.equalsIgnoreCase("index")) {
                return 1;
            }
            if (string.equalsIgnoreCase("value")) {
                return 2;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }
}

