/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.Datum;

class OracleBlobInputStream
extends OracleBufferedStream {
    long lobOffset;
    Datum lob;
    long markedByte;
    boolean endOfStream = false;
    long maxPosition = Long.MAX_VALUE;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Nov_04_08:05:20_PDT_2011";
    public static final boolean TRACE = false;

    public OracleBlobInputStream(BLOB bLOB) throws SQLException {
        this(bLOB, ((PhysicalConnection)bLOB.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleBlobInputStream(BLOB bLOB, int n2) throws SQLException {
        this(bLOB, n2, 1L);
    }

    public OracleBlobInputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        super(n2);
        if (bLOB == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lob = bLOB;
        this.markedByte = -1L;
        this.lobOffset = l2;
    }

    public OracleBlobInputStream(BLOB bLOB, int n2, long l2, long l3) throws SQLException {
        this(bLOB, n2, l2);
        this.maxPosition = l2 + l3;
    }

    public OracleBlobInputStream(BFILE bFILE) throws SQLException {
        this(bFILE, ((PhysicalConnection)bFILE.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleBlobInputStream(BFILE bFILE, int n2) throws SQLException {
        this(bFILE, n2, 1L);
    }

    public OracleBlobInputStream(BFILE bFILE, int n2, long l2) throws SQLException {
        super(n2);
        if (bFILE == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lob = bFILE;
        this.markedByte = -1L;
        this.lobOffset = l2;
    }

    @Override
    public boolean needBytes(int n2) throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                if (n2 > this.currentBufferSize) {
                    this.currentBufferSize = Math.max(n2, this.initialBufferSize);
                    this.resizableBuffer = new byte[this.currentBufferSize];
                }
                try {
                    int n3 = (long)this.currentBufferSize < this.maxPosition - this.lobOffset ? this.currentBufferSize : (int)(this.maxPosition - this.lobOffset);
                    this.count = this.lob instanceof BLOB ? ((BLOB)this.lob).getBytes(this.lobOffset, n3, this.resizableBuffer) : ((BFILE)this.lob).getBytes(this.lobOffset, n3, this.resizableBuffer);
                    if (this.count < this.currentBufferSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lobOffset += (long)this.count;
                        if (this.lobOffset > this.maxPosition) {
                            this.endOfStream = true;
                        }
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    IOException iOException = DatabaseError.createIOException(sQLException);
                    iOException.fillInStackTrace();
                    throw iOException;
                }
            }
            return false;
        }
        return true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
    }

    public void markInternal(int n2) {
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedByte < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lobOffset = this.markedByte;
        this.pos = this.count;
        this.endOfStream = false;
    }

    @Override
    public long skip(long l2) throws IOException {
        this.ensureOpen();
        long l3 = 0L;
        if ((long)(this.count - this.pos) >= l2) {
            this.pos = (int)((long)this.pos + l2);
            l3 += l2;
        } else {
            l3 += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long l4 = 0L;
                l4 = this.lob instanceof BLOB ? ((BLOB)this.lob).length() - this.lobOffset + 1L : ((BFILE)this.lob).length() - this.lobOffset + 1L;
                if (l4 >= l2 - l3) {
                    this.lobOffset += l2 - l3;
                    l3 += l2 - l3;
                } else {
                    this.lobOffset += l4;
                    l3 += l4;
                }
            }
            catch (SQLException sQLException) {
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
        return l3;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection = null;
        if (this.lob != null) {
            try {
                oracleConnection = this.lob instanceof BLOB ? ((BLOB)this.lob).getInternalConnection() : ((BFILE)this.lob).getInternalConnection();
            }
            catch (Exception exception) {
                oracleConnection = null;
            }
        }
        return oracleConnection;
    }
}

