/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.driver.ClassRef;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDiagnosabilityMBean;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;

public class OracleDriver
implements Driver {
    public static final String oracle_string = "oracle";
    public static final String jdbc_string = "jdbc";
    public static final String protocol_string = "protocol";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    public static final String server_string = "server";
    public static final String access_string = "access";
    public static final String protocolFullName_string = "protocolFullName";
    public static final String logon_as_internal_str = "internal_logon";
    public static final String proxy_client_name = "oracle.jdbc.proxyClientName";
    public static final String prefetch_string = "prefetch";
    public static final String row_prefetch_string = "rowPrefetch";
    public static final String default_row_prefetch_string = "defaultRowPrefetch";
    public static final String batch_string = "batch";
    public static final String execute_batch_string = "executeBatch";
    public static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "V8Compatible";
    public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String StreamChunkSize_string = "oracle.jdbc.StreamChunkSize";
    public static final String prelim_auth_string = "prelim_auth";
    public static final String SetFloatAndDoubleUseBinary_string = "SetFloatAndDoubleUseBinary";
    public static final String xa_trans_loose = "oracle.jdbc.XATransLoose";
    public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
    public static final String read_timeout = "oracle.jdbc.ReadTimeout";
    public static final String defaultnchar_string = "oracle.jdbc.defaultNChar";
    public static final String defaultncharprop_string = "defaultNChar";
    public static final String useFetchSizeWithLongColumn_prop_string = "useFetchSizeWithLongColumn";
    public static final String useFetchSizeWithLongColumn_string = "oracle.jdbc.useFetchSizeWithLongColumn";
    public static final String remarks_string = "remarks";
    public static final String report_remarks_string = "remarksReporting";
    public static final String synonyms_string = "synonyms";
    public static final String include_synonyms_string = "includeSynonyms";
    public static final String restrict_getTables_string = "restrictGetTables";
    public static final String fixed_string_string = "fixedString";
    public static final String dll_string = "oracle.jdbc.ocinativelibrary";
    public static final String nls_lang_backdoor = "oracle.jdbc.ociNlsLangBackwardCompatible";
    public static final String disable_defineColumnType_string = "disableDefineColumnType";
    public static final String convert_nchar_literals_string = "oracle.jdbc.convertNcharLiterals";
    public static final String dataSizeUnitsPropertyName = "";
    public static final String dataSizeBytes = "";
    public static final String dataSizeChars = "";
    public static final String set_new_password_string = "OCINewPassword";
    public static final String retain_v9_bind_behavior_string = "oracle.jdbc.RetainV9LongBindBehavior";
    public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
    static final int EXTENSION_TYPE_ORACLE_ERROR = -3;
    static final int EXTENSION_TYPE_GEN_ERROR = -2;
    static final int EXTENSION_TYPE_TYPE4_CLIENT = 0;
    static final int EXTENSION_TYPE_TYPE4_SERVER = 1;
    static final int EXTENSION_TYPE_TYPE2_CLIENT = 2;
    static final int EXTENSION_TYPE_TYPE2_SERVER = 3;
    private static final int NUMBER_OF_EXTENSION_TYPES = 4;
    private OracleDriverExtension[] driverExtensions = new OracleDriverExtension[4];
    private static final String DRIVER_PACKAGE_STRING = "driver";
    private static final String[] driverExtensionClassNames;
    private static Properties driverAccess;
    protected static Connection defaultConn;
    private static OracleDriver defaultDriver;
    public static final Map<String, ClassRef> systemTypeMap;
    private static final String DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME = "/oracle/jdbc/defaultConnectionProperties.properties";
    protected static final Properties DEFAULT_CONNECTION_PROPERTIES;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Fri_Nov_04_08:05:20_PDT_2011";
    public static final boolean TRACE = false;

    public static void registerMBeans() {
        block13: {
            try {
                Object object;
                Object object2;
                Object object3;
                MBeanServer mBeanServer = null;
                try {
                    object3 = ClassRef.newInstance("oracle.as.jmx.framework.PortableMBeanFactory");
                    object2 = ((ClassRef)object3).get().getConstructor(new Class[0]);
                    Object t = ((Constructor)object2).newInstance(new Object[0]);
                    object = ((ClassRef)object3).get().getMethod("getMBeanServer", new Class[0]);
                    mBeanServer = (MBeanServer)((Method)object).invoke(t, new Object[0]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but not the getMBeanServer method.", noSuchMethodException);
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not create an instance.", instantiationException);
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not access the getMBeanServer method.", illegalAccessException);
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but the getMBeanServer method threw an exception.", invocationTargetException);
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                if (mBeanServer != null) {
                    object3 = OracleDriver.class.getClassLoader();
                    object2 = object3 == null ? "nullLoader" : object3.getClass().getName();
                    int n2 = 0;
                    while (true) {
                        object = (String)object2 + "@" + Integer.toHexString((object3 == null ? 0 : object3.hashCode()) + n2++);
                        ObjectName objectName = new ObjectName("com.oracle.jdbc:type=diagnosability,name=" + (String)object);
                        try {
                            mBeanServer.registerMBean(new OracleDiagnosabilityMBean(), objectName);
                            break block13;
                        }
                        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                            continue;
                        }
                        break;
                    }
                }
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Unable to find an MBeanServer so no MBears are registered.");
            }
            catch (JMException jMException) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", jMException);
            }
            catch (Throwable throwable) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        Object object;
        Object object2;
        int n2;
        if (string.regionMatches(0, "jdbc:default:connection", 0, 23)) {
            String string2 = "jdbc:oracle:kprb";
            int n3 = string.length();
            string = n3 > 23 ? string2.concat(string.substring(23, string.length())) : string2.concat(":");
            string2 = null;
        }
        if ((n2 = OracleDriver.oracleDriverExtensionTypeFromURL(string)) == -2) {
            return null;
        }
        if (n2 == -3) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        OracleDriverExtension oracleDriverExtension = null;
        oracleDriverExtension = this.driverExtensions[n2];
        if (oracleDriverExtension == null) {
            try {
                object2 = this;
                synchronized (object2) {
                    if (oracleDriverExtension == null) {
                        this.driverExtensions[n2] = oracleDriverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassNames[n2]).newInstance();
                    } else {
                        oracleDriverExtension = this.driverExtensions[n2];
                    }
                }
            }
            catch (Exception exception) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exception);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (properties == null) {
            properties = new Properties();
        }
        object2 = DriverManager.getDrivers();
        while (object2.hasMoreElements() && !((object = (Driver)object2.nextElement()) instanceof OracleDriver)) {
        }
        while (object2.hasMoreElements()) {
            object = (Driver)object2.nextElement();
            if (!(object instanceof OracleDriver)) continue;
            DriverManager.deregisterDriver((Driver)object);
        }
        object = (PhysicalConnection)oracleDriverExtension.getConnection(string, properties);
        ((PhysicalConnection)object).protocolId = n2;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection defaultConnection() throws SQLException {
        if (defaultConn != null && !defaultConn.isClosed()) return defaultConn;
        Class<OracleDriver> clazz = OracleDriver.class;
        synchronized (OracleDriver.class) {
            if (defaultConn != null && !defaultConn.isClosed()) return defaultConn;
            defaultConn = this.connect("jdbc:oracle:kprb:", new Properties());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultConn;
        }
    }

    static final int oracleDriverExtensionTypeFromURL(String string) {
        int n2;
        int n3 = string.indexOf(58);
        if (n3 == -1) {
            return -2;
        }
        if (!string.regionMatches(true, 0, jdbc_string, 0, n3)) {
            return -2;
        }
        if ((n2 = string.indexOf(58, ++n3)) == -1) {
            return -2;
        }
        if (!string.regionMatches(true, n3, oracle_string, 0, n2 - n3)) {
            return -2;
        }
        int n4 = string.indexOf(58, ++n2);
        String string2 = null;
        if (n4 == -1) {
            return -3;
        }
        string2 = string.substring(n2, n4);
        if (string2.equals("thin")) {
            return 0;
        }
        if (string2.equals("oci8") || string2.equals("oci")) {
            return 2;
        }
        return -3;
    }

    @Override
    public boolean acceptsURL(String string) {
        if (string.startsWith("jdbc:oracle:")) {
            return OracleDriver.oracleDriverExtensionTypeFromURL(string) > -2;
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        Class clazz = null;
        try {
            clazz = ClassRef.newInstance("oracle.jdbc.OracleConnection").get();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        int n2 = 0;
        String[] stringArray = new String[150];
        String[] stringArray2 = new String[150];
        Field[] fieldArray = clazz.getFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            if (!fieldArray[i2].getName().startsWith("CONNECTION_PROPERTY_") || fieldArray[i2].getName().endsWith("_DEFAULT") || fieldArray[i2].getName().endsWith("_ACCESSMODE")) continue;
            try {
                String string2 = (String)fieldArray[i2].get(null);
                Field field = clazz.getField(fieldArray[i2].getName() + "_DEFAULT");
                String string3 = (String)field.get(null);
                if (n2 == stringArray.length) {
                    String[] stringArray3 = new String[stringArray.length * 2];
                    String[] stringArray4 = new String[stringArray.length * 2];
                    System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                    System.arraycopy(stringArray2, 0, stringArray4, 0, stringArray.length);
                    stringArray = stringArray3;
                    stringArray2 = stringArray4;
                }
                stringArray[n2] = string2;
                stringArray2[n2] = string3;
                ++n2;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            driverPropertyInfoArray[i3] = new DriverPropertyInfo(stringArray[i3], stringArray2[i3]);
        }
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return OracleDatabaseMetaData.getDriverMajorVersionInfo();
    }

    @Override
    public int getMinorVersion() {
        return OracleDatabaseMetaData.getDriverMinorVersionInfo();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public String processSqlEscapes(String string) throws SQLException {
        OracleSql oracleSql = new OracleSql(null);
        oracleSql.initialize(string);
        return oracleSql.parse(string);
    }

    public static String getCompileTime() {
        return BUILD_DATE;
    }

    public static String getSystemPropertyFastConnectionFailover(String string) {
        return PhysicalConnection.getSystemPropertyFastConnectionFailover(string);
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        Object object;
        driverExtensionClassNames = new String[]{"oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T2CDriverExtension", "oracle.jdbc.driver.T2SDriverExtension"};
        defaultConn = null;
        defaultDriver = null;
        try {
            if (defaultDriver == null) {
                defaultDriver = new oracle.jdbc.OracleDriver();
                DriverManager.registerDriver(defaultDriver);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    OracleDriver.registerMBeans();
                    return null;
                }
            });
            object = Timestamp.valueOf("2000-01-01 00:00:00.0");
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "SQLException in static block.", sQLException);
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "RuntimeException in static block.", runtimeException);
        }
        try {
            object = ClassRef.newInstance("oracle.security.pki.OraclePKIProvider");
            Object t = ((ClassRef)object).get().newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        systemTypeMap = new Hashtable<String, ClassRef>(3);
        try {
            systemTypeMap.put("SYS.XMLTYPE", ClassRef.newInstance("oracle.xdb.XMLTypeFactory"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            systemTypeMap.put("SYS.ANYDATA", ClassRef.newInstance("oracle.sql.AnyDataFactory"));
            systemTypeMap.put("SYS.ANYTYPE", ClassRef.newInstance("oracle.sql.TypeDescriptorFactory"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DEFAULT_CONNECTION_PROPERTIES = new Properties();
        try {
            object = PhysicalConnection.class.getResourceAsStream(DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME);
            if (object != null) {
                DEFAULT_CONNECTION_PROPERTIES.load((InputStream)object);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

