/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import oracle.sql.OPAQUE;

class ClassRef {
    static final XMLTypeClassRef XMLTYPE = XMLTypeClassRef.newInstance();
    private final ThreadLocal<Class> ref = new ThreadLocal();
    private final String className;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Aug_26_08:19:15_PDT_2011";
    public static final boolean TRACE = false;

    static final ClassRef newInstance(String string) throws ClassNotFoundException {
        return new ClassRef(string);
    }

    private ClassRef(String string) throws ClassNotFoundException {
        this.className = string;
        this.ref.set(Class.forName(this.className, true, Thread.currentThread().getContextClassLoader()));
    }

    Class get() {
        Class<?> clazz = this.ref.get();
        if (clazz == null) {
            try {
                clazz = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                noClassDefFoundError.initCause(classNotFoundException);
                throw noClassDefFoundError;
            }
            this.ref.set(clazz);
        }
        return clazz;
    }

    static class XMLTypeClassRef
    extends ClassRef {
        protected final Method CREATEXML;

        static final XMLTypeClassRef newInstance() {
            try {
                return new XMLTypeClassRef();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return null;
        }

        private XMLTypeClassRef() throws ClassNotFoundException {
            super("oracle.xdb.XMLType");
            Method method = null;
            try {
                method = this.get().getDeclaredMethod("createXML", OPAQUE.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.CREATEXML = method;
        }

        OPAQUE createXML(OPAQUE oPAQUE) throws SQLException {
            this.get();
            try {
                return (OPAQUE)this.CREATEXML.invoke(null, oPAQUE);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
    }
}

