/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.model.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.Column;
import javax.persistence.Table;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.code.Style;

public class MybatisSqlUtil {
    private static final String SQLKEYWORD_AS = "AS";
    private static List<String> excludeProps = new ArrayList<String>();

    public static String allColumnSelect(Class<?> entityClass) {
        return MybatisSqlUtil.allColumnSelect(entityClass, null);
    }

    public static String allColumnSelect(Class<?> entityClass, String tableAlias) {
        return MybatisSqlUtil.columnSelect(entityClass, null, tableAlias);
    }

    public static String columnSelect(Class<?> entityClass, String[] colNames) {
        return MybatisSqlUtil.columnSelect(entityClass, colNames, null);
    }

    public static String columnSelect(Class<?> entityClass, String[] colNames, String tableAlias) {
        List<String> colNameList = colNames == null ? null : Arrays.asList(colNames);
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(entityClass);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Faild on getBeanInfo", e);
        }
        if (beanInfo != null) {
            Style nameStyle = Style.normal;
            if (entityClass.isAnnotationPresent(NameStyle.class)) {
                NameStyle nameStyleAnno = entityClass.getDeclaredAnnotation(NameStyle.class);
                nameStyle = nameStyleAnno.value();
            }
            StringBuilder cols = new StringBuilder();
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            Column colAnnotation = null;
            for (PropertyDescriptor pd : propertyDescriptors) {
                if (excludeProps.contains(pd.getName()) || colNameList != null && colNameList.size() > 0 && !colNameList.contains(pd.getName())) continue;
                String colName = null;
                Class<?> propClass = pd.getClass();
                if (propClass.isAnnotationPresent(Column.class) && (colAnnotation = propClass.getDeclaredAnnotation(Column.class)) != null) {
                    colName = colAnnotation.name();
                }
                cols.append(", ");
                if (colName == null || colName.trim().length() <= 0) {
                    colName = MybatisSqlUtil.nameStyleFormat(pd.getName(), nameStyle);
                }
                if (tableAlias != null && tableAlias.trim().length() > 0) {
                    cols.append(tableAlias).append(".");
                }
                cols.append(colName).append(" ").append(SQLKEYWORD_AS).append(" ").append(pd.getName());
            }
            beanInfo.getPropertyDescriptors();
            return cols.substring(1);
        }
        return null;
    }

    public static String getTableName(Class<?> entityClass, String alias) {
        String tableName = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(entityClass);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Faild on getBeanInfo", e);
        }
        if (beanInfo != null) {
            if (entityClass.isAnnotationPresent(Table.class)) {
                Table tableAnno = entityClass.getDeclaredAnnotation(Table.class);
                tableName = tableAnno.name();
            }
            if (tableName == null || tableName.trim().length() <= 0) {
                NameStyle nameStyleAnno;
                Style nameStyle = Style.normal;
                if (entityClass.isAnnotationPresent(NameStyle.class) && (nameStyleAnno = entityClass.getDeclaredAnnotation(NameStyle.class)) != null && nameStyleAnno.value() != null) {
                    nameStyle = nameStyleAnno.value();
                }
                tableName = MybatisSqlUtil.nameStyleFormat(entityClass.getName(), nameStyle);
            }
        }
        return alias == null || alias.trim().length() <= 0 ? String.format(" %s ", tableName) : String.format(" %s %s %s ", tableName, SQLKEYWORD_AS, alias);
    }

    public static String getColumnName(Class<?> entityClass, String col, String tableAlias) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(entityClass);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Faild on getBeanInfo", e);
        }
        if (beanInfo != null) {
            Style nameStyle = Style.normal;
            if (entityClass.isAnnotationPresent(NameStyle.class)) {
                NameStyle nameStyleAnno = entityClass.getDeclaredAnnotation(NameStyle.class);
                nameStyle = nameStyleAnno.value();
            }
            StringBuilder cols = new StringBuilder();
            cols.append(" ");
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            Column colAnnotation = null;
            for (PropertyDescriptor pd : propertyDescriptors) {
                if (!pd.getName().equals(col)) continue;
                String colName = null;
                Class<?> propClass = pd.getClass();
                if (propClass.isAnnotationPresent(Column.class) && (colAnnotation = propClass.getDeclaredAnnotation(Column.class)) != null) {
                    colName = colAnnotation.name();
                }
                if (colName == null || colName.trim().length() <= 0) {
                    colName = MybatisSqlUtil.nameStyleFormat(pd.getName(), nameStyle);
                }
                if (tableAlias != null && tableAlias.trim().length() > 0) {
                    cols.append(tableAlias).append(".");
                }
                cols.append(colName).append(" ");
                break;
            }
            beanInfo.getPropertyDescriptors();
            return cols.toString();
        }
        return null;
    }

    public static String nameStyleFormat(String name, Style nameStyle) {
        String formatedName = "";
        switch (nameStyle) {
            case camelhump: {
                formatedName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
                Iterable splited = Splitter.on((String)"_").split((CharSequence)name);
                StringBuilder sb = new StringBuilder();
                AtomicInteger i = new AtomicInteger(0);
                Iterator iterator = splited.iterator();
                if (iterator.hasNext()) {
                    String s = (String)iterator.next();
                    sb.append("_");
                    if (i.getAndAdd(1) > 0) {
                        sb.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1));
                    } else {
                        sb.append(s);
                    }
                }
                formatedName = sb.substring(1);
                break;
            }
            case lowercase: {
                formatedName = name.toLowerCase();
                break;
            }
            case uppercase: {
                formatedName = name.toUpperCase();
                break;
            }
            case camelhumpAndLowercase: {
                formatedName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
                break;
            }
            case camelhumpAndUppercase: {
                formatedName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
                break;
            }
            default: {
                formatedName = name;
            }
        }
        return formatedName;
    }

    static {
        excludeProps.add("class");
        excludeProps.add("CLASS");
    }
}

