/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.model.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class Utils {
    public static boolean isBaseType(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (Date.class.isAssignableFrom(type)) {
            return true;
        }
        if (Boolean.class.equals(type)) {
            return true;
        }
        if (Character.class.equals(type)) {
            return true;
        }
        if (Class.class.equals(type)) {
            return true;
        }
        if (StringBuilder.class.equals(type)) {
            return true;
        }
        if (StringBuffer.class.equals(type)) {
            return true;
        }
        if (Object.class.equals(type)) {
            return true;
        }
        return Void.class.equals(type);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return obj.toString().trim().length() == 0;
        }
        if (obj.getClass().equals(Object.class)) {
            return true;
        }
        if (Utils.isBaseType(obj.getClass())) {
            return false;
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return Object.class.equals(obj.getClass());
    }

    public static boolean isStringEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }
}

