/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.model.util.antifraudUtil;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

class BspAPI {
    private static final String URL = "csec.api.qcloud.com/v2/index.php";

    BspAPI() {
    }

    private static String encode(byte[] bstr) {
        String sp = System.getProperty("line.separator");
        return new BASE64Encoder().encode(bstr).replaceAll(sp, "");
    }

    public static String hmacSHA1(String key, String text, String charset) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(new SecretKeySpec(key.getBytes(charset), "HmacSHA1"));
        return BspAPI.encode(mac.doFinal(text.getBytes(charset)));
    }

    private static String makeQueryString(SortedMap args, String charset) throws UnsupportedEncodingException {
        String url = "";
        Object[] keys = args.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String entry = (String)args.get((String)keys[i]);
            url = url + (String)keys[i] + "=" + (charset == null ? entry : URLEncoder.encode(entry, charset)) + "&";
        }
        return url.substring(0, url.length() - 1);
    }

    public static String makeURL(String method, String action, String region, String secretId, String secretKey, Map args, String charset) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        TreeMap<String, String> arguments = new TreeMap<String, String>();
        arguments.putAll(args);
        arguments.put("Nonce", String.valueOf((int)(Math.random() * 2.147483647E9)));
        arguments.put("Action", action);
        arguments.put("Region", region);
        arguments.put("SecretId", secretId);
        arguments.put("Timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        Object[] arrs = new String[]{method, URL, BspAPI.makeQueryString(arguments, null)};
        arguments.put("Signature", BspAPI.hmacSHA1(secretKey, String.format("%s%s?%s", arrs), charset));
        Object[] arrays = new String[]{URL, BspAPI.makeQueryString(arguments, charset)};
        String url = String.format("https://%s?%s", arrays);
        System.out.println("BspAPI\u751f\u6210\u7684\u5730\u5740\uff1a" + url);
        return url;
    }
}

