/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5 {
    private static final Logger logger = LoggerFactory.getLogger(MD5.class);
    private static final String[] strDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private String byteToArrayString(byte bByte) {
        int iRet = bByte;
        if (iRet < 0) {
            iRet += 256;
        }
        int iD1 = iRet / 16;
        int iD2 = iRet % 16;
        return strDigits[iD1] + strDigits[iD2];
    }

    private String byteToString(byte[] bByte) {
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 0; i < bByte.length; ++i) {
            sBuffer.append(this.byteToArrayString(bByte[i]));
        }
        return sBuffer.toString();
    }

    public String getMD5Code(String strObj) {
        String resultString = strObj;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            resultString = this.byteToString(md.digest(strObj.getBytes()));
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("MD5 NoSuchAlgorithmException", (Throwable)ex);
        }
        return resultString;
    }

    public String getMD5Str(String str) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("NoSuchAlgorithmException caught!", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException caught!", (Throwable)e);
        }
        byte[] byteArray = null;
        if (messageDigest != null) {
            byteArray = messageDigest.digest();
        }
        StringBuffer md5StrBuff = new StringBuffer();
        if (byteArray != null) {
            for (int i = 0; i < byteArray.length; ++i) {
                if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                    md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                    continue;
                }
                md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
            }
        }
        return md5StrBuff.toString();
    }

    public static String encode(String password) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        char[] charArray = password.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            byteArray[i] = (byte)charArray[i];
        }
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }
}

