/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.utils.jdbc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIdWorker {
    protected static final Logger logger = LoggerFactory.getLogger(SnowflakeIdWorker.class);
    protected final long twepoch = 1288834974657L;
    private final long workerIdBits = 10L;
    private final long maxWorkerId = 1023L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    protected long workerId = 0L;
    protected long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowflakeIdWorker() {
        byte[] address;
        try {
            address = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            address = null;
        }
        if (address != null) {
            for (byte x : address) {
                this.workerId = (this.workerId << 8) - -128L + (long)x & 0x3FFL;
            }
        } else {
            logger.warn("Cannot get ip address for generating server id, use random address instead.");
            this.workerId = new SecureRandom().nextLong() & 0x3FFL;
        }
        logger.info("Worker starting. Timestamp left shift {}, worker id bits {}, sequence bits {}, worker id {}.", new Object[]{22L, 10L, 12L, this.workerId});
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            logger.error("Clock is moving backwards. Rejecting requests until {}.", (Object)this.lastTimestamp);
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1288834974657L << 22 | this.workerId << 12 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }
}

