/*
 * Decompiled with CFR 0.152.
 */
package com.chrhc.mybatis.autodate.interceptor;

import com.chrhc.mybatis.autodate.util.PluginUtil;
import com.chrhc.mybatis.autodate.util.StringUtil;
import com.chrhc.mybatis.autodate.util.TypeUtil;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.defaults.DefaultSqlSession;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class CommonDataInterceptor
implements Interceptor {
    private static final Log logger = LogFactory.getLog(CommonDataInterceptor.class);
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("-yyyy-MM-dd HH:mm:ss.SSS-");
    private Properties props = null;

    public Object intercept(Invocation invocation) throws Throwable {
        String interceptMethod = invocation.getMethod().getName();
        if (!"prepare".equals(interceptMethod)) {
            return invocation.proceed();
        }
        StatementHandler handler = (StatementHandler)PluginUtil.processTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)handler);
        MappedStatement ms = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        SqlCommandType sqlCmdType = ms.getSqlCommandType();
        if (sqlCmdType != SqlCommandType.UPDATE && sqlCmdType != SqlCommandType.INSERT) {
            return invocation.proceed();
        }
        if (null == this.props || this.props.isEmpty()) {
            return invocation.proceed();
        }
        String createDateColumn = this.props.getProperty("createDateColumn", "create_date");
        String updateDateColumn = this.props.getProperty("updateDateColumn", "update_date");
        String versionColumn = this.props.getProperty("versionColumn", "version");
        String createUserColumn = this.props.getProperty("createUserIdColumn", "create_user_id");
        String updateUserColumn = this.props.getProperty("updateUserIdColumn", "update_user_id");
        String createByColumn = this.props.getProperty("createByColumn", "create_by");
        String updateByColumn = this.props.getProperty("updateByColumn", "update_by");
        String createUserField = this.props.getProperty("createUserField", "");
        String updateUserField = this.props.getProperty("updateUserField", "");
        String createByField = this.props.getProperty("createByField", "");
        String updateByField = this.props.getProperty("updateByField", "");
        if (createUserField == null || createUserField.length() <= 0) {
            createUserField = StringUtil.underlineToCamel((String)createUserColumn);
        }
        if (updateUserField == null || updateUserField.length() <= 0) {
            updateUserField = StringUtil.underlineToCamel((String)updateUserColumn);
        }
        if (createByField == null || createByField.length() <= 0) {
            createByField = StringUtil.underlineToCamel((String)createByColumn);
        }
        if (updateByField == null || updateByField.length() <= 0) {
            updateByField = StringUtil.underlineToCamel((String)updateByColumn);
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        Object parameterObject = boundSql.getParameterObject();
        String originalSql = (String)metaObject.getValue("delegate.boundSql.sql");
        logger.debug("==> originalSql: " + originalSql);
        String newSql = "";
        if (sqlCmdType == SqlCommandType.UPDATE && updateDateColumn.length() > 0) {
            newSql = this.addUpdateData(parameterObject, originalSql, updateDateColumn, updateUserField, updateUserColumn, updateByField, updateByColumn);
        } else if (sqlCmdType == SqlCommandType.INSERT && createDateColumn.length() > 0) {
            newSql = this.addInsertData(parameterObject, originalSql, createDateColumn, versionColumn, createUserField, createUserColumn, createByField, createByColumn);
        }
        if (newSql.length() > 0) {
            logger.debug("==> newSql: " + newSql);
            metaObject.setValue("delegate.boundSql.sql", (Object)newSql);
        }
        return invocation.proceed();
    }

    private String addInsertData(Object parameterObject, String originalSql, String createDateColumn, String versionColumn, String createUserField, String createUserColumn, String createByField, String createByColumn) {
        String sql = originalSql;
        sql = this.addInsertData(parameterObject, sql, createDateColumn, null, (Expression)new TimestampValue(TIMESTAMP_FORMAT.format(new Date())));
        sql = this.addInsertData(parameterObject, sql, versionColumn, null, (Expression)new LongValue(1L));
        sql = this.addInsertData(parameterObject, sql, createUserColumn, createUserField, null);
        sql = this.addInsertData(parameterObject, sql, createByColumn, createByField, null);
        return sql;
    }

    private String addInsertData(Object parameterObject, String originalSql, String columnName, String fieldName, Expression expression) {
        try {
            Statement stmt = CCJSqlParserUtil.parse((String)originalSql);
            if (!(stmt instanceof Insert)) {
                return originalSql;
            }
            Insert update = (Insert)stmt;
            List columns = update.getColumns();
            if (!this.contains(columns, columnName)) {
                Column versionColumn = new Column();
                versionColumn.setColumnName(columnName);
                columns.add(versionColumn);
                ItemsList itemList = update.getItemsList();
                if (itemList instanceof ExpressionList) {
                    ExpressionList expressionList = (ExpressionList)itemList;
                    List expressions = expressionList.getExpressions();
                    if (expression != null) {
                        expressions.add(expression);
                    } else {
                        Object value = this.getFieldValue(parameterObject, 0, fieldName);
                        expressions.add(new StringValue("-" + value.toString() + "-"));
                    }
                } else if (itemList instanceof MultiExpressionList) {
                    MultiExpressionList multiExpressionList = (MultiExpressionList)itemList;
                    List expressionLists = multiExpressionList.getExprList();
                    for (int i = 0; i < expressionLists.size(); ++i) {
                        ExpressionList expressionList = (ExpressionList)expressionLists.get(i);
                        List expressions = expressionList.getExpressions();
                        if (expression != null) {
                            expressions.add(expression);
                            continue;
                        }
                        Object value = this.getFieldValue(parameterObject, i, fieldName);
                        expressions.add(new StringValue("-" + value.toString() + "-"));
                    }
                } else {
                    columns.remove(columns.size() - 1);
                }
            }
            return stmt.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return originalSql;
        }
    }

    private String addUpdateData(Object parameterObject, String originalSql, String updateDateColumn, String updateUserField, String updateUserColumn, String updateByField, String updateByColumn) {
        String sql = originalSql;
        sql = this.addUpdateData(parameterObject, sql, updateDateColumn, null, (Expression)new TimestampValue(TIMESTAMP_FORMAT.format(new Date())));
        sql = this.addUpdateData(parameterObject, sql, updateUserColumn, updateUserField, null);
        sql = this.addUpdateData(parameterObject, sql, updateByColumn, updateByField, null);
        return sql;
    }

    private String addUpdateData(Object parameterObject, String originalSql, String columnName, String fieldName, Expression expression) {
        StringBuilder sb = new StringBuilder();
        String[] sqlList = originalSql.split(";");
        for (int i = 0; i < sqlList.length; ++i) {
            block7: {
                if (i > 0) {
                    sb.append(";");
                }
                try {
                    Statement stmt = CCJSqlParserUtil.parse((String)sqlList[i]);
                    if (!(stmt instanceof Update)) {
                        return originalSql;
                    }
                    Update update = (Update)stmt;
                    List columns = update.getColumns();
                    if (this.contains(columns, columnName)) {
                        sb.append(sqlList[i]);
                    }
                    break block7;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    sb.append(sqlList[i]);
                }
                continue;
            }
            if (expression == null) {
                Object value = this.getFieldValue(parameterObject, i, fieldName);
                String sql = this.addUpdateDateToSql(sqlList[i], columnName, (Expression)new StringValue("-" + value.toString() + "-"));
                sb.append(sql);
                continue;
            }
            String sql = this.addUpdateDateToSql(sqlList[i], columnName, expression);
            sb.append(sql);
        }
        return sb.toString();
    }

    private String addUpdateDateToSql(String originalSql, String columnName, Expression expression) {
        try {
            Statement stmt = CCJSqlParserUtil.parse((String)originalSql);
            if (!(stmt instanceof Update)) {
                return originalSql;
            }
            Update update = (Update)stmt;
            List columns = update.getColumns();
            if (!this.contains(columns, columnName)) {
                Column versionColumn = new Column();
                versionColumn.setColumnName(columnName);
                columns.add(versionColumn);
                List expressions = update.getExpressions();
                expressions.add(expression);
            }
            return stmt.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return originalSql;
        }
    }

    private Object getFieldValue(Object parameterObject, int index, String fieldName) {
        Object value = null;
        if (parameterObject instanceof DefaultSqlSession.StrictMap) {
            DefaultSqlSession.StrictMap map = (DefaultSqlSession.StrictMap)parameterObject;
            Object object = map.get((Object)"list");
            if (object == null) {
                object = map.get((Object)"array");
            }
            if (object != null) {
                value = this.getValueFromListOrArray(object, index, fieldName);
            }
        } else if (parameterObject instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap map = (MapperMethod.ParamMap)parameterObject;
            Object param1 = map.get((Object)"param1");
            if (param1.getClass().isArray() || List.class.isAssignableFrom(param1.getClass())) {
                value = this.getValueFromListOrArray(param1, index, fieldName);
            }
            if (value == null) {
                if (TypeUtil.isSimpleType(param1 == null ? null : param1.getClass())) {
                    Set keys = map.keySet();
                    for (Object key : keys) {
                        if (!fieldName.equals(key)) continue;
                        value = map.get(key);
                        break;
                    }
                } else {
                    MetaObject metaObject = SystemMetaObject.forObject((Object)param1);
                    value = metaObject.getValue(fieldName);
                }
            }
        } else if (parameterObject instanceof Map) {
            Map map = (Map)parameterObject;
            value = map.get(fieldName);
        } else {
            MetaObject metaObject = SystemMetaObject.forObject((Object)parameterObject);
            value = metaObject.getValue(fieldName);
        }
        if (value == null) {
            throw new IllegalArgumentException("value of[" + fieldName + "]can not be empty");
        }
        return value;
    }

    private Object getValueFromListOrArray(Object parameterObject, int index, String fieldName) {
        Object entity = null;
        if (parameterObject instanceof List) {
            entity = ((List)parameterObject).get(index);
        } else if (parameterObject != null && parameterObject.getClass().isArray()) {
            entity = ((Object[])parameterObject)[index];
        }
        if (entity != null) {
            MetaObject metaObject = SystemMetaObject.forObject(entity);
            return metaObject.getValue(fieldName);
        }
        return null;
    }

    private boolean contains(List<Column> columns, String columnName) {
        if (columns == null || columns.size() <= 0) {
            return false;
        }
        if (columnName == null || columnName.length() <= 0) {
            return false;
        }
        for (Column column : columns) {
            if (!column.getColumnName().equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        if (null != properties && !properties.isEmpty()) {
            this.props = properties;
        }
    }
}

