/*
 * Decompiled with CFR 0.152.
 */
package com.chrhc.mybatis.autodate.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;

public class TemplateUtils {
    public static String parseText(String path, Map<String, Object> data) throws IOException, TemplateException {
        Properties settings = new Properties();
        settings.setProperty("template_update_delay", "120");
        settings.setProperty("locale", "zh_CN");
        settings.setProperty("datetime_format", "yyyy-MM-dd'T'HH:mm");
        settings.setProperty("date_format", "yyyy-MM-dd");
        settings.setProperty("number_format", "#.##");
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_25);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setSettings(settings);
        cfg.setClassForTemplateLoading(TemplateUtils.class, "/");
        Template temp = cfg.getTemplate(path, "utf-8");
        StringWriter out = new StringWriter();
        temp.process(data, (Writer)out);
        return ((Object)out).toString().replaceAll("\r", "").replaceAll("\n", "").replaceAll("\t", "").replaceAll("  ", "");
    }

    public static String renderString(String templateString, Map<String, Object> data) throws IOException, TemplateException {
        Properties settings = new Properties();
        settings.setProperty("template_update_delay", "120");
        settings.setProperty("locale", "zh_CN");
        settings.setProperty("datetime_format", "yyyy-MM-dd'T'HH:mm");
        settings.setProperty("date_format", "yyyy-MM-dd");
        settings.setProperty("number_format", "#.##");
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_25);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setSettings(settings);
        cfg.setClassForTemplateLoading(TemplateUtils.class, "/");
        Template temp = new Template("default", (Reader)new StringReader(templateString), cfg);
        StringWriter out = new StringWriter();
        temp.process(data, (Writer)out);
        return ((Object)out).toString().replaceAll("\r", "").replaceAll("\n", "").replaceAll("\t", "").replaceAll("  ", "");
    }
}

