/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.aspect;

import com.alibaba.fastjson.JSON;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=-1)
@Aspect
@Component
public class ApiServiceLogAspect {
    private static final Logger log = LoggerFactory.getLogger(ApiServiceLogAspect.class);
    @Value(value="${stubs.logs.spanTimes:true}")
    private Boolean logSpanTimes;
    @Value(value="${stubs.logs.params:false}")
    private Boolean logParams;

    @Pointcut(value="@annotation(com.picc.gz.admin.aspect.annocation.ApiService)")
    private void apiCallPointCut() {
    }

    @Around(value="apiCallPointCut()")
    public Object recordRunTime(ProceedingJoinPoint pjp) throws Throwable {
        Class<?> targetClass = pjp.getTarget().getClass();
        Signature signature = pjp.getSignature();
        if (this.logSpanTimes.booleanValue() || this.logParams.booleanValue()) {
            log.info("{}.{}\u65b9\u6cd5\u5f00\u59cb\u6267\u884c", (Object)targetClass.getName(), (Object)signature.getName());
        }
        if (this.logParams.booleanValue()) {
            for (int i = 0; i < pjp.getArgs().length; ++i) {
                log.info("{}.{}\u65b9\u6cd5\u8bf7\u6c42\u53c2\u6570{} -> {}", new Object[]{targetClass.getName(), signature.getName(), i, JSON.toJSON((Object)pjp.getArgs()[i])});
            }
        }
        long start = System.currentTimeMillis();
        Object retVal = pjp.proceed();
        long duration = System.currentTimeMillis() - start;
        if (this.logSpanTimes.booleanValue()) {
            log.info("{}.{}\u6267\u884c\u5b8c\u6210\uff0c\u6d88\u8017\u65f6\u95f4{}ms", new Object[]{targetClass.getName(), signature.getName(), duration});
        }
        if (this.logParams.booleanValue()) {
            log.info("{}.{}\u65b9\u6cd5\u8fd4\u56de\u53c2\u6570{}", new Object[]{targetClass.getName(), signature.getName(), JSON.toJSON((Object)retVal)});
        }
        return retVal;
    }
}

