/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.aspect;

import com.picc.gz.admin.service.intf.InterfacePermissionService;
import com.picc.gz.model.model.InterfaceUser;
import com.picc.gz.sfzn.api.security.SignUtil;
import com.picc.gz.sfzn.api.vo.basic.BaseRequest;
import com.picc.gz.sfzn.api.vo.basic.BaseResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Aspect
@Component
public class ApiServiceSignAspect {
    private static final Logger log = LoggerFactory.getLogger(ApiServiceSignAspect.class);
    @Autowired
    InterfacePermissionService interfacePermissionService;

    @Pointcut(value="@annotation(com.picc.gz.admin.aspect.annocation.ApiService)")
    private void apiCallPointCut() {
    }

    @Around(value="apiCallPointCut()")
    public Object verifySign(ProceedingJoinPoint pjp) throws Throwable {
        Class<?> targetClass = pjp.getTarget().getClass();
        Signature signature = pjp.getSignature();
        Object retVal = null;
        BaseRequest baseRequest = null;
        for (Object o : pjp.getArgs()) {
            if (!(o instanceof BaseRequest)) continue;
            baseRequest = (BaseRequest)o;
        }
        if (baseRequest != null) {
            if (baseRequest.getHeader() != null) {
                InterfaceUser interfaceUser = this.interfacePermissionService.findByAppKey(baseRequest.getHeader().getAppKey());
                if (interfaceUser != null && !interfaceUser.getIsDelete().equals(1) && interfaceUser.getEnable().booleanValue()) {
                    String requestSign = baseRequest.getHeader().getSign();
                    baseRequest.getHeader().setSign(null);
                    String sign = SignUtil.signRequest((BaseRequest)baseRequest, (String)interfaceUser.getSecret());
                    retVal = sign.equals(requestSign) ? pjp.proceed() : BaseResponse.createError((String)"2002", (String)"\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u7b7e\u540d\u751f\u6210\u662f\u5426\u6b63\u786e");
                } else {
                    retVal = BaseResponse.createError((String)"2001", (String)"\u65e0\u6743\u9650\u8bbf\u95ee\uff0c\u8bf7\u786e\u8ba4appId\u53caappKey\u662f\u5426\u6b63\u786e");
                }
            } else {
                retVal = BaseResponse.createError((String)"9002", (String)"API\u8fd4\u56de\u9519\u8bef\u4ee3\u7801-\u83b7\u53d6\u4e0d\u5230HEADER");
            }
        } else {
            retVal = BaseResponse.createError((String)"9001", (String)"API\u8fd4\u56de\u9519\u8bef\u4ee3\u7801-\u83b7\u53d6\u4e0d\u5230BaseRequest\u53c2\u6570\uff0c\u4e0d\u8981\u4e71\u7528ApiService\u6ce8\u89e3");
        }
        return retVal;
    }
}

