/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.picc.gz.admin.datasource.DatabaseType;
import com.picc.gz.admin.datasource.DynamicDataSource;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import tk.mybatis.spring.annotation.MapperScan;

@Configuration
@MapperScan(basePackages={"com.picc.gz.admin.dao", "com.picc.gz.model.mapper.main"})
public class DatasourceConfig {
    @Autowired
    private Environment env;

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.sfzn")
    public DataSource sfznDataSource() {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        return dataSource;
    }

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.druid.hdr")
    public DataSource hdrDataSource() throws Exception {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        return dataSource;
    }

    @Bean
    @Primary
    public DynamicDataSource dataSource(@Qualifier(value="sfznDataSource") DataSource sfznDataSource, @Qualifier(value="hdrDataSource") DataSource hdrDataSource) {
        HashMap<DatabaseType, DataSource> targetDataSources = new HashMap<DatabaseType, DataSource>();
        targetDataSources.put(DatabaseType.sfzn, sfznDataSource);
        targetDataSources.put(DatabaseType.hdr, hdrDataSource);
        DynamicDataSource dataSource = new DynamicDataSource();
        dataSource.setTargetDataSources(targetDataSources);
        dataSource.setDefaultTargetDataSource((Object)sfznDataSource);
        return dataSource;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(DynamicDataSource dataSource) throws Exception {
        SqlSessionFactoryBean fb = new SqlSessionFactoryBean();
        fb.setDataSource((DataSource)dataSource);
        return fb.getObject();
    }
}

