/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.dao;

import com.picc.gz.admin.dao.provider.CusRecommendDaoProvider;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.CusRecommendPolicy;
import com.picc.gz.model.model.CusRecommendSign;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import tk.mybatis.mapper.common.Mapper;

public interface CusRecommendMapper
extends Mapper<CusRecommend> {
    @Select(value={"SELECT rc.ID_NUMBER FROM SFZN_CUS_RECOMMEND_CUSTOMER rc  JOIN SFZN_CUS_RECOMMEND r ON r.CUS_CUSTOMER_ID = rc.ID  WHERE r.ID = #{recommendId}"})
    public String findCustomerIdnumByRecommendId(@Param(value="recommendId") String var1);

    @Select(value={"SELECT p.ID_NUMBER FROM SFZN_CUS_RECOMMEND_PERSONNEL p  WHERE p.RECOMMEND_ID = #{recommendId} AND p.TYPE = 1 AND p.IS_DELETE <> 1"})
    public String findApplicatorIdnumByRecommendId(@Param(value="recommendId") String var1);

    @Update(value={"UPDATE SFZN_CUS_RECOMMEND c SET c.STATUS = #{status}, c.VERSION = c.VERSION + 1 WHERE c.ID = #{recommendId}"})
    public int updateStatus(@Param(value="recommendId") String var1, @Param(value="status") String var2);

    @Select(value={"SELECT c.STATUS from SFZN_CUS_RECOMMEND c WHERE c.ID = #{recommendId}"})
    public String getStatus(@Param(value="recommendId") String var1);

    @Select(value={"SELECT * from SFZN_CUS_RECOMMEND c where c.ID = #{batchId}"})
    public List<CusRecommend> findByBatchId(@Param(value="batchId") String var1);

    @Update(value={"UPDATE SFZN_CUS_RECOMMEND c SET c.PROPOSAL_NO = #{propasalNo}, c.POLICY_NO = #{policyNo}, c.POLICY_TIME = NOW(),  c.LAST_UPDATED = NOW(), c.STATUS = #{status}, c.COMMISSION = #{commission}, c.VERSION = c.VERSION + 1  WHERE c.ID = #{recommendId}"})
    public int updatePolicyNo(@Param(value="recommendId") String var1, @Param(value="propasalNo") String var2, @Param(value="policyNo") String var3, @Param(value="status") String var4, @Param(value="commission") BigDecimal var5);

    @SelectProvider(method="queryPolicy", type=CusRecommendDaoProvider.class)
    public List<CusRecommendPolicy> queryPolicy(@Param(value="recommendId") String var1, @Param(value="idNumber") String var2, @Param(value="policyTimeStart") Date var3, @Param(value="policyTimeEnd") Date var4, @Param(value="tsUserCode") String var5, @Param(value="licenseNo") String var6, @Param(value="name") String var7, @Param(value="comCode") String var8);

    @SelectProvider(method="querySigned", type=CusRecommendDaoProvider.class)
    public List<CusRecommendSign> querySigned(@Param(value="tsUserCode") String var1, @Param(value="customerName") String var2, @Param(value="insureDateStart") Date var3, @Param(value="insureDateEnd") Date var4, @Param(value="riskCode") List<String> var5);

    @SelectProvider(method="queryCusSigned", type=CusRecommendDaoProvider.class)
    public List<CusRecommendSign> queryCusSigned(@Param(value="tsUserCode") String var1, @Param(value="customerName") String var2, @Param(value="insureDateStart") Date var3, @Param(value="insureDateEnd") Date var4, @Param(value="riskCode") List<String> var5);

    @Update(value={"UPDATE SFZN_CUS_RECOMMEND c SET c.POLICY_SMS_FLAG = #{status}, c.LAST_UPDATED = NOW(), c.VERSION = c.VERSION + 1  WHERE c.ID = #{recommendId}"})
    public void updateSmsSendFlag(@Param(value="recommendId") String var1, @Param(value="status") Integer var2);

    @Select(value={"SELECT c.SIGN_URL FROM SFZN_CUS_RECOMMEND c  WHERE c.ID = #{recommendId}"})
    public String getSignImage(@Param(value="recommendId") String var1);

    @Select(value={"select b.ID_NUMBER  from SFZN_CUS_RECOMMEND a,SFZN_CUS_RECOMMEND_PERSONNEL b where a.id = b.RECOMMEND_ID and a.id = #{recommendId} and b.IS_DELETE <>'1' and b.type = '2';"})
    public String getInsurerIdNumber(@Param(value="recommendId") String var1);

    @Select(value={"select  DISTINCT a.RISK_CODE from SFZN_CUS_RECOMMEND a,SFZN_CUS_RECOMMEND_PERSONNEL b where a.id = b.RECOMMEND_ID and a.id = #{recommendId} and b.IS_DELETE <>'1' and b.type = '2';"})
    public String isRenewal2(@Param(value="recommendId") String var1);

    @Select(value={"SELECT MAX(ENDDATE_LIMITS) FROM SFZN_INSURANCE_PRODUCT_ITEM WHERE RISK_CODE = #{riskCode};"})
    public int getMaxEndDay(@Param(value="riskCode") String var1);
}

