/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.dao.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.picc.gz.admin.dao.CustomerIdentityDao;
import com.picc.gz.admin.vo.CustomerCoutVo;
import com.picc.gz.utils.jdbc.JdbcTemplatePlus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Component;

@Component
public class CustomerIdentityDaoImpl
implements CustomerIdentityDao {
    @Autowired
    private JdbcTemplatePlus jdbcTemplate;
    private static final Logger logger = LoggerFactory.getLogger(CustomerIdentityDaoImpl.class);

    public String getCustomerBaseInfo(String identifyNo, String licenseNo, String frameNo, String uuid) {
        StringBuffer sbOne = new StringBuffer();
        StringBuffer sbTwo = new StringBuffer();
        JSONObject jb = new JSONObject();
        jb.put("baseInfoId", (Object)uuid);
        StringBuffer sb = new StringBuffer("select cus.identifynumber,cus.identifynumber1,cus.idflag, cus.insuredname,cus.sex,cus.birthyear,cus.birthdate,cus.insuredaddress,cus.phonenumber,");
        sb.append("cus.count_car,cus.tb_count,cus.values,cuc.licenseno,cuc.frameno,cuc.flag_own,cuc.flag_insured,cuc.flag_apply,cuc.transferVehicleFlag,car.engineno,");
        sb.append("car.brand_name,car.purchaseprice,car.carkindname,car.usenaturecode,car.nonlocalflag,car.enrolldate,car.brandname,car.enddate_bi,car.enddate_ci,");
        sb.append("car.sumpremium_bi,car.sumpremium_ci,car.nodamyears,car.renewal_rate,car.damage_rate,car.xb_count,car.recommend_car,car.recommend_prp,car.tb_count,");
        sb.append("car.claimno_count,car.damagename as c_damagename,car.sumpaid_wj as car_wj,cb.policyno as cb_policyno,cb.sumpremium,cb.riskkind,cb.startdate,cb.enddate,");
        sb.append("cb.operatedate,cb.comcode,cb.renewflag,cb.businessnature,cb.monopolyname,cb.enrolldate,cb.operatedate_tq,cb.costfee,cb.costrate,cb.handlername,");
        sb.append("lp.policyno as lp_policyno,lp.registno,lp.claimno,lp.claimdate,lp.personloss,lp.damagename,lp.damageaddress,lp.damagedate,lp.endcasedate,lp.sumclaim,");
        sb.append("lp.sumpaid_wj as lp_wj,lp.checker1,lp.biciflag,lp.endcasedate,lp.proploss_c,lp.carloss_c,lp.dqflag_c,ts.apldate,ts.aplname,ts.cname,  ");
        sb.append("prp.policyno as prp_policyno,prp.riskcname,prp.sumpremium as prp_sumpremium,prp.claimno_count as prp_claimno_count,  ");
        sb.append("csi.server_name,csi.server_number,csi.server_value, csi.server_date ");
        sb.append("from  middle_cardraw_Customer cus ");
        sb.append("join middle_cardraw_CustCar cuc on cus.identifynumber=cuc.identifynumber and cus.insuredname=cuc.insuredname ");
        sb.append("join middle_cardraw_Car car on car.licenseno=cuc.licenseno and car.frameno=cuc.frameno ");
        sb.append("join middle_cardraw_cb cb on cb.licenseno=cuc.licenseno and cb.frameno=cuc.frameno ");
        sb.append("left join middle_cardraw_lp lp on lp.licenseno=cuc.licenseno and lp.frameno=cuc.frameno ");
        sb.append("left join middle_95518_app_biz_ts_ii ts on ts.licenseno=cuc.licenseno and ts.frameno=cuc.frameno ");
        sb.append("left join customer_prp_info prp on cus.identifynumber= prp.identifynumber ");
        sb.append("left join cardraw_Server_info csi on csi.licenseno= cuc.licenseno and csi.frameno=cuc.frameno ");
        try {
            if (this.isNotEmpty(identifyNo) && this.checkIdentifyNo(identifyNo)) {
                sb.append("where cus.identifynumber='").append(identifyNo).append("' ");
                sb.append("and cuc.row_num='1' ");
                logger.info(sb.toString());
                long start = System.currentTimeMillis();
                SqlRowSet customer = this.jdbcTemplate.queryForRowSet(sb.toString());
                long end = System.currentTimeMillis();
                logger.info("1----sql\u6267\u884c\u65f6\u957f\uff1a" + (end - start) + "ms");
                JSONArray array = this.resultSetToArray(customer);
                JSONObject jbTemp = this.jsonArrayToCarAndCustomerJson(array);
                if (jbTemp.get((Object)"flag") == "true") {
                    jb.put("flag", (Object)"success");
                    jb.put("customer", (Object)jbTemp);
                    jb.put("defaultLicenseNo", (Object)licenseNo);
                    logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u6570\u636e\u6210\u529f......");
                } else {
                    jb.put("flag", (Object)"failure");
                    jb.put("message", (Object)"\u5ba2\u6237\u753b\u50cf\u5e93\u67e5\u65e0\u6570\u636e\uff0c\u6b64\u8f66\u53ef\u80fd\u4e3a\u8f6c\u4fdd\u8f66\u8f86");
                    logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u53f7\u672a\u83b7\u53d6\u5230\u76f8\u5173\u6570\u636e......");
                }
            } else {
                sbOne.append("where cus.identifynumber = (select distinct cus.identifynumber from middle_cardraw_Customer cus ");
                sbOne.append("join middle_cardraw_CustCar cuc on cus.identifynumber=cuc.identifynumber and cus.insuredname=cuc.insuredname ");
                sbOne.append("where cuc.licenseno='").append(licenseNo).append("' ");
                if (this.isNotEmpty(frameNo)) {
                    sbOne.append("and cuc.frameNo='").append(frameNo).append("' ");
                }
                sbOne.append(" )").append("union all");
                sbTwo.append("where cus.identifynumber = (select distinct cus.identifynumber from middle_cardraw_Customer cus ");
                sbTwo.append("join middle_cardraw_CustCar cuc on cus.identifynumber=cuc.identifynumber and cus.insuredname=cuc.insuredname ");
                sbTwo.append("where cuc.licenseno='").append(licenseNo).append("' ");
                if (this.isNotEmpty(frameNo)) {
                    sbTwo.append("and cuc.frameNo='").append(frameNo).append("' ");
                }
                sbTwo.append("and cuc.row_num='1' )");
                String sql = sb.toString() + sbOne.toString() + sb.toString() + sbTwo.toString();
                logger.info(sql);
                long start = System.currentTimeMillis();
                SqlRowSet customer = this.jdbcTemplate.queryForRowSet(sql);
                long end = System.currentTimeMillis();
                logger.info("2----sql\u6267\u884c\u65f6\u957f\uff1a" + (end - start) + "ms");
                JSONArray array = this.resultSetToArray(customer);
                JSONObject jbTemp = this.jsonArrayToCarAndCustomerJson(array);
                if (jbTemp.get((Object)"flag") == "true") {
                    jb.put("flag", (Object)"success");
                    jb.put("customer", (Object)jbTemp);
                    jb.put("defaultLicenseNo", (Object)licenseNo);
                    jb.put("baseInfoId", (Object)uuid);
                    logger.info("\u6839\u636e\u8f66\u724c\u53f7\u83b7\u53d6\u6570\u636e\u6210\u529f......");
                } else {
                    jb.put("flag", (Object)"failure");
                    jb.put("message", (Object)"\u5ba2\u6237\u753b\u50cf\u5e93\u67e5\u65e0\u6570\u636e\uff0c\u6b64\u8f66\u53ef\u80fd\u4e3a\u8f6c\u4fdd\u8f66\u8f86");
                    logger.info("\u6839\u636e\u8f66\u724c\u53f7\u672a\u83b7\u53d6\u5230\u76f8\u5173\u6570\u636e......");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            jb.put("flag", (Object)"failure");
            jb.put("message", (Object)"\u83b7\u53d6\u5ba2\u6237\u753b\u50cf\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5......");
            logger.info("\u83b7\u53d6\u5ba2\u6237\u6570\u636e\u5f02\u5e38......");
        }
        return jb.toString();
    }

    public JSONObject getCarAndCustomerInfo(String licenseNo, String frameNo, String uuid) {
        StringBuffer sb = new StringBuffer();
        JSONObject jb = new JSONObject();
        jb.put("baseInfoId", (Object)uuid);
        sb.append("select cus.identifynumber,cus.identifynumber1,cus.gradename,cus.idflag, cus.insuredname,cus.sex,cus.birthyear,cus.birthdate,cus.insuredaddress,cus.phonenumber,");
        sb.append("cus.count_car,cus.tb_count,cus.values,cuc.licenseno,cuc.frameno,cuc.flag_own,cuc.flag_insured,cuc.flag_apply,cuc.transfervehicleflag,car.engineno,");
        sb.append("car.brand_name,car.purchaseprice,car.carkindname,car.usenaturecode,car.nonlocalflag,car.enrolldate,car.brandname,car.enddate_bi,car.enddate_ci,");
        sb.append("car.sumpremium_bi,car.sumpremium_ci,car.nodamyears,car.renewal_rate,car.damage_rate,car.xb_count,car.recommend_car,car.recommend_prp,car.tb_count,");
        sb.append("car.claimno_count,car.damagename as c_damagename,car.sumpaid_wj as car_wj,cb.policyno as cb_policyno,cb.sumpremium,cb.riskkind,cb.startdate,cb.enddate,");
        sb.append("cb.operatedate,cb.comcode,cb.renewflag,cb.businessnature,cb.monopolyname,cb.enrolldate,cb.operatedate_tq,cb.costfee,cb.costrate,cb.handlername,");
        sb.append("lp.policyno as lp_policyno,lp.registno,lp.claimno,lp.claimdate,lp.personloss,lp.damagename,lp.damageaddress,lp.damagedate,lp.endcasedate,lp.sumclaim,");
        sb.append("lp.sumpaid_wj as lp_wj,lp.checker1,lp.biciflag,lp.endcasedate,lp.proploss_c,lp.carloss_c,lp.dqflag_c,ts.apldate,ts.aplname,ts.cname,  ");
        sb.append("prp.policyno as prp_policyno,prp.riskcname,prp.sumpremium as prp_sumpremium,prp.claimno_count as prp_claimno_count, prp.enddate as prp_enddate, ");
        sb.append("csi.server_name,csi.server_number,csi.server_value, csi.server_date ");
        sb.append("from  middle_cardraw_Customer cus ");
        sb.append("join middle_cardraw_CustCar cuc on cus.identifynumber=cuc.identifynumber and cus.insuredname=cuc.insuredname ");
        sb.append("join middle_cardraw_Car car on car.licenseno=cuc.licenseno and car.frameno=cuc.frameno ");
        sb.append("join middle_cardraw_cb cb on cb.licenseno=cuc.licenseno and cb.frameno=cuc.frameno ");
        sb.append("left join middle_cardraw_lp lp on lp.licenseno=cuc.licenseno and lp.frameno=cuc.frameno ");
        sb.append("left join middle_95518_app_biz_ts_ii ts on ts.licenseno=cuc.licenseno and ts.frameno=cuc.frameno ");
        sb.append("left join customer_prp_info prp on cus.identifynumber= prp.identifynumber ");
        sb.append("left join cardraw_Server_info csi on csi.licenseno= cuc.licenseno and csi.frameno=cuc.frameno ");
        sb.append("where cus.identifynumber = (select distinct cus.identifynumber from middle_cardraw_Customer cus ");
        sb.append("join middle_cardraw_CustCar cuc on cus.identifynumber=cuc.identifynumber and cus.insuredname=cuc.insuredname ");
        sb.append("where cuc.licenseno='").append(licenseNo).append("' ");
        if (this.isNotEmpty(frameNo)) {
            sb.append("and cuc.frameNo='").append(frameNo).append("' ");
        }
        sb.append(" and cuc.row_num='1' )");
        try {
            logger.info(sb.toString());
            long start = System.currentTimeMillis();
            SqlRowSet customer = this.jdbcTemplate.queryForRowSet(sb.toString());
            long end = System.currentTimeMillis();
            logger.info("\u6839\u636e\u8f66\u724c\u53f7\u3001\u8f66\u67b6\u53f7\u83b7\u53d6\u8f66\u8f86\u3001\u8f66\u4e3b\u4fe1\u606f sql\u6267\u884c\u65f6\u957f\uff1a" + (end - start) + "ms");
            JSONArray array = this.resultSetToArray(customer);
            JSONObject jbTemp = this.jsonArrayToCarAndCustomerJson(array);
            if (jbTemp.get((Object)"flag").equals("true")) {
                jb.put("flag", (Object)"success");
                jb.put("customer", (Object)jbTemp);
                jb.put("defaultLicenseNo", (Object)licenseNo);
                jb.put("baseInfoId", (Object)uuid);
                logger.info("\u6839\u636e\u8f66\u724c\u53f7\u3001\u8f66\u67b6\u53f7\u83b7\u53d6\u8f66\u8f86\u3001\u8f66\u4e3b\u4fe1\u606f\u6210\u529f......");
            } else {
                jb.put("flag", (Object)"failure");
                jb.put("message", (Object)"\u5ba2\u6237\u753b\u50cf\u5e93\u67e5\u65e0\u6570\u636e\uff0c\u6b64\u8f66\u53ef\u80fd\u4e3a\u8f6c\u4fdd\u8f66\u8f86");
                logger.info("\u6839\u636e\u8f66\u724c\u53f7\u3001\u8f66\u67b6\u53f7\u672a\u83b7\u53d6\u5230\u76f8\u5173\u6570\u636e......");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            jb.put("flag", (Object)"failure");
            jb.put("message", (Object)"\u83b7\u53d6\u5ba2\u6237\u753b\u50cf\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5......");
            logger.info("\u6839\u636e\u8f66\u724c\u53f7\u3001\u8f66\u67b6\u53f7\u83b7\u53d6\u8f66\u8f86\u3001\u8f66\u4e3b\u4fe1\u606f\u5f02\u5e38......");
        }
        return jb;
    }

    public JSONObject getPartyInfoByLicenseNoAndFrameNo(String licenseNo, String frameNo) {
        StringBuffer sb = new StringBuffer();
        JSONObject jb = new JSONObject();
        sb.append("select ");
        sb.append("cus.identifynumber, cus.identifynumber1, cus.insuredname, cus.sex, cus.birthyear, cus.birthdate, ");
        sb.append("cus.insuredaddress, cus.phonenumber, cus.count_car, cus.tb_count, cus.values,");
        sb.append("cuc.licenseno, cuc.flag_own, cuc.flag_insured, cuc.flag_apply, cuc.transfervehicleflag ");
        sb.append("from middle_cardraw_Customer cus ");
        sb.append("join middle_cardraw_CustCar cuc on cus.identifynumber = cuc.identifynumber and cus.insuredname = cuc.insuredname ");
        sb.append("where cus.identifynumber = ");
        sb.append("( select distinct cus.identifynumber ");
        sb.append("  from middle_cardraw_Customer cus ");
        sb.append("  join middle_cardraw_CustCar cuc on cus.identifynumber = cuc.identifynumber and cus.insuredname = cuc.insuredname ");
        sb.append("  where cuc.licenseno = '").append(licenseNo).append("' ");
        if (this.isNotEmpty(frameNo)) {
            sb.append("and cuc.frameNo = '").append(frameNo).append("' ");
        }
        sb.append("  and cuc.row_num = '2' )");
        try {
            logger.info(sb.toString());
            long start = System.currentTimeMillis();
            SqlRowSet partys = this.jdbcTemplate.queryForRowSet(sb.toString());
            long end = System.currentTimeMillis();
            logger.info("\u6839\u636e\u8f66\u724c\u53f7\u3001\u8f66\u67b6\u53f7\u67e5\u627e\u5176\u4ed6\u5173\u7cfb\u4eba\u4fe1\u606f(row_num = 2) sql\u6267\u884c\u65f6\u957f\uff1a" + (end - start) + "ms");
            JSONArray array = this.resultSetToArray(partys);
            JSONObject jbTemp = this.jsonArrayToPartyJson(array);
            if (jbTemp.get((Object)"flag") == "true") {
                jb.put("partyFlag", (Object)"success");
                jb.put("party", jbTemp.get((Object)"party"));
                logger.info("\u6839\u636e\u8f66\u724c\u53f7\u3001\u8f66\u67b6\u53f7\u67e5\u627e\u5176\u4ed6\u5173\u7cfb\u4eba\u4fe1\u606f(row_num = 2)\u6210\u529f......");
            } else {
                jb.put("partyFlag", (Object)"failure");
                jb.put("message", (Object)"\u65e0\u5176\u4ed6\u5173\u7cfb\u4eba\u4fe1\u606f");
                logger.info("\u65e0\u5176\u4ed6\u5173\u7cfb\u4eba\u4fe1\u606f......");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            jb.put("partyFlag", (Object)"failure");
            jb.put("message", (Object)"\u83b7\u53d6\u5176\u4ed6\u5173\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5......");
            logger.info("\u6839\u636e\u8f66\u724c\u53f7\u3001\u8f66\u67b6\u53f7\u67e5\u627e\u5176\u4ed6\u5173\u7cfb\u4eba\u4fe1\u606f(row_num = 2)\u5f02\u5e38......");
        }
        return jb;
    }

    public JSONObject getCarAndCustomerInfoByIdentyNo(String identifyNo, String defaultLicenseNo, String uuid) {
        StringBuffer sb = new StringBuffer();
        JSONObject jb = new JSONObject();
        jb.put("baseInfoId", (Object)uuid);
        sb.append("select cus.identifynumber,cus.identifynumber1,cus.idflag, cus.insuredname,cus.sex,cus.birthyear,cus.birthdate,cus.insuredaddress,cus.phonenumber,");
        sb.append("cus.count_car,cus.tb_count,cus.values,cuc.licenseno,cuc.frameno,cuc.flag_own,cuc.flag_insured,cuc.flag_apply,cuc.transfervehicleflag,car.engineno,");
        sb.append("car.brand_name,car.purchaseprice,car.carkindname,car.usenaturecode,car.nonlocalflag,car.enrolldate,car.brandname,car.enddate_bi,car.enddate_ci,");
        sb.append("car.sumpremium_bi,car.sumpremium_ci,car.nodamyears,car.renewal_rate,car.damage_rate,car.xb_count,car.recommend_car,car.recommend_prp,car.tb_count,");
        sb.append("car.claimno_count,car.damagename as c_damagename,car.sumpaid_wj as car_wj,cb.policyno as cb_policyno,cb.sumpremium,cb.riskkind,cb.startdate,cb.enddate,");
        sb.append("cb.operatedate,cb.comcode,cb.RenewFlag,cb.BusinessNature,cb.Monopolyname,cb.enrolldate,cb.operatedate_tq,cb.costfee,cb.costrate,cb.handlername,");
        sb.append("lp.policyno as lp_policyno,lp.registno,lp.claimno,lp.claimdate,lp.personloss,lp.DAMAGENAME,lp.damageaddress,lp.damagedate,lp.endcasedate,lp.sumclaim,");
        sb.append("lp.sumpaid_wj as lp_wj,lp.CHECKER1,lp.biciflag,lp.endcasedate,lp.proploss_c,lp.carloss_c,lp.dqflag_c,ts.apldate,ts.aplname,ts.cname,  ");
        sb.append("prp.policyno as prp_policyno,prp.riskcname,prp.sumpremium as prp_sumpremium,prp.claimno_count as prp_claimno_count, prp.enddate as prp_enddate, ");
        sb.append("csi.server_name,csi.server_number,csi.server_value, csi.server_date ");
        sb.append("from  middle_cardraw_Customer cus ");
        sb.append("join middle_cardraw_CustCar cuc on cus.identifynumber=cuc.identifynumber and cus.insuredname=cuc.insuredname ");
        sb.append("join middle_cardraw_Car car on car.licenseno=cuc.licenseno and car.frameno=cuc.frameno ");
        sb.append("join middle_cardraw_cb cb on cb.licenseno=cuc.licenseno and cb.frameno=cuc.frameno ");
        sb.append("left join middle_cardraw_lp lp on lp.licenseno=cuc.licenseno and lp.frameno=cuc.frameno ");
        sb.append("left join middle_95518_app_biz_ts_ii ts on ts.licenseno=cuc.licenseno and ts.frameno=cuc.frameno ");
        sb.append("left join customer_prp_info prp on cus.identifynumber= prp.identifynumber ");
        sb.append("left join cardraw_Server_info csi on csi.licenseno= cuc.licenseno and csi.frameno=cuc.frameno ");
        sb.append("where cus.identifynumber = '").append(identifyNo).append("' ");
        try {
            logger.info(sb.toString());
            long start = System.currentTimeMillis();
            SqlRowSet customer = this.jdbcTemplate.queryForRowSet(sb.toString());
            long end = System.currentTimeMillis();
            logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u8f66\u8f86\u3001\u8f66\u4e3b\u4fe1\u606f sql\u6267\u884c\u65f6\u957f\uff1a" + (end - start) / 1000L + "s");
            JSONArray array = this.resultSetToArray(customer);
            JSONObject jbTemp = this.jsonArrayToCarAndCustomerJson(array);
            if (jbTemp.get((Object)"flag") == "true") {
                jb.put("flag", (Object)"success");
                jb.put("customer", (Object)jbTemp);
                jb.put("defaultLicenseNo", (Object)defaultLicenseNo);
                jb.put("baseInfoId", (Object)uuid);
                logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u8f66\u8f86\u3001\u8f66\u4e3b\u4fe1\u606f\u6210\u529f......");
            } else {
                jb.put("flag", (Object)"failure");
                jb.put("message", (Object)"\u5ba2\u6237\u753b\u50cf\u5e93\u67e5\u65e0\u6570\u636e\uff0c\u6b64\u8f66\u53ef\u80fd\u4e3a\u8f6c\u4fdd\u8f66\u8f86");
                logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u53f7\u672a\u83b7\u53d6\u5230\u76f8\u5173\u6570\u636e......");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            jb.put("flag", (Object)"failure");
            jb.put("message", (Object)"\u83b7\u53d6\u5ba2\u6237\u753b\u50cf\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5......");
            logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u8f66\u8f86\u3001\u8f66\u4e3b\u4fe1\u606f\u5f02\u5e38......");
        }
        return jb;
    }

    public void recordCustomerBaseInfo(CustomerCoutVo countVo) {
        String btnType = "";
        btnType = countVo.getBtnType() != null && countVo.getBtnType() != "" ? countVo.getBtnType() : "new";
        String sql = "insert into middle_cardraw_count(id,usercode,username,deptname,pathname,licenseno,operatedate,obtainflag,identifyno,host,btntype) values ('" + countVo.getId() + "','" + countVo.getUserCode() + "','" + countVo.getUserName() + "','" + countVo.getDeptName() + "','" + countVo.getPathName() + "','" + countVo.getLicenseNo() + "','" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "','" + countVo.getObtainFlag() + "','" + countVo.getIdentifyNo() + "','" + countVo.getHost() + "','" + btnType + "')";
        this.jdbcTemplate.update(sql);
    }

    public void recordAdvices(CustomerCoutVo countVo) {
        String sql = "update middle_cardraw_count set advice = '" + countVo.getAdvice() + "', advicedate = '" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "' where id = '" + countVo.getId() + "'";
        this.jdbcTemplate.update(sql);
    }

    public Long getInfoCount(String identifyNo, String licenseNo, String frameNo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(*) from middle_cardraw_Customer cus ");
        sb.append("join middle_cardraw_CustCar cuc on cus.identifynumber=cuc.identifynumber and cus.insuredname=cuc.insuredname ");
        if (this.isNotEmpty(identifyNo) && this.checkIdentifyNo(identifyNo)) {
            sb.append("where cus.identifynumber='").append(identifyNo).append("' ");
            sb.append("and cuc.row_num='1' ");
        } else {
            sb.append("where cus.identifynumber = (select distinct cus.identifynumber from middle_cardraw_Customer cus ");
            sb.append("join middle_cardraw_CustCar cuc on cus.identifynumber=cuc.identifynumber and cus.insuredname=cuc.insuredname ");
            sb.append("where cuc.licenseno='").append(licenseNo).append("' ");
            if (this.isNotEmpty(frameNo)) {
                sb.append("and cuc.frameNo='").append(frameNo).append("' ");
            }
            sb.append("and cuc.row_num='1' ");
        }
        String sql = sb.toString();
        logger.info("\u51c6\u5907\u67e5\u8be2\u662f\u5426\u5b58\u5728\u5ba2\u6237\u753b\u50cf\u6570\u636eSQL\uff1a" + sql);
        long start = System.currentTimeMillis();
        Long count = (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
        long end = System.currentTimeMillis();
        logger.info("sql\u6267\u884c\u65f6\u957f\uff1a" + (end - start) / 1000L + "s");
        return count;
    }

    public JSONObject getBaseInfoRowNum(String identifyNo, String licenseNo, String frameNo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct cuc.row_num as cuc_row_num from middle_cardraw_Customer cus ");
        sb.append("join middle_cardraw_CustCar cuc on cus.identifynumber = cuc.identifynumber and cus.insuredname = cuc.insuredname ");
        if (this.isNotEmpty(identifyNo) && this.checkIdentifyNo(identifyNo)) {
            sb.append("where cus.identifynumber = '").append(identifyNo).append("' ");
        } else {
            sb.append("where cus.identifynumber = (select distinct cus.identifynumber from middle_cardraw_Customer cus ");
            sb.append("join middle_cardraw_CustCar cuc on cus.identifynumber = cuc.identifynumber and cus.insuredname = cuc.insuredname ");
            sb.append("where cuc.licenseno = '").append(licenseNo).append("' ");
            if (this.isNotEmpty(frameNo)) {
                sb.append("and cuc.frameNo = '").append(frameNo).append("' )");
            }
        }
        logger.info("\u51c6\u5907\u67e5\u8be2\u662f\u5426\u5b58\u5728\u5ba2\u6237\u753b\u50cf\u6570\u636eSQL\uff1a" + sb.toString());
        long start = System.currentTimeMillis();
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(sb.toString());
        long end = System.currentTimeMillis();
        logger.info("sql\u6267\u884c\u65f6\u957f\uff1a" + (end - start) + "ms");
        JSONObject jsonObj = new JSONObject();
        if (rs.next()) {
            int rowNum = rs.getInt("cuc_row_num");
            if (rowNum == 1) {
                jsonObj.put("row_num1", (Object)"1");
            } else if (rowNum == 2) {
                jsonObj.put("row_num2", (Object)"1");
            }
        }
        if (!"1".equals(jsonObj.get((Object)"row_num1"))) {
            jsonObj.put("row_num1", (Object)"0");
        }
        if (!"1".equals(jsonObj.get((Object)"row_num2"))) {
            jsonObj.put("row_num2", (Object)"0");
        }
        return jsonObj;
    }

    private boolean checkIdentifyNo(String no) {
        if (no == null || no.length() != 18 || !no.matches("\\d{17}[0-9X]")) {
            return false;
        }
        int[] factor = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        char[] random = "10X98765432".toCharArray();
        int total = 0;
        for (int i = 0; i < 17; ++i) {
            total += Character.getNumericValue(no.charAt(i)) * factor[i];
        }
        return random[total % 11] == no.charAt(17);
    }

    private boolean isNotEmpty(String s) {
        return s != null && !s.equals("");
    }

    private JSONArray resultSetToArray(SqlRowSet rs) throws Exception {
        JSONArray array = new JSONArray();
        SqlRowSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        while (rs.next()) {
            JSONObject jsonObj = new JSONObject();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = metaData.getColumnLabel(i);
                String value = rs.getString(columnName);
                if (this.isNotEmpty(value)) {
                    jsonObj.put(columnName, (Object)value);
                    continue;
                }
                jsonObj.put(columnName, (Object)"");
            }
            array.add((Object)jsonObj);
        }
        return array;
    }

    private JSONObject jsonArrayToCarAndCustomerJson(JSONArray array) {
        JSONObject json = new JSONObject();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd ");
        if (array.size() == 0) {
            json.put("flag", (Object)"false");
        } else {
            JSONObject jb = JSON.parseObject((String)array.get(0).toString());
            json.put("flag", (Object)"true");
            json.put("insuredname", jb.get((Object)"insuredname"));
            json.put("identifynumber", jb.get((Object)"identifynumber"));
            json.put("identifynumber1", jb.get((Object)"identifynumber1"));
            json.put("sex", jb.get((Object)"sex"));
            json.put("birthyear", jb.get((Object)"birthyear"));
            if (!jb.get((Object)"birthdate").equals("null") && !jb.get((Object)"birthdate").equals("")) {
                try {
                    json.put("birthdate", (Object)sdf.format(sdf.parse(jb.get((Object)"birthdate").toString())));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    json.put("birthdate", (Object)jb.get((Object)"birthdate").toString());
                }
            } else {
                json.put("birthdate", jb.get((Object)"birthdate"));
            }
            json.put("count_car", (Object)(jb.get((Object)"count_car") + "\u8f86"));
            json.put("claimno_count", jb.get((Object)"claimno_count"));
            json.put("tb_count", jb.get((Object)"tb_count"));
            json.put("address", jb.get((Object)"insuredaddress"));
            json.put("phones", jb.get((Object)"phonenumber"));
            json.put("gradename", jb.get((Object)"gradename"));
            json.put("idflag", jb.get((Object)"idflag"));
            json.put("tags", jb.get((Object)"values"));
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jbTemp = JSON.parseObject((String)array.get(i).toString());
                JSONObject car = new JSONObject();
                JSONObject carInfo = new JSONObject();
                JSONObject cb = new JSONObject();
                JSONObject lp = new JSONObject();
                JSONObject cars = new JSONObject();
                JSONObject prps = new JSONObject();
                JSONObject prp = new JSONObject();
                JSONObject cbs = new JSONObject();
                JSONObject lps = new JSONObject();
                JSONObject ts = new JSONObject();
                JSONObject tss = new JSONObject();
                JSONObject zzfw = new JSONObject();
                JSONArray zzfws = new JSONArray();
                car.put("frameno", jbTemp.get((Object)"frameno"));
                car.put("flag_own", jbTemp.get((Object)"flag_own"));
                car.put("flag_insured", jbTemp.get((Object)"flag_insured"));
                car.put("flag_apply", jbTemp.get((Object)"flag_apply"));
                car.put("transferVehicleFlag", jbTemp.get((Object)"transfervehicleflag"));
                car.put("engineno", jbTemp.get((Object)"engineno"));
                car.put("brand_name", jbTemp.get((Object)"brand_name"));
                car.put("purchaseprice", jbTemp.get((Object)"purchaseprice"));
                car.put("carkindname", jbTemp.get((Object)"carkindname"));
                car.put("usenaturecode", jbTemp.get((Object)"usenaturecode"));
                car.put("nonlocalflag", jbTemp.get((Object)"nonlocalflag"));
                car.put("enrolldate", jbTemp.get((Object)"enrolldate"));
                car.put("brandname", jbTemp.get((Object)"brandname"));
                car.put("enddate_bi", jbTemp.get((Object)"enddate_bi"));
                car.put("damagename", jbTemp.get((Object)"c_damagename"));
                car.put("enddate_ci", jbTemp.get((Object)"enddate_ci"));
                car.put("sumpremium_bi", jbTemp.get((Object)"sumpremium_bi"));
                car.put("sumpremium_ci", jbTemp.get((Object)"sumpremium_ci"));
                car.put("nodamyears", jbTemp.get((Object)"nodamyears"));
                car.put("renewal_rate", jbTemp.get((Object)"renewal_rate"));
                car.put("damage_rate", jbTemp.get((Object)"damage_rate"));
                car.put("xb_count", jbTemp.get((Object)"xb_count"));
                car.put("tb_count", jbTemp.get((Object)"tb_count"));
                car.put("claimno_count", jbTemp.get((Object)"claimno_count"));
                car.put("renewal_rate", jbTemp.get((Object)"renewal_rate"));
                car.put("damage_rate", jbTemp.get((Object)"damage_rate"));
                car.put("sumpaid_wj", jbTemp.get((Object)"car_wj"));
                car.put("recommend_car", jbTemp.get((Object)"recommend_car"));
                car.put("recommend_prp", jbTemp.get((Object)"recommend_prp"));
                lp.put("licenseno", jbTemp.get((Object)"licenseno"));
                lp.put("policyno", jbTemp.get((Object)"lp_policyno"));
                lp.put("registno", jbTemp.get((Object)"registno"));
                lp.put("claimno", jbTemp.get((Object)"claimno"));
                lp.put("claimdate", jbTemp.get((Object)"claimdate"));
                lp.put("personloss", jbTemp.get((Object)"personloss"));
                lp.put("damagename", jbTemp.get((Object)"damagename"));
                lp.put("damageaddress", jbTemp.get((Object)"damageaddress"));
                lp.put("damagedate", jbTemp.get((Object)"damagedate"));
                lp.put("endcasedate", jbTemp.get((Object)"endcasedate"));
                lp.put("sumclaim", jbTemp.get((Object)"sumclaim"));
                lp.put("sumpaid_wj", jbTemp.get((Object)"lp_wj"));
                lp.put("checker1", jbTemp.get((Object)"checker1"));
                lp.put("biciflag", jbTemp.get((Object)"biciflag"));
                lp.put("proploss_c", jbTemp.get((Object)"proploss_c"));
                lp.put("carloss_c", jbTemp.get((Object)"carloss_c"));
                lp.put("dqflag_c", jbTemp.get((Object)"dqflag_c"));
                cb.put("cb_policyno", jbTemp.get((Object)"cb_policyno"));
                cb.put("sumpremium", jbTemp.get((Object)"sumpremium"));
                cb.put("biciflag", jbTemp.get((Object)"biciflag"));
                cb.put("riskkind", jbTemp.get((Object)"riskkind"));
                cb.put("startdate", jbTemp.get((Object)"startdate"));
                cb.put("enddate", jbTemp.get((Object)"enddate"));
                cb.put("operatedate", jbTemp.get((Object)"operatedate"));
                cb.put("comcode", jbTemp.get((Object)"comcode"));
                cb.put("renewflag", jbTemp.get((Object)"renewflag"));
                cb.put("businessnature", jbTemp.get((Object)"businessnature"));
                cb.put("monopolyname", jbTemp.get((Object)"monopolyname"));
                cb.put("enrolldate", jbTemp.get((Object)"enrolldate"));
                cb.put("operatedate_tq", jbTemp.get((Object)"operatedate_tq"));
                cb.put("costfee", jbTemp.get((Object)"costfee"));
                cb.put("costrate", jbTemp.get((Object)"costrate"));
                cb.put("handlername", jbTemp.get((Object)"handlername"));
                ts.put("apldate", jbTemp.get((Object)"apldate"));
                ts.put("aplname", jbTemp.get((Object)"aplname"));
                ts.put("cname", jbTemp.get((Object)"cname"));
                prp.put("policyno", jbTemp.get((Object)"prp_policyno"));
                prp.put("riskcname", jbTemp.get((Object)"riskcname"));
                prp.put("sumpremium", jbTemp.get((Object)"prp_sumpremium"));
                prp.put("claimno_count", jbTemp.get((Object)"prp_claimno_count"));
                prp.put("enddate", jbTemp.get((Object)"prp_enddate"));
                zzfw.put("server_name", jbTemp.get((Object)"server_name"));
                zzfw.put("server_number", jbTemp.get((Object)"server_number"));
                zzfw.put("server_value", jbTemp.get((Object)"server_value"));
                zzfw.put("server_date", jbTemp.get((Object)"server_date"));
                if (i == 0) {
                    json.put("cars", (Object)cars);
                    json.put("prps", (Object)prps);
                }
                if (!this.includeKey(json.getJSONObject("cars"), jbTemp.get((Object)"licenseno").toString())) {
                    carInfo.put("carInfo", (Object)car);
                    json.getJSONObject("cars").put(jbTemp.get((Object)"licenseno").toString(), (Object)carInfo);
                    cbs.put(jbTemp.get((Object)"cb_policyno").toString(), (Object)cb);
                    json.getJSONObject("cars").getJSONObject(jbTemp.get((Object)"licenseno").toString()).put("cb", (Object)cbs);
                    lps.put(jbTemp.get((Object)"claimno").toString(), (Object)lp);
                    json.getJSONObject("cars").getJSONObject(jbTemp.get((Object)"licenseno").toString()).put("lp", (Object)lps);
                    tss.put(jbTemp.get((Object)"apldate").toString(), (Object)ts);
                    json.getJSONObject("cars").getJSONObject(jbTemp.get((Object)"licenseno").toString()).put("ts", (Object)tss);
                    zzfws.add(zzfws.size(), (Object)zzfw);
                    json.getJSONObject("cars").getJSONObject(jbTemp.get((Object)"licenseno").toString()).put("zzfw", (Object)zzfws);
                } else {
                    json.getJSONObject("cars").getJSONObject(jbTemp.get((Object)"licenseno").toString()).getJSONObject("cb").put(jbTemp.get((Object)"cb_policyno").toString(), (Object)cb);
                    json.getJSONObject("cars").getJSONObject(jbTemp.get((Object)"licenseno").toString()).getJSONObject("lp").put(jbTemp.get((Object)"claimno").toString(), (Object)lp);
                    json.getJSONObject("cars").getJSONObject(jbTemp.get((Object)"licenseno").toString()).getJSONObject("ts").put(jbTemp.get((Object)"apldate").toString(), (Object)ts);
                    if (!this.includeZzfw(json.getJSONObject("cars").getJSONObject(jbTemp.get((Object)"licenseno").toString()).getJSONArray("zzfw"), zzfw)) {
                        json.getJSONObject("cars").getJSONObject(jbTemp.get((Object)"licenseno").toString()).getJSONArray("zzfw").add(zzfws.size(), (Object)zzfw);
                    }
                }
                if (this.includeKey(json.getJSONObject("prps"), jbTemp.get((Object)"prp_policyno").toString())) continue;
                json.getJSONObject("prps").put(jbTemp.get((Object)"prp_policyno").toString(), (Object)prp);
            }
        }
        return json;
    }

    private JSONObject jsonArrayToPartyJson(JSONArray array) {
        JSONObject jsonObj = new JSONObject();
        if (array.size() <= 0) {
            jsonObj.put("flag", (Object)"false");
        } else {
            jsonObj.put("flag", (Object)"true");
            JSONObject jbTemp = JSONObject.parseObject((String)array.get(0).toString());
            JSONObject party = new JSONObject();
            party.put("identifynumber", jbTemp.get((Object)"identifynumber"));
            party.put("identifynumber1", jbTemp.get((Object)"identifynumber1"));
            party.put("insuredname", jbTemp.get((Object)"insuredname"));
            party.put("sex", jbTemp.get((Object)"sex"));
            party.put("birthyear", jbTemp.get((Object)"birthyear"));
            party.put("birthdate", jbTemp.get((Object)"birthdate"));
            party.put("address", jbTemp.get((Object)"insuredaddress"));
            party.put("phones", jbTemp.get((Object)"phonenumber"));
            party.put("count_car", jbTemp.get((Object)"count_car"));
            party.put("tb_count", jbTemp.get((Object)"tb_count"));
            party.put("tags", jbTemp.get((Object)"values"));
            party.put("licenseno", jbTemp.get((Object)"licenseno"));
            party.put("flag_own", jbTemp.get((Object)"flag_own"));
            party.put("flag_insured", jbTemp.get((Object)"flag_insured"));
            party.put("flag_apply", jbTemp.get((Object)"flag_apply"));
            party.put("transferVehicleFlag", jbTemp.get((Object)"transfervehicleflag"));
            jsonObj.put("party", (Object)party);
        }
        return jsonObj;
    }

    private boolean includeKey(JSONObject jb, String s) {
        return jb.keySet().contains(s);
    }

    private boolean includeZzfw(JSONArray zzfws, JSONObject zzfw) {
        boolean isInclude = false;
        if (zzfws.size() > 0) {
            for (int i = 0; i < zzfws.size(); ++i) {
                JSONObject zzfw1 = zzfws.getJSONObject(i);
                if (!zzfw.get((Object)"server_name").equals(zzfw1.get((Object)"server_name")) || !zzfw.get((Object)"server_number").equals(zzfw1.get((Object)"server_number")) || !zzfw.get((Object)"server_value").equals(zzfw1.get((Object)"server_value")) || !zzfw.get((Object)"server_date").equals(zzfw1.get((Object)"server_date"))) continue;
                isInclude = true;
            }
        }
        return isInclude;
    }
}

