/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.dao.impl;

import com.picc.gz.admin.dao.StatisticsDao;
import com.picc.gz.admin.vo.statistics.NewUserRegistrationNumVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class StatisticsDaoImpl
implements StatisticsDao {
    Logger logger = LoggerFactory.getLogger(StatisticsDaoImpl.class);
    private static final String STRING_ZERO = "0";
    private static final String STRING_ONE = "1";
    private static final String ALL_TYPE = "all";
    private static final String SUCCESS_TYPE = "success";
    private static final String FAILED_TYPE = "failed";
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<Map<String, Object>> getAllSources() {
        String sql = "select source from user_info group by source";
        List maps = this.jdbcTemplate.queryForList(sql);
        return maps;
    }

    public List<NewUserRegistrationNumVo> getNewCountByStartEndDateAndOwnerSystem(String startDate, String endDate, String channel) {
        String sql = "select to_char(date_created, 'yyyy-mm-dd') as dateCreated, nvl(count(*),0) as currentRegistNum \nfrom user_info where 1=1 ";
        StringBuffer sb = new StringBuffer(sql);
        ArrayList<String> queryList = new ArrayList<String>();
        if (StringUtils.isEmpty((Object)startDate) || StringUtils.isEmpty((Object)endDate)) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)channel)) {
            sb.append(" and owner_system = ? ");
            queryList.add(channel);
        }
        sb.append(" and date_created BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 \nGROUP BY to_char(date_created, 'yyyy-mm-dd') ORDER BY to_char(date_created, 'yyyy-mm-dd') ASC");
        queryList.add(startDate);
        queryList.add(endDate);
        return this.jdbcTemplate.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(NewUserRegistrationNumVo.class), queryList.toArray());
    }

    public List<NewUserRegistrationNumVo> getCountByStartEndDateAndSource(String startDate, String endDate, String source) {
        String mySql = "SELECT DATE_FORMAT(date_created, \"%Y-%m-%d\" ) as dateCreated , ifnull(COUNT(*),0) as currentRegistNum \nFROM user_info where 1=1 ";
        String sql = "select to_char(date_created, 'yyyy-mm-dd') as dateCreated, nvl(count(*),0) as currentRegistNum \nfrom user_info where 1=1 ";
        StringBuffer sb = new StringBuffer(sql);
        ArrayList<String> queryList = new ArrayList<String>();
        if (StringUtils.isEmpty((Object)startDate) || StringUtils.isEmpty((Object)endDate)) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)source)) {
            sb.append(" and source = ? ");
            queryList.add(source);
        }
        sb.append(" and date_created BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 \nGROUP BY to_char(date_created, 'yyyy-mm-dd') ORDER BY to_char(date_created, 'yyyy-mm-dd') ASC");
        queryList.add(startDate);
        queryList.add(endDate);
        return this.jdbcTemplate.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(NewUserRegistrationNumVo.class), queryList.toArray());
    }

    public List<Map<String, Object>> getCountEverySourceOnStartAndEndDate(String startDate, String endDate) {
        String sql = "select count(*) as registeredSum,source from user_info where owner_system = '1' and date_created between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 group by source";
        if (StringUtils.isEmpty((Object)startDate) || StringUtils.isEmpty((Object)endDate)) {
            return null;
        }
        List mapLists = this.jdbcTemplate.queryForList(sql, new Object[]{startDate, endDate});
        return mapLists;
    }

    public Long getAllRegisteredSumCount(String startDate, String endDate) {
        String sql = "select count(*) as sum from user_info where date_created between ? and DATE_ADD(?, INTERVAL 1 DAY) ";
        List countList = this.jdbcTemplate.queryForList(sql, new Object[]{startDate, endDate});
        if (countList.size() > 0) {
            return Long.valueOf(String.valueOf(((Map)countList.get(0)).get("sum")));
        }
        return 0L;
    }

    public Long getCountByStartAndEndDateAndPhoneActivedAndEmailActived(String startDate, String endDate, String phoneActived, String emailActived) {
        String sql = null;
        ArrayList<String> queryList = new ArrayList<String>();
        if (STRING_ZERO.equals(phoneActived) && STRING_ZERO.equals(emailActived)) {
            sql = "select count(*) as sum from USER_INFO where\n DATE_CREATED BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1\nand PHONE_ACTIVED = '0' and EMAIL_ACTIVED = '0'";
            queryList.add(startDate);
            queryList.add(endDate);
        } else if (STRING_ZERO.equals(phoneActived) && STRING_ONE.equals(emailActived)) {
            sql = "select count(*) as sum from USER_INFO where\n DATE_CREATED BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1\nand EMAIL_ACTIVED_TIME BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1";
            queryList.add(startDate);
            queryList.add(endDate);
            queryList.add(startDate);
            queryList.add(endDate);
        } else if (STRING_ONE.equals(phoneActived) && STRING_ZERO.equals(emailActived)) {
            sql = "select count(*) as sum from USER_INFO where\n DATE_CREATED BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1\nand PHONE_ACTIVED_TIME BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1";
            queryList.add(startDate);
            queryList.add(endDate);
            queryList.add(startDate);
            queryList.add(endDate);
        } else {
            sql = "select count(*) as sum from USER_INFO where\n DATE_CREATED BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1\nand PHONE_ACTIVED_TIME BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1\nand EMAIL_ACTIVED_TIME BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1";
            queryList.add(startDate);
            queryList.add(endDate);
            queryList.add(startDate);
            queryList.add(endDate);
            queryList.add(startDate);
            queryList.add(endDate);
        }
        List countList = this.jdbcTemplate.queryForList(sql, queryList.toArray());
        if (countList.size() > 0) {
            return Long.valueOf(String.valueOf(((Map)countList.get(0)).get("sum")));
        }
        return 0L;
    }

    public Long getCountByRegistActived(String startDate, String endDate) {
        String sql = "select count(*) as sum from user_info where\n  (to_char(email_actived_time, 'yyyy-mm-dd HH24:MI:SS') <= to_char(date_created+1/24/12,'yyyy-mm-dd HH24:MI:SS')\n  or\n  phone_actived_time=date_created)\n\n  and date_created between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1";
        List mapList = this.jdbcTemplate.queryForList(sql, new Object[]{startDate, endDate});
        if (mapList.size() > 0) {
            return Long.valueOf(String.valueOf(((Map)mapList.get(0)).get("sum")));
        }
        return 0L;
    }

    public Long getCountByUpdateEmailOrPhone(String startDate, String endDate) {
        String sql = "select count(*) as sum from user_info where email_actived='1' AND to_char(email_actived_time, 'yyyy-mm-dd HH24:MI:SS') > to_char(date_created+1/24/12,'yyyy-mm-dd HH24:MI:SS')\n AND email_actived_time between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 or phone_actived = '1' and phone_actived_time!=user_info.date_created\n AND phone_actived_time between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1";
        List mapList = this.jdbcTemplate.queryForList(sql, new Object[]{startDate, endDate, startDate, endDate});
        if (mapList.size() > 0) {
            return Long.valueOf(String.valueOf(((Map)mapList.get(0)).get("sum")));
        }
        return 0L;
    }

    public Long getRequestCountFromAuditByTypeAndOwnerSystem(String startDate, String endDate, String countType, String ownerSystem) {
        String sql;
        if (ALL_TYPE.equals(countType)) {
            sql = "select count(*) as sum from audit_log a,user_info u where a.aud_action like   'UPDATE_PASSWORD%' and a.USER_ID=u.user_id and u.owner_system = ?  and a.aud_date between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 ";
        } else if (SUCCESS_TYPE.equals(countType)) {
            sql = "select count(*) as sum from audit_log a,user_info u where a.aud_action =  'UPDATE_PASSWORD_SUCCESS' and a.USER_ID=u.user_id and u.owner_system = ?  and a.aud_date between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 ";
        } else if (FAILED_TYPE.equals(countType)) {
            sql = "select count(*) as sum from audit_log a,user_info u where a.aud_action =  'UPDATE_PASSWORD_FAILED' and a.USER_ID=u.user_id and u.owner_system = ?  and a.aud_date between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 ";
        } else {
            return 0L;
        }
        List mapList = this.jdbcTemplate.queryForList(sql, new Object[]{ownerSystem, startDate, endDate});
        if (mapList.size() > 0) {
            return Long.valueOf(String.valueOf(((Map)mapList.get(0)).get("sum")));
        }
        return 0L;
    }

    public Long getRequestCountFromApiByTypeAndOwnerSystem(String startDate, String endDate, String countType, String ownerSystem) {
        String sql;
        if (ALL_TYPE.equals(countType)) {
            sql = "select count(*) as sum from api_log a,user_info u where a.request_url like '%modifyPassword' and a.user_id=u.user_id and u.owner_system = ?  and a.date_created between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 ";
        } else if (SUCCESS_TYPE.equals(countType)) {
            sql = "select count(*) as sum from api_log a,user_info u where a.request_url like '%modifyPassword' and a.status = '0'  and a.user_id=u.user_id and u.owner_system = ?  and a.date_created between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 ";
        } else if (FAILED_TYPE.equals(countType)) {
            sql = "select count(*) as sum from api_log a,user_info u where a.request_url like '%modifyPassword' and a.status = '1'  and a.user_id=u.user_id and u.owner_system = ?  and a.date_created between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 ";
        } else {
            return 0L;
        }
        List mapList = this.jdbcTemplate.queryForList(sql, new Object[]{ownerSystem, startDate, endDate});
        if (mapList.size() > 0) {
            return Long.valueOf(String.valueOf(((Map)mapList.get(0)).get("sum")));
        }
        return 0L;
    }

    public Long getCountByLoginNameUsed(String startDate, String endDate, String userType) {
        String sql = "select count(*) as sum from audit_log where user_type = ? and user_id is not null and aud_action='AUTHENTICATION_SUCCESS' and aud_date between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1";
        List mapList = this.jdbcTemplate.queryForList(sql, new Object[]{userType, startDate, endDate});
        if (mapList.size() > 0) {
            return Long.valueOf(String.valueOf(((Map)mapList.get(0)).get("sum")));
        }
        return 0L;
    }

    public List<Map<String, Object>> getRegisteredCountByOwnerSystem(String startDate, String endDate, String ownerSystem) {
        List mapList = null;
        if (StringUtils.isEmpty((Object)ownerSystem)) {
            String sql = "select count(*) as sum,to_char(date_created, 'yyyy-MM') as yearMonth from user_info where date_created between to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1  GROUP BY to_char(date_created, 'yyyy-MM') ORDER BY to_char(date_created, 'yyyy-MM') ASC";
            mapList = this.jdbcTemplate.queryForList(sql, new Object[]{startDate, endDate});
        } else {
            String sql = "select count(*) as sum,to_char(date_created, 'yyyy-MM') as yearMonth from user_info where owner_system = ? and date_created BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1  GROUP by to_char(date_created, 'yyyy-MM') ORDER BY to_char(date_created, 'yyyy-MM') asc";
            mapList = this.jdbcTemplate.queryForList(sql, new Object[]{ownerSystem, startDate, endDate});
        }
        return mapList;
    }

    public List<Map<String, Object>> getLoginNumCurrentday(String startDate, String endDate) {
        String sql = "select count(*) as sum,to_char(aud_date, 'yyyy-MM-dd') as audDate from audit_log where user_type in ('userName', 'phone', 'email')  and user_id is not null and aud_action='AUTHENTICATION_SUCCESS' and AUD_DATE BETWEEN to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 GROUP BY to_char(aud_date, 'yyyy-MM-dd') ORDER BY to_char(aud_date, 'yyyy-MM-dd') DESC";
        return this.jdbcTemplate.queryForList(sql, new Object[]{startDate, endDate});
    }

    public List<Map<String, Object>> getDistributionByOwnerSystemAndHour(String ownerSystem, String startDate, String endDate) {
        String sql = "select count(*) as sum,to_char(aud_date, 'HH') as sudTime from audit_log a, user_info u where a.USER_ID = u.user_id and u.owner_system=? \n and aud_action='AUTHENTICATION_SUCCESS' and a.AUD_DATE BETWEEN to_date(?, 'yyyy-MM-dd') AND to_date(?, 'yyyy-MM-dd')+1 \nGROUP BY to_char(aud_date, 'HH')";
        return this.jdbcTemplate.queryForList(sql, new Object[]{ownerSystem, startDate, endDate});
    }

    public Long getMaxLoginNumerCurrentday(String startDate, String endDate) {
        String sql = " select  max(count(aud_date))  from audit_log where user_type in ('userName', 'phone', 'email')  and user_id is not null and aud_action='AUTHENTICATION_SUCCESS' and AUD_DATE BETWEEN  to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1 group by to_char(aud_date,'yyyy/mm/dd/hh24')";
        return (Long)this.jdbcTemplate.queryForObject(sql, new Object[]{startDate, endDate}, Long.class);
    }

    public List<Map<String, Object>> getMaxLoginNumForPeriodTime(String startDate, String endDate) {
        String sql = "select\n  c.day\n  ,max(c.daySum) as maxNum\nfrom (\n       select\n         b.dayHour\n         ,b.day,b.hour\n         ,count(b.dayHour) over(partition by b.dayHour order by b.day desc) daySum\n       from (\n              select\n                to_char(a.aud_date, 'yyyy/MM/dd') as day,to_char(a.aud_date, 'yyyy/MM/dd HH') as dayHour,to_char(a.aud_date, 'HH') as hour\n              from audit_log a\n              WHERE\n                user_type in ('userName', 'phone', 'email')\n                and user_id is not null and aud_action='AUTHENTICATION_SUCCESS'\n                and AUD_DATE BETWEEN  to_date(?, 'yyyy/mm/dd') and to_date(?, 'yyyy/mm/dd')+1\n            ) b\n     ) c\ngroup by c.day\norder by c.day";
        return this.jdbcTemplate.queryForList(sql, new Object[]{startDate, endDate});
    }
}

