/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.filter;

import com.picc.gz.admin.filter.InjectionAttackWrapperDataStr;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.utils.Lang;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class IdnumVerifyFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(IdnumVerifyFilter.class);
    private static AntPathMatcher matcher = new AntPathMatcher();
    private Boolean enable;
    private List<String> urls;
    private List<String> excludes;
    private String idverifyUrl;
    private String defaultSuccessUrl;
    private CusRecommendService cusRecommendService;

    public IdnumVerifyFilter(Boolean enable, List<String> urls, String idverifyUrl, String defaultSuccessUrl, CusRecommendService cusRecommendService) {
        this.enable = enable;
        this.urls = urls;
        this.idverifyUrl = idverifyUrl;
        this.defaultSuccessUrl = defaultSuccessUrl;
        this.cusRecommendService = cusRecommendService;
    }

    public IdnumVerifyFilter(Boolean enable, List<String> urls, List<String> excludes, String idverifyUrl, String defaultSuccessUrl, CusRecommendService cusRecommendService) {
        this.enable = enable;
        this.urls = urls;
        this.excludes = excludes;
        this.idverifyUrl = idverifyUrl;
        this.defaultSuccessUrl = defaultSuccessUrl;
        this.cusRecommendService = cusRecommendService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String recommendId = request.getParameter("recommendId");
        if (!Lang.isEmpty((Object)recommendId)) {
            recommendId = recommendId.replace("\n", "");
            recommendId = recommendId.replace("\r", "");
        }
        String requestUrl = request.getRequestURI();
        StringBuffer rediectUrl = request.getRequestURL();
        requestUrl = InjectionAttackWrapperDataStr.getDataStr((String)requestUrl);
        if (request.getQueryString() != null) {
            rediectUrl.append('?');
            rediectUrl.append(request.getQueryString());
        }
        HttpSession session = request.getSession();
        Boolean flag = (Boolean)session.getAttribute(String.format("%s%s", "VALID_FLAG_ID_", recommendId));
        String dbIdNum = this.cusRecommendService.getIdNum(recommendId);
        if (StringUtils.isEmpty((Object)dbIdNum)) {
            flag = true;
        }
        if ((flag == null || !flag.booleanValue()) && this.enable.booleanValue()) {
            Boolean needCheck = false;
            if (this.urls != null) {
                for (String u : this.urls) {
                    if (!matcher.match(u, requestUrl)) continue;
                    needCheck = true;
                    break;
                }
            }
            if (this.excludes != null) {
                for (String ex : this.excludes) {
                    if (!matcher.match(ex, requestUrl)) continue;
                    needCheck = false;
                    break;
                }
            }
            if (needCheck.booleanValue()) {
                String reqWith = request.getHeader("X-Requested-With");
                String callBackUrl = "";
                String defaultSucUrl = String.format("%s?recommendId=%s", this.defaultSuccessUrl, recommendId);
                if (reqWith == null && request.getMethod() != null) {
                    if (matcher.match(this.idverifyUrl, requestUrl)) {
                        callBackUrl = defaultSucUrl;
                        callBackUrl = InjectionAttackWrapperDataStr.getDataStr((String)callBackUrl);
                        session.setAttribute("VALIDSUC_CALLBACK", (Object)callBackUrl);
                    } else {
                        callBackUrl = rediectUrl.toString();
                        callBackUrl = InjectionAttackWrapperDataStr.getDataStr((String)callBackUrl);
                    }
                } else {
                    callBackUrl = defaultSucUrl;
                }
                if (!StringUtils.isEmpty((Object)recommendId)) {
                    session.setAttribute("VALIDSUC_CALLBACK", (Object)callBackUrl);
                    response.sendRedirect(String.format("%s?recommendId=%s", this.idverifyUrl, recommendId));
                } else {
                    response.sendError(403);
                    return;
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static String getBodyString(BufferedReader br) {
        String str = "";
        try {
            String inputLine;
            while ((inputLine = br.readLine()) != null) {
                str = str + inputLine;
            }
            br.close();
        }
        catch (IOException e) {
            log.error("\u89e3\u6790POST\u8bf7\u6c42\u5931\u8d25\uff01", (Throwable)e);
        }
        return str;
    }
}

