/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.picc.gz.admin.service.CusRecommendSalerService;
import com.picc.gz.admin.service.SalerSelector;
import com.picc.gz.model.model.CusRecommendSaler;
import com.picc.gz.model.model.SalerCommission;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommissionFaireSalerSelector
implements SalerSelector {
    @Autowired
    CusRecommendSalerService cusRecommendSalerService;

    public CusRecommendSaler select(List<CusRecommendSaler> sallers, BigDecimal premium) {
        if (sallers != null && sallers.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("'").append(String.join((CharSequence)"','", sallers.stream().map(CusRecommendSaler::getSellerno).collect(Collectors.toList()))).append("'");
            List salerCommissions = this.cusRecommendSalerService.querySalerCommissionsCurMonth(sb.toString());
            List<Object> validSallers = sallers.stream().filter(it -> {
                Optional<SalerCommission> r = salerCommissions.stream().filter(sc -> sc.getSellerno().equals(it.getSellerno())).findFirst();
                return !r.isPresent() || r.get().getCommission().compareTo(premium) < 0;
            }).collect(Collectors.toList());
            if (validSallers.size() <= 0) {
                validSallers = sallers;
            }
            validSallers.sort((o1, o2) -> {
                Optional<SalerCommission> commissionO1 = salerCommissions.stream().filter(salerCommission -> salerCommission.getSellerno().equals(o1.getSellerno())).findFirst();
                Optional<SalerCommission> commissionO2 = salerCommissions.stream().filter(salerCommission -> salerCommission.getSellerno().equals(o2.getSellerno())).findFirst();
                if (commissionO1.isPresent() && commissionO2.isPresent()) {
                    return commissionO1.get().getCommission().compareTo(commissionO2.get().getCommission());
                }
                return !commissionO2.isPresent() ? 1 : -1;
            });
            if (validSallers.size() > 0) {
                return (CusRecommendSaler)validSallers.get(0);
            }
        }
        return null;
    }
}

