/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.picc.gz.admin.dao.AddressMapper;
import com.picc.gz.admin.dao.CusRecommendPersonnelMapper;
import com.picc.gz.admin.service.AddressService;
import com.picc.gz.admin.service.CusRecommendExtAttrService;
import com.picc.gz.admin.service.CusRecommendPersonnelService;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.model.model.Address;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.CusRecommendExtAttr;
import com.picc.gz.model.model.CusRecommendPersonnel;
import com.picc.gz.utils.AddressResolutionUtils;
import com.picc.gz.utils.DateUtils;
import com.picc.gz.utils.Lang;
import com.picc.gz.utils.data.Beans;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class CusRecommendPersonnelServiceImpl
implements CusRecommendPersonnelService {
    @Autowired
    private CusRecommendPersonnelMapper recommendPersonnelMapper;
    @Autowired
    private AddressMapper addressMapper;
    @Autowired
    private AddressService addressService;
    @Autowired
    public CusRecommendService recommendService;
    @Autowired
    private CusRecommendExtAttrService extAttrService;
    Logger logger = LoggerFactory.getLogger(CusRecommendPersonnelServiceImpl.class);

    public CusRecommendPersonnel findByRecommendIdAndType(String recommendId, String type) {
        CusRecommendPersonnel recommendPersonnel = null;
        if (Lang.isEmpty((Object)recommendId)) {
            return recommendPersonnel;
        }
        Example selectExamp = new Example(CusRecommendPersonnel.class);
        selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("type", (Object)type).andEqualTo("recommendId", (Object)recommendId);
        if (type == "2") {
            List cusRecommendPersonnelList = new ArrayList();
            cusRecommendPersonnelList = this.recommendPersonnelMapper.selectByExample((Object)selectExamp);
            if (cusRecommendPersonnelList.size() != 0) {
                recommendPersonnel = (CusRecommendPersonnel)cusRecommendPersonnelList.get(0);
            }
        } else {
            recommendPersonnel = (CusRecommendPersonnel)this.recommendPersonnelMapper.selectOneByExample((Object)selectExamp);
        }
        if (!Lang.isEmpty((Object)recommendPersonnel) && Lang.isEmpty((Object)recommendPersonnel.getBirthDay())) {
            recommendPersonnel.setBirthDay(new Date());
        }
        if (!Lang.isEmpty((Object)recommendPersonnel) && Lang.isEmpty((Object)recommendPersonnel.getAddress())) {
            recommendPersonnel.setAddress("-");
        }
        return recommendPersonnel;
    }

    public CusRecommendPersonnel findInsuredInfoByRecommendId(String recommendId) {
        Map address;
        CusRecommendPersonnel cusRecommendPersonnel = null;
        cusRecommendPersonnel = this.findByRecommendIdAndType(recommendId, "2");
        if (Lang.isEmpty((Object)cusRecommendPersonnel)) {
            cusRecommendPersonnel = new CusRecommendPersonnel();
            cusRecommendPersonnel.setType("2");
            cusRecommendPersonnel.setRecommendId(recommendId);
        }
        if (!Lang.isEmpty((Object)cusRecommendPersonnel) && Lang.isEmpty((Object)cusRecommendPersonnel.getInsuredIdentity())) {
            cusRecommendPersonnel.setInsuredIdentity("0");
        }
        if (!Lang.isEmpty((Object)cusRecommendPersonnel) && Lang.isEmpty((Object)cusRecommendPersonnel.getApplicantIsSocialSe())) {
            cusRecommendPersonnel.setApplicantIsSocialSe("0");
        }
        if (!(Lang.isEmpty((Object)cusRecommendPersonnel) || Lang.isEmpty((Object)cusRecommendPersonnel.getAddress()) || Lang.isEmpty((Object)(address = AddressResolutionUtils.addressResolution((String)cusRecommendPersonnel.getAddress()))))) {
            String province = address.getOrDefault("province", "");
            String city = address.getOrDefault("city", "");
            String county = address.getOrDefault("county", "");
            String inCityInfo = "";
            if (!Lang.isEmpty((Object)province)) {
                List provinceAddress = this.addressMapper.findByName(province);
                if (!Lang.isEmpty((Object)provinceAddress) && provinceAddress.size() > 0) {
                    cusRecommendPersonnel.setProvince(((Address)provinceAddress.get(0)).getId());
                }
                inCityInfo = inCityInfo + province + " ";
            }
            if (!Lang.isEmpty((Object)city)) {
                List cityAddress = !Lang.isEmpty((Object)cusRecommendPersonnel.getProvince()) ? this.addressMapper.findByNameAndParent(city, cusRecommendPersonnel.getProvince()) : this.addressMapper.findByName(city);
                if (!Lang.isEmpty((Object)cityAddress) && cityAddress.size() > 0) {
                    cusRecommendPersonnel.setCity(((Address)cityAddress.get(0)).getId());
                }
                inCityInfo = inCityInfo + city + " ";
            }
            if (!Lang.isEmpty((Object)county)) {
                List countyAddress = !Lang.isEmpty((Object)cusRecommendPersonnel.getCity()) ? this.addressMapper.findByNameAndParent(county, cusRecommendPersonnel.getCity()) : this.addressMapper.findByName(county);
                if (!Lang.isEmpty((Object)countyAddress) && countyAddress.size() > 0) {
                    cusRecommendPersonnel.setArea(((Address)countyAddress.get(0)).getId());
                }
                inCityInfo = inCityInfo + county;
            }
            cusRecommendPersonnel.setInCityInfo(inCityInfo);
        }
        return cusRecommendPersonnel;
    }

    public CusRecommendPersonnel findApplicantInfoByRecommendId(String recommendId) {
        CusRecommendPersonnel cusRecommendPersonnel = null;
        cusRecommendPersonnel = this.findByRecommendIdAndType(recommendId, "1");
        if (Lang.isEmpty((Object)cusRecommendPersonnel)) {
            cusRecommendPersonnel = new CusRecommendPersonnel();
            cusRecommendPersonnel.setType("1");
            cusRecommendPersonnel.setRecommendId(recommendId);
        }
        return cusRecommendPersonnel;
    }

    public CusRecommendPersonnel findBeneficiaryByRecommendId(String recommendId) {
        CusRecommendPersonnel cusRecommendPersonnel = null;
        cusRecommendPersonnel = this.findByRecommendIdAndType(recommendId, "3");
        if (Lang.isEmpty((Object)cusRecommendPersonnel)) {
            cusRecommendPersonnel = new CusRecommendPersonnel();
            cusRecommendPersonnel.setType("3");
            cusRecommendPersonnel.setRecommendId(recommendId);
        }
        return cusRecommendPersonnel;
    }

    public void removeBeneficiaryByRecommendId(String recommendId) {
        CusRecommendPersonnel cusRecommendPersonnel = this.findBeneficiaryByRecommendId(recommendId);
        if (!Lang.isEmpty((Object)cusRecommendPersonnel)) {
            cusRecommendPersonnel.setIsDelete(Integer.valueOf("1"));
            this.recommendPersonnelMapper.updateByPrimaryKeySelective((Object)cusRecommendPersonnel);
        }
    }

    public void saveCusRecommendPersonnel(CusRecommendPersonnel cusRecommendPersonnel) {
        if (cusRecommendPersonnel.getId() != null) {
            this.recommendPersonnelMapper.updateByPrimaryKeySelective((Object)cusRecommendPersonnel);
        } else {
            this.recommendPersonnelMapper.insertSelective((Object)cusRecommendPersonnel);
        }
    }

    public void insertSelective(CusRecommendPersonnel cusRecommendPersonnel) {
        this.recommendPersonnelMapper.insertSelective((Object)cusRecommendPersonnel);
    }

    public String getPostCode(CusRecommendPersonnel personnel) {
        Address a;
        String postCode = null;
        if (StringUtils.isEmpty(postCode) && !StringUtils.isEmpty((CharSequence)personnel.getArea())) {
            a = this.addressService.findById(personnel.getArea());
            String string = postCode = a == null ? null : a.getZipCode();
        }
        if (StringUtils.isEmpty(postCode) && !StringUtils.isEmpty((CharSequence)personnel.getCity())) {
            a = this.addressService.findById(personnel.getCity());
            String string = postCode = a == null ? null : a.getZipCode();
        }
        if (StringUtils.isEmpty(postCode) && !StringUtils.isEmpty((CharSequence)personnel.getProvince())) {
            a = this.addressService.findById(personnel.getProvince());
            postCode = a == null ? null : a.getZipCode();
        }
        return postCode;
    }

    public List<CusRecommendPersonnel> findPersonneByRecommendId(String recommendId) {
        List cusRecommendPersonnelList = this.findPersonneByRecommendIdAndType(recommendId, "2");
        return cusRecommendPersonnelList;
    }

    public void saverecommendPersonnel(JSONObject dataObject, int a, String recommendId) {
        CusRecommendPersonnel cusRecommendPersonnel = new CusRecommendPersonnel();
        for (int i = 1; i <= a; ++i) {
            String name0 = dataObject.getString("name" + i);
            String idNumber0 = dataObject.getString("idNumber" + i);
            String insuredIdentity0 = dataObject.getString("insuredIdentity" + i);
            String idType0 = dataObject.getString("idType" + i);
            String applicantlsSocialSe0 = dataObject.getString("applicantIsSocialSe" + i);
            String age0 = dataObject.getString("age" + i);
            Integer gender0 = Integer.valueOf(dataObject.getString("gender" + i));
            String birthDay0 = dataObject.getString("birthDay" + i);
            String mobile0 = dataObject.getString("mobile" + i);
            cusRecommendPersonnel.setName(name0);
            cusRecommendPersonnel.setType("2");
            cusRecommendPersonnel.setIdNumber(idNumber0);
            cusRecommendPersonnel.setInsuredIdentity(insuredIdentity0);
            cusRecommendPersonnel.setIdType(idType0);
            cusRecommendPersonnel.setApplicantIsSocialSe(applicantlsSocialSe0);
            cusRecommendPersonnel.setRecommendId(recommendId);
            cusRecommendPersonnel.setGender(gender0);
            cusRecommendPersonnel.setBirthDay(DateUtils.strToDate((String)birthDay0));
            cusRecommendPersonnel.setMobile(mobile0);
            cusRecommendPersonnel.setLastUpdated(new Date());
            this.saveCusRecommendPersonnel(cusRecommendPersonnel);
        }
    }

    public void saveRecommendPersonnel(CusRecommendPersonnel insuredInfo, JSONObject dataObject, String recommendId) {
        String name = dataObject.getString("name");
        String idType = dataObject.getString("idType");
        String idNumber = dataObject.getString("idNumber");
        String mobile = dataObject.getString("mobile");
        String email = dataObject.getString("email");
        String gender = dataObject.getString("gender");
        String birthDay = dataObject.getString("birthDay");
        String inCityInfo = dataObject.getString("inCityInfo");
        String province = dataObject.getString("province");
        String city = dataObject.getString("city");
        String area = dataObject.getString("area");
        String address = dataObject.getString("address");
        String applicantName = dataObject.getString("applicantName");
        String applicantIdType = dataObject.getString("applicantIdType");
        String applicantIdNumber = dataObject.getString("applicantIdNumber");
        String applicantGender = dataObject.getString("applicantGender");
        String applicantInfoBirthDay = dataObject.getString("applicantInfoBirthDay");
        String insuredIdentity = dataObject.getString("insuredIdentity");
        String applicantIsSocialSe = dataObject.getString("applicantIsSocialSe");
        String occupationCode = dataObject.getString("occupationCode");
        String businessDetail = dataObject.getString("businessDetail");
        String houseProperty = dataObject.getString("houseProperty");
        String incomeSource = dataObject.getString("incomeSource");
        if ("0".equals(insuredIdentity)) {
            insuredInfo.setName(applicantName);
            insuredInfo.setIdType(applicantIdType);
            insuredInfo.setIdNumber(applicantIdNumber);
            if (!Lang.isEmpty((Object)applicantGender)) {
                insuredInfo.setGender(Integer.valueOf(applicantGender));
            }
            if (!Lang.isEmpty((Object)applicantInfoBirthDay)) {
                insuredInfo.setBirthDay(DateUtils.strToDate((String)applicantInfoBirthDay));
            }
            insuredInfo.setInCityInfo(inCityInfo);
            insuredInfo.setProvince(province);
            insuredInfo.setCity(city);
            insuredInfo.setArea(area);
            insuredInfo.setAddress(address);
            insuredInfo.setInsuredIdentity(insuredIdentity);
            insuredInfo.setApplicantIsSocialSe(applicantIsSocialSe);
            insuredInfo.setMobile(mobile);
            insuredInfo.setEmail(email);
        } else {
            insuredInfo.setName(name);
            insuredInfo.setIdType(idType);
            insuredInfo.setIdNumber(idNumber);
            insuredInfo.setMobile(mobile);
            insuredInfo.setEmail(email);
            if (!Lang.isEmpty((Object)gender)) {
                insuredInfo.setGender(Integer.valueOf(gender));
            }
            if (!Lang.isEmpty((Object)birthDay)) {
                insuredInfo.setBirthDay(DateUtils.strToDate((String)birthDay));
            }
            insuredInfo.setInCityInfo(inCityInfo);
            insuredInfo.setProvince(province);
            insuredInfo.setCity(city);
            insuredInfo.setArea(area);
            insuredInfo.setAddress(address);
            insuredInfo.setInsuredIdentity(insuredIdentity);
            insuredInfo.setApplicantIsSocialSe(applicantIsSocialSe);
        }
        insuredInfo.setLastUpdated(new Date());
        insuredInfo.setRecommendId(recommendId);
        CusRecommend cusRecommend = this.recommendService.findById(recommendId);
        if (cusRecommend.getRealRiskCode().equals("ECD")) {
            CusRecommendExtAttr cusRecommendExtAttrFour;
            CusRecommendExtAttr cusRecommendExtAttrThree;
            ArrayList<CusRecommendExtAttr> lisCusRecommendExtAttrList = new ArrayList<CusRecommendExtAttr>();
            CusRecommendExtAttr cusRecommendExtAttr = new CusRecommendExtAttr();
            cusRecommendExtAttr.setRecommendId(recommendId);
            cusRecommendExtAttr.setAttrName("occupationCode");
            cusRecommendExtAttr.setAttrValue(occupationCode);
            lisCusRecommendExtAttrList.add(cusRecommendExtAttr);
            CusRecommendExtAttr cusRecommendExtAttrTwo = new CusRecommendExtAttr();
            cusRecommendExtAttrTwo.setRecommendId(recommendId);
            cusRecommendExtAttrTwo.setAttrName("businessDetail");
            cusRecommendExtAttrTwo.setAttrValue(businessDetail);
            lisCusRecommendExtAttrList.add(cusRecommendExtAttrTwo);
            if (houseProperty == null || "".equals(houseProperty)) {
                cusRecommendExtAttrThree = new CusRecommendExtAttr();
                cusRecommendExtAttrThree.setRecommendId(recommendId);
                cusRecommendExtAttrThree.setAttrName("houseProperty");
                cusRecommendExtAttrThree.setAttrValue("-");
                lisCusRecommendExtAttrList.add(cusRecommendExtAttrThree);
            } else {
                cusRecommendExtAttrThree = new CusRecommendExtAttr();
                cusRecommendExtAttrThree.setRecommendId(recommendId);
                cusRecommendExtAttrThree.setAttrName("houseProperty");
                cusRecommendExtAttrThree.setAttrValue(houseProperty);
                lisCusRecommendExtAttrList.add(cusRecommendExtAttrThree);
            }
            if (incomeSource == null || "".equals(incomeSource)) {
                cusRecommendExtAttrFour = new CusRecommendExtAttr();
                cusRecommendExtAttrFour.setRecommendId(recommendId);
                cusRecommendExtAttrFour.setAttrName("incomeSource");
                cusRecommendExtAttrFour.setAttrValue("-");
                lisCusRecommendExtAttrList.add(cusRecommendExtAttrFour);
            } else {
                cusRecommendExtAttrFour = new CusRecommendExtAttr();
                cusRecommendExtAttrFour.setRecommendId(recommendId);
                cusRecommendExtAttrFour.setAttrName("incomeSource");
                cusRecommendExtAttrFour.setAttrValue(incomeSource);
                lisCusRecommendExtAttrList.add(cusRecommendExtAttrFour);
            }
            this.extAttrService.saveAll(lisCusRecommendExtAttrList);
        }
        this.saveCusRecommendPersonnel(insuredInfo);
    }

    public void saveTwoCusRecommendPersonnel(JSONObject dataObject, String recommendId) {
        String name6 = dataObject.getString("name6");
        String idType6 = dataObject.getString("idType6");
        String idNumber6 = dataObject.getString("idNumber6");
        String mobile6 = dataObject.getString("mobile6");
        String gender6 = dataObject.getString("gender6");
        String birthDay6 = dataObject.getString("birthDay6");
        String insuredIdentity6 = dataObject.getString("insuredIdentity6");
        String applicantIsSocialSe6 = dataObject.getString("applicantIsSocialSe6");
        CusRecommendPersonnel cusRecommendPersonnel = new CusRecommendPersonnel();
        cusRecommendPersonnel.setName(name6);
        cusRecommendPersonnel.setType("2");
        cusRecommendPersonnel.setIdNumber(idNumber6);
        cusRecommendPersonnel.setInsuredIdentity(insuredIdentity6);
        cusRecommendPersonnel.setIdType(idType6);
        cusRecommendPersonnel.setApplicantIsSocialSe(applicantIsSocialSe6);
        cusRecommendPersonnel.setRecommendId(recommendId);
        cusRecommendPersonnel.setGender(Integer.valueOf(gender6));
        cusRecommendPersonnel.setBirthDay(DateUtils.strToDate((String)birthDay6));
        cusRecommendPersonnel.setMobile(mobile6);
        cusRecommendPersonnel.setLastUpdated(new Date());
        this.saveCusRecommendPersonnel(cusRecommendPersonnel);
    }

    public void saveCusRecommendBeneficiary(JSONObject dataObject, String recommendId, CusRecommend cusRecommendNew) {
        String isBeneficiary = dataObject.getString("isBeneficiary");
        String beneficiaryName = dataObject.getString("beneficiaryName");
        String beneficiaryIdNumber = dataObject.getString("beneficiaryIdNumber");
        String beneficiaryGender = dataObject.getString("beneficiaryGender");
        String beneficiaryBirthDay = dataObject.getString("beneficiaryBirthDay");
        if ("1".equals(isBeneficiary)) {
            CusRecommendPersonnel beneficiary;
            CusRecommendPersonnel beneficiary_old = this.findBeneficiaryByRecommendId(recommendId);
            if (beneficiary_old == null) {
                beneficiary = new CusRecommendPersonnel();
            } else {
                beneficiary = (CusRecommendPersonnel)Beans.map((Object)beneficiary_old, CusRecommendPersonnel.class);
                beneficiary.setId(null);
            }
            beneficiary.setLastUpdated(new Date());
            beneficiary.setName(beneficiaryName);
            beneficiary.setIdType("01");
            beneficiary.setIdNumber(beneficiaryIdNumber);
            if (!Lang.isEmpty((Object)beneficiaryGender)) {
                beneficiary.setGender(Integer.valueOf(beneficiaryGender));
            }
            if (!Lang.isEmpty((Object)beneficiaryBirthDay)) {
                beneficiary.setBirthDay(DateUtils.strToDate((String)beneficiaryBirthDay));
            }
            beneficiary.setRecommendId(cusRecommendNew.getId());
            this.saveCusRecommendPersonnel(beneficiary);
        }
    }

    public List<CusRecommendPersonnel> findPersonnel(String recommendId) {
        List<CusRecommendPersonnel> recommendPersonnelList = null;
        if (Lang.isEmpty((Object)recommendId)) {
            return recommendPersonnelList;
        }
        Example selectExamp = new Example(CusRecommendPersonnel.class);
        selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("recommendId", (Object)recommendId);
        ArrayList<CusRecommendPersonnel> cusRecommendPersonnelList = new ArrayList();
        cusRecommendPersonnelList = this.recommendPersonnelMapper.selectByExample((Object)selectExamp);
        return cusRecommendPersonnelList;
    }

    public List<CusRecommendPersonnel> findPersonneByRecommendIdAndType(String recommendId, String type) {
        List<CusRecommendPersonnel> recommendPersonnelList = null;
        if (Lang.isEmpty((Object)recommendId)) {
            return recommendPersonnelList;
        }
        Example selectExamp = new Example(CusRecommendPersonnel.class);
        selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("type", (Object)type).andEqualTo("recommendId", (Object)recommendId);
        ArrayList<CusRecommendPersonnel> cusRecommendPersonnelList = new ArrayList();
        cusRecommendPersonnelList = this.recommendPersonnelMapper.selectByExample((Object)selectExamp);
        return cusRecommendPersonnelList;
    }
}

