/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.chrhc.mybatis.autodate.util.StringUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.picc.gz.admin.dao.CusRecommendCustomerMapper;
import com.picc.gz.admin.dao.CusRecommendMapper;
import com.picc.gz.admin.datasource.DatabaseContextHolder;
import com.picc.gz.admin.datasource.DatabaseType;
import com.picc.gz.admin.factory.ShortenUrlSupplierFactory;
import com.picc.gz.admin.filter.InjectionAttackWrapperDataStr;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.service.InsuranceProductItemService;
import com.picc.gz.admin.service.SalesmanService;
import com.picc.gz.admin.vo.QuerySignSearchRequest;
import com.picc.gz.admin.vo.insure.SignatureRequest;
import com.picc.gz.admin.vo.policy.PolicyQuery;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.CusRecommendPolicy;
import com.picc.gz.model.model.CusRecommendSign;
import com.picc.gz.model.model.InsuranceProductItem;
import com.picc.gz.model.util.PageRequest;
import com.picc.gz.model.util.PagerHelperUtils;
import com.picc.gz.utils.DateUtils;
import com.picc.gz.utils.Lang;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class CusRecommendServiceImpl
implements CusRecommendService {
    private static final Logger log = LoggerFactory.getLogger(CusRecommendServiceImpl.class);
    @Value(value="${yeePay.outerDownloadUrl}")
    private String outerDownloadUrl;
    @Value(value="${yeePay.innerDownloadUrl}")
    private String innerDownloadUrl;
    @Autowired
    private CusRecommendMapper recommendMapper;
    @Autowired
    private CusRecommendCustomerMapper cusRecommendCustomerMapper;
    @Autowired
    private InsuranceProductItemService insuranceProductItemService;
    @Autowired
    private ShortenUrlSupplierFactory shortenUrlSupplierFactory;
    @Autowired
    private SalesmanService salesmanService;

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public CusRecommend findById(String id) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        if (id == null || "".equals(id.trim())) {
            return null;
        }
        Example selectExamp = new Example(CusRecommend.class);
        selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("id", (Object)id);
        CusRecommend cusRecommend = (CusRecommend)this.recommendMapper.selectOneByExample((Object)selectExamp);
        if (!Lang.isEmpty((Object)cusRecommend) && Lang.isEmpty((Object)cusRecommend.getInsuranceStartDate())) {
            cusRecommend.setInsuranceStartDate(DateUtils.strToDate((String)DateUtils.getTimeBeforeORAfter((int)0, (int)0, (int)1)));
        }
        if (!Lang.isEmpty((Object)cusRecommend) && Lang.isEmpty((Object)cusRecommend.getInsuranceEndDate())) {
            cusRecommend.setInsuranceEndDate(DateUtils.strToDate((String)DateUtils.getTimeBeforeORAfter((int)1, (int)0, (int)-1)));
        }
        return cusRecommend;
    }

    public void saveCusRecommend(CusRecommend cusRecommend) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        if (!Lang.isEmpty((Object)cusRecommend.getId())) {
            this.recommendMapper.updateByPrimaryKeySelective((Object)cusRecommend);
        } else {
            this.recommendMapper.insertSelective((Object)cusRecommend);
        }
    }

    public void updateStatus(String recommendId, String status) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        if ("01".equals(status) || "02".equals(status) || "03".equals(status)) {
            boolean beforeOperated;
            String oldStatus = this.recommendMapper.getStatus(recommendId);
            if ("01".equals(status) && !StringUtils.isEmpty((Object)oldStatus) && !"0".equals(oldStatus)) {
                return;
            }
            if ("02".equals(status) && !"01".equals(oldStatus)) {
                return;
            }
            boolean bl = beforeOperated = "01".equals(oldStatus) || "02".equals(oldStatus);
            if ("03".equals(status) && !beforeOperated) {
                return;
            }
        }
        this.recommendMapper.updateStatus(recommendId, status);
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public Boolean idverify(String recommendId, String idNum) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        if (!StringUtils.isEmpty((Object)recommendId) && !StringUtils.isEmpty((Object)idNum)) {
            String dbIdNum = this.recommendMapper.findApplicatorIdnumByRecommendId(recommendId);
            String string = dbIdNum = StringUtils.isEmpty((Object)dbIdNum) ? this.recommendMapper.findCustomerIdnumByRecommendId(recommendId) : dbIdNum;
            if (!StringUtils.isEmpty((Object)dbIdNum)) {
                if (Lang.isIdNumber((String)dbIdNum)) {
                    dbIdNum = dbIdNum.toUpperCase();
                }
                return dbIdNum.endsWith(idNum.toUpperCase());
            }
        }
        return false;
    }

    public String getIdNum(String recommendId) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        if (!StringUtils.isEmpty((Object)recommendId)) {
            return this.recommendMapper.findApplicatorIdnumByRecommendId(recommendId);
        }
        return "";
    }

    public Boolean isIdEmpty(String recommendId) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        if (!StringUtils.isEmpty((Object)recommendId)) {
            String dbIdNum = this.recommendMapper.findCustomerIdnumByRecommendId(recommendId);
            return StringUtils.isEmpty((Object)dbIdNum);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePolicy(String recommendId, String propasalNo, String policyNo) {
        CusRecommend recommend;
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        if (!StringUtils.isEmpty((Object)recommendId) && (recommend = (CusRecommend)this.recommendMapper.selectByPrimaryKey((Object)recommendId)) != null) {
            InsuranceProductItem insuranceProductItem = this.insuranceProductItemService.findByProductCode(recommend.getProductItemCode());
            BigDecimal commission = BigDecimal.ZERO;
            if (insuranceProductItem != null) {
                BigDecimal premium = new BigDecimal(insuranceProductItem.getInsurancePremium());
                commission = premium.multiply(new BigDecimal(recommend.getSellfeerate()).divide(BigDecimal.valueOf(100L)));
            }
            this.recommendMapper.updatePolicyNo(recommendId, propasalNo, policyNo, "2", commission);
        }
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public PageInfo<CusRecommendPolicy> queryPolicy(PolicyQuery request, PageRequest pageRequest) {
        boolean needPagition;
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        boolean bl = needPagition = pageRequest != null && pageRequest.getSize() > 0 && pageRequest.getSize() >= 0;
        if (needPagition) {
            String orderBy = PagerHelperUtils.getOrderBy((PageRequest)pageRequest);
            log.info("orderBy: {}", (Object)orderBy);
            PageHelper.startPage((int)PagerHelperUtils.getPageNum((PageRequest)pageRequest), (int)pageRequest.getSize(), (String)orderBy);
        }
        String tsUserCode = "";
        if (request.getTsUserCode().size() > 0) {
            tsUserCode = StringUtil.convertListToString((List)request.getTsUserCode());
        }
        String downloadUrl = "";
        downloadUrl = request.getIsOuter() != false ? this.outerDownloadUrl : this.innerDownloadUrl;
        List policyList = this.recommendMapper.queryPolicy(request.getRecommendId(), request.getIdNumber(), request.getPolicyTimeStart(), request.getPolicyTimeEnd(), tsUserCode, request.getLicenseNo(), request.getName(), request.getComCode());
        for (int i = 0; i < policyList.size(); ++i) {
            String policyDownloadUrl = downloadUrl + "?requestUUID=" + ((CusRecommendPolicy)policyList.get(i)).getRequestId() + "&policyNo=" + ((CusRecommendPolicy)policyList.get(i)).getPolicyNo() + "&fileType=PDF";
            if (request.getIsShort().booleanValue()) {
                String shortDownloadUrl = this.shortenUrlSupplierFactory.get().shortenUrl(policyDownloadUrl);
                ((CusRecommendPolicy)policyList.get(i)).setDownloadUrl(shortDownloadUrl);
                continue;
            }
            ((CusRecommendPolicy)policyList.get(i)).setDownloadUrl(policyDownloadUrl);
        }
        PageInfo pageInfo = null;
        pageInfo = new PageInfo(policyList);
        return pageInfo;
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public PageInfo<CusRecommendSign> querySigned(QuerySignSearchRequest request, PageRequest pageable) {
        boolean needPagition;
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        boolean bl = needPagition = pageable != null && pageable.getSize() > 0 && pageable.getSize() >= 0;
        if (needPagition) {
            String orderBy = PagerHelperUtils.getOrderBy((PageRequest)pageable);
            log.info("orderBy: {}", (Object)orderBy);
            PageHelper.startPage((int)PagerHelperUtils.getPageNum((PageRequest)pageable), (int)pageable.getSize(), (String)orderBy);
        }
        List recommendList = this.recommendMapper.querySigned(request.getTsUserCode(), request.getCustomerName(), request.getInsureDateStart(), request.getInsureDateEnd(), request.getRiskCode());
        List CusrecommendList = this.recommendMapper.queryCusSigned(request.getTsUserCode(), request.getCustomerName(), request.getInsureDateStart(), request.getInsureDateEnd(), request.getRiskCode());
        for (int i = 0; i < recommendList.size(); ++i) {
            String recommendId = ((CusRecommendSign)recommendList.get(i)).getId();
            for (int j = 0; j < CusrecommendList.size(); ++j) {
                if (!((CusRecommendSign)CusrecommendList.get(j)).getId().equals(recommendId)) continue;
                ((CusRecommendSign)recommendList.get(i)).setCustomerName(((CusRecommendSign)CusrecommendList.get(j)).getName());
            }
        }
        PageInfo pageInfo = null;
        pageInfo = new PageInfo(recommendList);
        return pageInfo;
    }

    public List<CusRecommendPolicy> queryPolicy(PolicyQuery request) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        String tsUserCode = "";
        if (request.getTsUserCode().size() > 0) {
            tsUserCode = StringUtil.convertListToString((List)request.getTsUserCode());
        }
        String downloadUrl = "";
        downloadUrl = request.getIsOuter() != false ? this.outerDownloadUrl : this.innerDownloadUrl;
        List policyList = this.recommendMapper.queryPolicy(request.getRecommendId(), request.getIdNumber(), request.getPolicyTimeStart(), request.getPolicyTimeEnd(), tsUserCode, request.getLicenseNo(), request.getName(), request.getComCode());
        for (int i = 0; i < policyList.size(); ++i) {
            String policyDownloadUrl = downloadUrl + "?requestUUID=" + ((CusRecommendPolicy)policyList.get(i)).getRequestId() + "&policyNo=" + ((CusRecommendPolicy)policyList.get(i)).getPolicyNo() + "&fileType=PDF";
            if (request.getIsShort().booleanValue()) {
                String shortDownloadUrl = this.shortenUrlSupplierFactory.get().shortenUrl(policyDownloadUrl);
                shortDownloadUrl = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)shortDownloadUrl) ? policyDownloadUrl : shortDownloadUrl;
                ((CusRecommendPolicy)policyList.get(i)).setDownloadUrl(shortDownloadUrl);
                continue;
            }
            ((CusRecommendPolicy)policyList.get(i)).setDownloadUrl(policyDownloadUrl);
        }
        return policyList;
    }

    public void updateSmsSendFlag(String recommendId, Integer status) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        this.recommendMapper.updateSmsSendFlag(recommendId, status);
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<CusRecommend> findAllNeedPolicySms() {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        Example selectExamp = new Example(CusRecommend.class);
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime now = LocalDateTime.now();
        selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andNotEqualTo("policySmsFlag", (Object)1).andIsNotNull("policyNo").andNotEqualTo("policyNo", (Object)"").andLessThanOrEqualTo("dateCreated", (Object)Date.from(now.atZone(zoneId).toInstant())).andGreaterThanOrEqualTo("dateCreated", (Object)Date.from(now.minusDays(10L).atZone(zoneId).toInstant()));
        return this.recommendMapper.selectByExample((Object)selectExamp);
    }

    public void updateSignUrl(SignatureRequest signReq) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        Example selectExamp = new Example(CusRecommend.class);
        Example.Criteria criteria = selectExamp.createCriteria();
        criteria.andEqualTo("isDelete", (Object)0);
        String recommendId = signReq.getRecommendId();
        recommendId = InjectionAttackWrapperDataStr.getDataStr((String)recommendId);
        String proposalNo = signReq.getProposalNo();
        proposalNo = InjectionAttackWrapperDataStr.getDataStr((String)proposalNo);
        if (!Lang.isEmpty((Object)signReq.getRecommendId())) {
            criteria.andEqualTo("id", (Object)recommendId);
        } else if (!Lang.isEmpty((Object)signReq.getProposalNo())) {
            criteria.andEqualTo("proposalNo", (Object)proposalNo);
        } else {
            return;
        }
        List cusRecommendList = this.recommendMapper.selectByExample((Object)selectExamp);
        for (CusRecommend r : cusRecommendList) {
            r.setSignUrl(signReq.getSignatureUrl());
            this.recommendMapper.updateByPrimaryKey((Object)r);
        }
    }

    public void resetSignUrl(String recommendId) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        CusRecommend recommend = (CusRecommend)this.recommendMapper.selectByPrimaryKey((Object)recommendId);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)recommend.getSignUrl())) {
            ArrayList<String> signUrlHis;
            List<String> list = signUrlHis = recommend.getSignUrlHis() == null ? new ArrayList<String>() : Splitter.on((String)",").splitToList((CharSequence)recommend.getSignUrlHis());
            if (!signUrlHis.contains(recommend.getSignUrl())) {
                signUrlHis.add(recommend.getSignUrl());
            }
            recommend.setSignUrl(null);
            recommend.setSignUrlHis(Joiner.on((String)",").skipNulls().join(signUrlHis));
            this.recommendMapper.updateByPrimaryKey((Object)recommend);
        }
    }

    public String getSignImage(String recommendId) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        return this.recommendMapper.getSignImage(recommendId);
    }

    public String getInsurerIdNumber(String recommendId) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        String idNumber = this.recommendMapper.getInsurerIdNumber(recommendId);
        return idNumber;
    }

    public String isRenewal2(String recommendId) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        String riskcode = this.recommendMapper.isRenewal2(recommendId);
        if (riskcode.contains("_")) {
            riskcode = riskcode.split("_")[0];
        }
        return riskcode;
    }

    public int getMaxEndDay(String riskCode) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        return this.recommendMapper.getMaxEndDay(riskCode);
    }
}

