/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.picc.gz.admin.dao.CustomerIdentityDao;
import com.picc.gz.admin.service.CustomerIdentityService;
import com.picc.gz.admin.vo.CustomerCoutVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Exception.class})
public class CustomerIdentityServiceImpl
implements CustomerIdentityService {
    @Autowired
    CustomerIdentityDao customerIdentityDao;

    public String getCustomerBaseInfo(String identifyNo, String licenseNo, String frameNo, String uuid) {
        return this.customerIdentityDao.getCustomerBaseInfo(identifyNo, licenseNo, frameNo, uuid);
    }

    public JSONObject getCarAndCustomerInfo(String licenseNo, String frameNo, String uuid) {
        return this.customerIdentityDao.getCarAndCustomerInfo(licenseNo, frameNo, uuid);
    }

    public JSONObject getPartyInfoByLicenseNoAndFrameNo(String licenseNo, String frameNo) {
        return this.customerIdentityDao.getPartyInfoByLicenseNoAndFrameNo(licenseNo, frameNo);
    }

    public JSONObject getCarAndCustomerInfoByIdentyNo(String identifyNo, String defaultLicenseNo, String uuid) {
        return this.customerIdentityDao.getCarAndCustomerInfoByIdentyNo(identifyNo, defaultLicenseNo, uuid);
    }

    public void recordCustomerBaseInfo(CustomerCoutVo countVo) {
        this.customerIdentityDao.recordCustomerBaseInfo(countVo);
    }

    public void recordAdvices(CustomerCoutVo countVo) {
        this.customerIdentityDao.recordAdvices(countVo);
    }

    public Boolean hasBaseInfo(String identifyNo, String licenseNo, String frameNo) {
        Long count = this.customerIdentityDao.getInfoCount(identifyNo, licenseNo, frameNo);
        if (count > 0L) {
            return true;
        }
        return false;
    }

    public JSONObject getBaseInfoRowNum(String identifyNo, String licenseNo, String frameNo) {
        if ("".equals(identifyNo) && "".equals(licenseNo)) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("row_num1", (Object)"0");
            jsonObj.put("row_num2", (Object)"0");
            return jsonObj;
        }
        return this.customerIdentityDao.getBaseInfoRowNum(identifyNo, licenseNo, frameNo);
    }
}

