/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.picc.gz.admin.dao.FeeRateMapper;
import com.picc.gz.admin.dao.QueryRateMapper;
import com.picc.gz.admin.service.FeeRateService;
import com.picc.gz.model.mapper.main.InsureRiskSalesRateMapper;
import com.picc.gz.model.model.FeeRate;
import com.picc.gz.model.model.InsureRiskSalesRate;
import com.picc.gz.utils.Lang;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.Weekend;
import tk.mybatis.mapper.weekend.WeekendCriteria;

@Service
@Transactional(rollbackFor={Exception.class})
public class FeeRateServiceImpl
implements FeeRateService {
    @Autowired
    private FeeRateMapper feeRateMapper;
    @Autowired
    private QueryRateMapper queryRateMapper;
    @Autowired
    private InsureRiskSalesRateMapper insureRiskSalesRateMapper;

    public FeeRate getByProductCode(String productCode) {
        if (Lang.isEmpty((Object)productCode)) {
            return null;
        }
        Example selectExamp = new Example(FeeRate.class);
        selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("productCode", (Object)productCode);
        FeeRate feeRate = (FeeRate)this.feeRateMapper.selectOneByExample((Object)selectExamp);
        return feeRate;
    }

    public InsureRiskSalesRate findByRisk(String companyCode, String riskCode, Boolean renewFlag, Boolean claimFlag) {
        return this.find(companyCode, riskCode, null, renewFlag, claimFlag);
    }

    public InsureRiskSalesRate findByProduct(String companyCode, String riskCode, String productCode, Boolean renewFlag, Boolean claimFlag) {
        return this.find(companyCode, riskCode, productCode, renewFlag, claimFlag);
    }

    public InsureRiskSalesRate findByRiskCode(String comCode, String riskCode, String planCode) {
        return this.findRiskCode(comCode, riskCode, planCode);
    }

    private InsureRiskSalesRate findRiskCode(String comCode, String riskCode, String planCode) {
        return this.find(comCode, riskCode, planCode, Boolean.valueOf(false), Boolean.valueOf(false));
    }

    public InsureRiskSalesRate find(String companyCode, String riskCode, String productCode, Boolean renewFlag, Boolean claimFlag) {
        Weekend weekend = new Weekend(InsureRiskSalesRate.class);
        WeekendCriteria basicCriteria = weekend.weekendCriteria();
        basicCriteria.andNotEqualTo(InsureRiskSalesRate::getDeleteFlag, (Object)1).andEqualTo(InsureRiskSalesRate::getRiskCode, (Object)riskCode);
        if (!Lang.isEmpty((Object)companyCode)) {
            WeekendCriteria comcodeCriteria = new Weekend(InsureRiskSalesRate.class).weekendCriteria();
            comcodeCriteria.orEqualTo(InsureRiskSalesRate::getCompanyCode, (Object)"00000000").orEqualTo(InsureRiskSalesRate::getCompanyCode, (Object)companyCode).orLike(InsureRiskSalesRate::getCompanyCode, "44000000").orLike(InsureRiskSalesRate::getCompanyCode, companyCode.substring(0, 4) + "%");
            weekend.and((Example.Criteria)comcodeCriteria);
            weekend.orderBy("companyCode").desc();
        } else {
            companyCode = "00000000";
            weekend.orderBy("companyCode").asc();
        }
        if (!Lang.isEmpty((Object)productCode)) {
            basicCriteria.andEqualTo(InsureRiskSalesRate::getPlanCode, (Object)productCode);
        }
        if (claimFlag != null) {
            basicCriteria.andEqualTo(InsureRiskSalesRate::getClaimFlag, (Object)(claimFlag != false ? 1 : 0));
        }
        if (renewFlag != null) {
            WeekendCriteria renewFlagCriteria = new Weekend(InsureRiskSalesRate.class).weekendCriteria();
            if (renewFlag.booleanValue()) {
                renewFlagCriteria.orEqualTo(InsureRiskSalesRate::getRenewFlag, (Object)0).orEqualTo(InsureRiskSalesRate::getRenewFlag, (Object)2);
            } else {
                renewFlagCriteria.orEqualTo(InsureRiskSalesRate::getRenewFlag, (Object)0).orEqualTo(InsureRiskSalesRate::getRenewFlag, (Object)1);
            }
            weekend.and((Example.Criteria)renewFlagCriteria);
        }
        weekend.orderBy("renewFlag").desc();
        List results = this.insureRiskSalesRateMapper.selectByExample((Object)weekend);
        if (results == null) {
            return null;
        }
        Date nowDate = new Date();
        results.removeIf(insureRiskSalesRate -> !insureRiskSalesRate.getLongTimeFlag().equals(1) && (nowDate.getTime() < insureRiskSalesRate.getEffectiveTime().getTime() || nowDate.getTime() >= insureRiskSalesRate.getInvalidTime().getTime()));
        if (results.size() == 1) {
            return (InsureRiskSalesRate)results.get(0);
        }
        results.sort(Comparator.comparing(InsureRiskSalesRate::getLongTimeFlag));
        AtomicReference<String> atomicComCode = new AtomicReference<String>(companyCode);
        String tempComCode = companyCode;
        InsureRiskSalesRate matchedRate = null;
        while (matchedRate == null) {
            String finalTempComCode = tempComCode;
            Optional<InsureRiskSalesRate> rate = results.stream().filter(insureRiskSalesRate -> insureRiskSalesRate.getCompanyCode().equals(finalTempComCode)).findFirst();
            if (rate.isPresent()) {
                matchedRate = rate.get();
                continue;
            }
            if ("00000000".equals(tempComCode)) {
                return null;
            }
            if ("00".equals(tempComCode.substring(6, 8))) {
                if ("0000".equals(tempComCode.substring(4, 8))) {
                    if ("000000".equals(tempComCode.substring(2, 8))) {
                        if ("00000000".equals(tempComCode)) continue;
                        tempComCode = "00000000";
                        continue;
                    }
                    tempComCode = tempComCode.substring(0, 2) + "000000";
                    continue;
                }
                tempComCode = tempComCode.substring(0, 4) + "0000";
                continue;
            }
            tempComCode = tempComCode.substring(0, 6) + "00";
        }
        return matchedRate;
    }
}

