/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.picc.gz.admin.service.HttpClientService;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class HttpClientServiceImpl
implements HttpClientService {
    Logger logger = LoggerFactory.getLogger(HttpClientServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postXmlRequest(String url, String xml) {
        String respStr = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            StringBuilder theUrl = new StringBuilder(url);
            HttpPost httpPost = new HttpPost(theUrl.toString());
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
            httpPost.setConfig(requestConfig);
            StringEntity httpEntity = new StringEntity(xml, "UTF-8");
            httpPost.setEntity((HttpEntity)httpEntity);
            httpPost.setHeader("Content-type", "application/xml");
            this.logger.info("\u8bf7\u6c42URL:" + url + "\u7684\u62a5\u6587 \uff1a\n" + xml);
            long startTime = System.currentTimeMillis();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            long endTime = System.currentTimeMillis();
            this.logger.info("\u8bf7\u6c42\u7684\u65f6\u95f4 \uff1a =========================" + (endTime - startTime) + "ms ============================");
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                respStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8").replaceAll("\r", "");
                this.logger.info("URL:" + url + "\u8fd4\u56de\u7684\u62a5\u6587 \uff1a\n" + respStr);
            }
            response.close();
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42URL:" + url + "\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return respStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHttpRequest(String url, List<NameValuePair> formParams) {
        String respStr = null;
        CloseableHttpClient httpClient = null;
        try {
            SSLConnectionSocketFactory sslsf;
            try {
                sslsf = new SSLConnectionSocketFactory(SSLContext.getDefault(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslsf).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(100);
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)cm).build();
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(formParams, "UTF-8");
            String httpEntityString = EntityUtils.toString((HttpEntity)httpEntity);
            StringBuilder theUrl = new StringBuilder(url + "?" + httpEntityString);
            HttpGet httpGet = new HttpGet(theUrl.toString());
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
            httpGet.setConfig(requestConfig);
            this.logger.info("\u8bf7\u6c42URL:" + url + "\u7684\u62a5\u6587 \uff1a\n" + httpEntityString);
            long startTime = System.currentTimeMillis();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            long endTime = System.currentTimeMillis();
            this.logger.info("\u8bf7\u6c42\u7684\u65f6\u95f4 \uff1a =========================" + (endTime - startTime) + "ms ============================");
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                respStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8").replaceAll("\r", "");
                this.logger.info("URL:" + url + "\u8fd4\u56de\u7684\u62a5\u6587 \uff1a\n" + respStr);
            }
            response.close();
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42URL:" + url + "\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return respStr;
    }
}

