/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.picc.gz.admin.dao.InsuranceProductItemMapper;
import com.picc.gz.admin.service.InsuranceProductItemService;
import com.picc.gz.model.model.InsuranceProductItem;
import com.picc.gz.model.model.RiskCode;
import com.picc.gz.utils.Lang;
import com.picc.gz.utils.ProductItemUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class InsuranceProductItemServiceImpl
implements InsuranceProductItemService {
    Logger logger = LoggerFactory.getLogger(InsuranceProductItemServiceImpl.class);
    @Autowired
    private InsuranceProductItemMapper productItemMapper;

    public List<InsuranceProductItem> findBySocialInsuranceAndAgeAndAmountSelect(String socialInsurance, String age, String amountSelect) {
        String ageKey = ProductItemUtils.ageKey((String)age, (Integer)5);
        if (!Lang.isEmpty((Object)ageKey)) {
            Example selectExamp = new Example(InsuranceProductItem.class);
            selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("socialInsurance", (Object)socialInsurance).andEqualTo("ageKey", (Object)ageKey).andEqualTo("insuranceAmount", (Object)amountSelect);
            selectExamp.setOrderByClause("sort ASC");
            List results = this.productItemMapper.selectByExample((Object)selectExamp);
            if (results == null) {
                this.logger.info("\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4ea7\u54c1\uff08\u5ba2\u6237\u5e74\u9f84\uff1a{}\uff0c\u5bf9\u5e94\u5e74\u9f84\u6bb5\u6807\u5fd7\uff1a{}, \u793e\u4fdd\u6807\u5fd7\uff1a{}, \u4fdd\u989d\u6807\u5fd7\uff1a{}\uff09", new Object[]{age, ageKey, socialInsurance, amountSelect});
                return null;
            }
            return results;
        }
        this.logger.info("\u5e74\u9f84\u4e0d\u7b26\u5408\u4ea7\u54c1\u9700\u6c42\uff0c\u9700\u57280-60\u5c81\u4e4b\u95f4");
        return null;
    }

    public InsuranceProductItem findByProductCode(String productCode) {
        InsuranceProductItem productItem = null;
        if (!Lang.isEmpty((Object)productCode)) {
            Example selectExamp = new Example(InsuranceProductItem.class);
            selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("productCode", (Object)productCode);
            productItem = (InsuranceProductItem)this.productItemMapper.selectOneByExample((Object)selectExamp);
            return productItem;
        }
        return null;
    }

    public List<InsuranceProductItem> findByRiskCode(String riskCode) {
        List<Object> productItems = new ArrayList<InsuranceProductItem>();
        if (!Lang.isEmpty((Object)riskCode)) {
            Example selectExamp = new Example(InsuranceProductItem.class);
            selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("riskCode", (Object)riskCode);
            selectExamp.setOrderByClause("sort ASC");
            productItems = this.productItemMapper.selectByExample((Object)selectExamp);
            return productItems;
        }
        return productItems;
    }

    public List<RiskCode> getRiskCodeList() {
        return this.productItemMapper.getRiskCodeList();
    }

    public List<InsuranceProductItem> findBySocialInsuranceAndAgeAndAmountSelectECD(String socialInsurance, String amountSelect) {
        Example selectExamp = new Example(InsuranceProductItem.class);
        selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("insuranceAmount", (Object)amountSelect);
        selectExamp.setOrderByClause("sort ASC");
        List results = this.productItemMapper.selectByExample((Object)selectExamp);
        if (results == null) {
            this.logger.info("\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4ea7\u54c1\uff08\u5ba2\u6237\u5e74\u9f84\uff1a{}\uff0c\u5bf9\u5e94\u5e74\u9f84\u6bb5\u6807\u5fd7\uff1a{}, \u793e\u4fdd\u6807\u5fd7\uff1a{}, \u4fdd\u989d\u6807\u5fd7\uff1a{}\uff09", (Object)socialInsurance, (Object)amountSelect);
            return null;
        }
        return results;
    }

    public List<InsuranceProductItem> findBySocialInsuranceAndAgeAndAmountSelectWCD(String socialInsurance, String age, String amountSelect, String mostPerson) {
        String ageKey = ProductItemUtils.ageKey((String)age, (Integer)5);
        if (!Lang.isEmpty((Object)ageKey)) {
            Example selectExamp = new Example(InsuranceProductItem.class);
            selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("socialInsurance", (Object)socialInsurance).andEqualTo("ageKey", (Object)ageKey).andEqualTo("mostPerson", (Object)mostPerson).andEqualTo("insuranceAmount", (Object)amountSelect);
            selectExamp.setOrderByClause("sort ASC");
            List results = this.productItemMapper.selectByExample((Object)selectExamp);
            if (results == null) {
                this.logger.info("\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4ea7\u54c1\uff08\u5ba2\u6237\u5e74\u9f84\uff1a{}\uff0c\u5bf9\u5e94\u5e74\u9f84\u6bb5\u6807\u5fd7\uff1a{}, \u793e\u4fdd\u6807\u5fd7\uff1a{}, \u4fdd\u989d\u6807\u5fd7\uff1a{}\uff09", new Object[]{age, ageKey, socialInsurance, amountSelect});
                return null;
            }
            return results;
        }
        this.logger.info("\u5e74\u9f84\u4e0d\u7b26\u5408\u4ea7\u54c1\u9700\u6c42\uff0c\u9700\u57280-60\u5c81\u4e4b\u95f4");
        return null;
    }

    public List<InsuranceProductItem> getAllProductsByType() {
        Example selectExamp = new Example(InsuranceProductItem.class);
        selectExamp.createCriteria().andEqualTo("isDelete", (Object)0);
        List results = this.productItemMapper.selectByExample((Object)selectExamp);
        return results;
    }
}

