/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.chrhc.mybatis.autodate.util.StringUtil;
import com.chrhc.mybatis.autodate.util.TemplateUtils;
import com.picc.gz.admin.dao.CusRecommendPersonnelMapper;
import com.picc.gz.admin.dao.CusRecommendSalerMapper;
import com.picc.gz.admin.service.AddressService;
import com.picc.gz.admin.service.BusinessUnitService;
import com.picc.gz.admin.service.CusRecommendExtAttrService;
import com.picc.gz.admin.service.CusRecommendPersonnelService;
import com.picc.gz.admin.service.CusRecommendService;
import com.picc.gz.admin.service.DzfpRequiredService;
import com.picc.gz.admin.service.FeeRateService;
import com.picc.gz.admin.service.HttpClientService;
import com.picc.gz.admin.service.InsuranceProductItemService;
import com.picc.gz.admin.service.InsurePolicyService;
import com.picc.gz.admin.service.RecommendRequestService;
import com.picc.gz.admin.service.RenewalService;
import com.picc.gz.admin.service.SalerSelectorFactory;
import com.picc.gz.admin.service.SalesmanService;
import com.picc.gz.admin.vo.insure.ApplicantInfo;
import com.picc.gz.admin.vo.insure.BusinessUnitInfo;
import com.picc.gz.admin.vo.insure.DzfpRequiredInfo;
import com.picc.gz.admin.vo.insure.EauRequiredInfo;
import com.picc.gz.admin.vo.insure.EddRequiredInfo;
import com.picc.gz.admin.vo.insure.ExtraRequiredInfo;
import com.picc.gz.admin.vo.insure.InsureRequest;
import com.picc.gz.admin.vo.insure.InsureResponse;
import com.picc.gz.admin.vo.insure.InsuredInfo;
import com.picc.gz.admin.vo.insure.InternalInfo;
import com.picc.gz.admin.vo.insure.JabRequiredInfo;
import com.picc.gz.admin.vo.insure.LdoRequiredInfo;
import com.picc.gz.admin.vo.insure.PlanInfo;
import com.picc.gz.admin.vo.insure.PolicyInfo;
import com.picc.gz.admin.vo.insure.ProductInfo;
import com.picc.gz.admin.vo.insure.QueryPolicyRequest;
import com.picc.gz.admin.vo.insure.QueryPolicyResponse;
import com.picc.gz.admin.vo.insure.QueryRequestBody;
import com.picc.gz.admin.vo.insure.ReqSellerInfo;
import com.picc.gz.admin.vo.insure.RequestBody;
import com.picc.gz.admin.vo.insure.RequestHead;
import com.picc.gz.admin.vo.insure.ResponseBody;
import com.picc.gz.admin.vo.insure.ResponseHead;
import com.picc.gz.admin.vo.insure.StakeHolderInfo;
import com.picc.gz.admin.vo.insure.YelRequiredInfo;
import com.picc.gz.admin.vo.insure.ZciRequiredInfo;
import com.picc.gz.model.model.Address;
import com.picc.gz.model.model.BusinessUnit;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.CusRecommendExtAttr;
import com.picc.gz.model.model.CusRecommendPersonnel;
import com.picc.gz.model.model.CusRecommendSaler;
import com.picc.gz.model.model.DzfpRequired;
import com.picc.gz.model.model.InsuranceProductItem;
import com.picc.gz.model.model.InsureDO;
import com.picc.gz.model.model.InsureRiskSalesRate;
import com.picc.gz.model.model.RecommendRequest;
import com.picc.gz.model.model.Salesman;
import com.picc.gz.utils.DateUtils;
import com.picc.gz.utils.Lang;
import com.picc.gz.utils.MD5Utils;
import com.picc.gz.utils.XmlUtil;
import com.thoughtworks.xstream.io.StreamException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class InsurePolicyServiceImpl
implements InsurePolicyService {
    private static final Logger log = LoggerFactory.getLogger(InsurePolicyServiceImpl.class);
    Logger logger = LoggerFactory.getLogger(InsurePolicyServiceImpl.class);
    private static final String TEMPLATE_PATH = "/templates/product";
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @Autowired
    public InsuranceProductItemService productItemService;
    @Autowired
    public CusRecommendPersonnelService recommendPersonnelService;
    @Autowired
    public CusRecommendService recommendService;
    @Autowired
    public HttpClientService httpClientService;
    @Autowired
    public RecommendRequestService recommendRequestService;
    @Autowired
    public CusRecommendPersonnelService cusRecommendPersonnelService;
    @Autowired
    public FeeRateService feeRateService;
    @Autowired
    public BusinessUnitService businessUnitService;
    @Autowired
    private CusRecommendSalerMapper cusRecommendSalerMapper;
    @Autowired
    private CusRecommendPersonnelMapper recommendPersonnelMapper;
    @Autowired
    private CusRecommendExtAttrService extAttrService;
    @Autowired
    private SalerSelectorFactory salerSelectorFactory;
    @Autowired
    private AddressService addressService;
    @Autowired
    private DzfpRequiredService dzfpRequiredService;
    @Autowired
    private SalesmanService salesmanService;
    @Value(value="${yeePay.debug}")
    private Boolean yeePayDebug;
    @Value(value="${yeePay.pipeCode}")
    private String pipeCode;
    @Value(value="${yeePay.businessUnitCode}")
    private String businessUnitCode;
    @Value(value="${yeePay.md5key}")
    private String md5key;
    @Value(value="${yeePay.policyUrl}")
    private String policyUrl;
    @Value(value="${yeePay.queryUrl}")
    private String queryUrl;
    @Value(value="${yeePay.insure.mutiPlan.policyUrl}")
    private String policyUrls;
    @Value(value="${yeePay.insure.mutiPlan.riskCodes}")
    private String mutiplanRiskCodes;
    @Value(value="${yeePay.pipeCodeWCD}")
    private String pipeCodeWCD;
    @Autowired
    RenewalService renewalService;

    public ResponseBody policyPay(String recommendId, int number, String amountSelect, String oldPolicyNo, String feeRate) {
        QueryPolicyResponse queryPolicyResponse;
        ResponseBody responseBody = new ResponseBody();
        CusRecommend cusRecommend = this.recommendService.findById(recommendId);
        if (!Lang.isEmpty((Object)cusRecommend.getPolicyNo())) {
            responseBody.setResultMessage(String.format("\u5df2\u7ecf\u8f6c\u4fdd\u6210\u529f\uff0c\u4fdd\u5355\u53f7\u4e3a:%s\uff0c\u7535\u5b50\u4fdd\u5355\u5df2\u53d1\u9001\u60a8\u7684\u90ae\u7bb1\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\uff01\u6b22\u8fce\u60a8\u767b\u9646\u6211\u516c\u53f8\u5b98\u7f51www.epicc.com.cn\u67e5\u8be2\u7535\u5b50\u4fdd\u5355\u4fe1\u606f\u548c\u4fdd\u9669\u6761\u6b3e\u3002\u66f4\u591a\u8be6\u60c5\uff0c\u8bf7\u62e8\u6253\u670d\u52a1\u4e13\u7ebf95518", cusRecommend.getPolicyNo()));
            return responseBody;
        }
        RecommendRequest histroyRequest = this.recommendRequestService.findByRecommendId(recommendId);
        if (!Lang.isEmpty((Object)histroyRequest) && (queryPolicyResponse = this.queryLastPolicyPay(recommendId)).getResponseBody() != null && "true".equals(queryPolicyResponse.getResponseBody().getResultFlag()) && !Lang.isEmpty((Object)queryPolicyResponse.getResponseBody().getPolicyNo())) {
            responseBody.setResultMessage(String.format("\u5df2\u7ecf\u8f6c\u4fdd\u6210\u529f\uff0c\u4fdd\u5355\u53f7\u4e3a:%s\uff0c\u7535\u5b50\u4fdd\u5355\u5df2\u53d1\u9001\u60a8\u7684\u90ae\u7bb1\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\uff01\u6b22\u8fce\u60a8\u767b\u9646\u6211\u516c\u53f8\u5b98\u7f51www.epicc.com.cn\u67e5\u8be2\u7535\u5b50\u4fdd\u5355\u4fe1\u606f\u548c\u4fdd\u9669\u6761\u6b3e\u3002\u66f4\u591a\u8be6\u60c5\uff0c\u8bf7\u62e8\u6253\u670d\u52a1\u4e13\u7ebf95518", queryPolicyResponse.getResponseBody().getPolicyNo()));
            return responseBody;
        }
        try {
            int i;
            InsureRequest insureRequest = new InsureRequest();
            UUID uuid = UUID.randomUUID();
            String requestId = uuid.toString();
            insureRequest.setRequestHead(this.setRequestHead(requestId, recommendId));
            insureRequest.setRequestBody(this.setRequestBody(recommendId, number, amountSelect, oldPolicyNo, feeRate));
            RecommendRequest reqLog = new RecommendRequest();
            reqLog.setRecommendId(recommendId);
            reqLog.setRequestId(requestId);
            HashMap<String, Object> templateData = new HashMap<String, Object>();
            templateData.put("requestHead", insureRequest.getRequestHead());
            templateData.put("businessUnitInfo", insureRequest.getRequestBody().getBusinessUnitInfo());
            templateData.put("productInfo", insureRequest.getRequestBody().getProductInfo());
            templateData.put("policyInfo", insureRequest.getRequestBody().getPolicyInfo());
            templateData.put("applicantInfo", insureRequest.getRequestBody().getApplicantInfo());
            templateData.put("insuredInfo", insureRequest.getRequestBody().getInsuredInfo());
            templateData.put("planInfo", insureRequest.getRequestBody().getPlanInfo());
            templateData.put("internalInfo", insureRequest.getRequestBody().getInternalInfo());
            templateData.put("stakeHolderInfo", insureRequest.getRequestBody().getStakeHolderInfo());
            templateData.put("reqSellerInfo", insureRequest.getRequestBody().getInternalInfo().getReqSellerInfos().get(0));
            templateData.put("jabRequiredInfo", insureRequest.getRequestBody().getJabRequiredInfo());
            templateData.put("extraRequiredInfo", insureRequest.getRequestBody().getExtraRequiredInfo());
            templateData.put("eddRequiredInfo", insureRequest.getRequestBody().getEddRequiredInfo());
            templateData.put("eauRequiredInfo", insureRequest.getRequestBody().getEauRequiredInfo());
            templateData.put("yelRequiredInfo", insureRequest.getRequestBody().getYelRequiredInfo());
            templateData.put("dzfpRequiredInfo", insureRequest.getRequestBody().getDzfpRequiredInfo());
            templateData.put("ldoRequiredInfo", insureRequest.getRequestBody().getLdoRequiredInfo());
            templateData.put("requiredInfo", insureRequest.getRequestBody().getRequiredInfo());
            templateData.put("ldoRequiredInfo", insureRequest.getRequestBody().getEauRequiredInfo());
            String xml = "";
            String riskCode = cusRecommend.getRealRiskCode();
            InsuranceProductItem productItem = this.productItemService.findByProductCode(cusRecommend.getProductItemCode());
            ArrayList<InsuredInfo> insuredInfoList = new ArrayList<InsuredInfo>();
            ArrayList<PlanInfo> planInfoList = new ArrayList<PlanInfo>();
            if ("WCD".equals(cusRecommend.getRealRiskCode())) {
                List cusRecommendPersonnelList = new ArrayList();
                Example selectExamp = new Example(CusRecommendPersonnel.class);
                selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("type", (Object)2).andEqualTo("recommendId", (Object)recommendId);
                cusRecommendPersonnelList = this.recommendPersonnelMapper.selectByExample((Object)selectExamp);
                if (cusRecommendPersonnelList != null) {
                    for (i = 0; i < number; ++i) {
                        CusRecommendPersonnel personnel = (CusRecommendPersonnel)cusRecommendPersonnelList.get(i);
                        InsuredInfo insuredInfo = new InsuredInfo();
                        insuredInfo.setName(personnel.getName());
                        insuredInfo.setIdType(personnel.getIdType());
                        insuredInfo.setIdNumber(personnel.getIdNumber());
                        insuredInfo.setGender(String.valueOf(personnel.getGender()));
                        insuredInfo.setBirthDay(DateUtils.dateToStr((Date)personnel.getBirthDay()));
                        insuredInfo.setMobile(personnel.getMobile());
                        insuredInfo.setEmail(personnel.getEmail());
                        if (personnel.getAddress() != null) {
                            insuredInfo.setAddress(personnel.getAddress());
                        } else {
                            insuredInfo.setAddress("----");
                        }
                        insuredInfo.setInsuredIdentity(personnel.getInsuredIdentity());
                        insuredInfo.setInsuredIsSocialSe(personnel.getApplicantIsSocialSe());
                        insuredInfoList.add(insuredInfo);
                        String applicantIsSocialSe = personnel.getApplicantIsSocialSe();
                        int age = StringUtil.getAgeByBirth((Date)personnel.getBirthDay());
                        String ages = String.valueOf(age);
                        List insuranceProductItemList = this.productItemService.findBySocialInsuranceAndAgeAndAmountSelect(applicantIsSocialSe, ages, amountSelect);
                        InsuranceProductItem insuranceProductItem = (InsuranceProductItem)insuranceProductItemList.get(0);
                        PlanInfo planInfo = new PlanInfo();
                        planInfo.setRiskCode(insuranceProductItem.getRiskCode());
                        planInfo.setRationType(insuranceProductItem.getProductCode());
                        planInfo.setPremium(insuranceProductItem.getInsurancePremium());
                        planInfo.setAmount(insuranceProductItem.getInsuranceAmount());
                        planInfoList.add(planInfo);
                    }
                }
            }
            templateData.put("insuredInfoList", insuredInfoList);
            templateData.put("planInfoList", planInfoList);
            xml = TemplateUtils.parseText((String)String.format("%s/%s.ftl", TEMPLATE_PATH, riskCode), templateData);
            reqLog.setReqPacket(xml);
            String respStrXml = null;
            String[] codes = this.mutiplanRiskCodes.trim().split(",");
            if (codes.length != 0) {
                for (i = 0; i < codes.length; ++i) {
                    if (!codes[i].equals(cusRecommend.getRealRiskCode())) continue;
                    this.policyUrl = this.policyUrls;
                    break;
                }
            }
            respStrXml = this.httpClientService.postXmlRequest(this.policyUrl, xml);
            reqLog.setRespPacket(respStrXml);
            this.recommendRequestService.saveRecommendRequest(reqLog);
            InsureResponse insureResponse = (InsureResponse)XmlUtil.toBean((String)respStrXml, InsureResponse.class);
            responseBody = insureResponse.getResponseBody();
            if ("true".equals(responseBody.getResultFlag())) {
                if (!Lang.isEmpty((Object)responseBody.getPayUrl())) {
                    String payUrl = responseBody.getPayUrl().replaceAll("&amp;", "&");
                    responseBody.setPayUrl(payUrl);
                }
                this.recommendRequestService.updateProposalNo(reqLog.getId(), responseBody.getProposalNo());
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e0b\u5355\u6613\u652f\u4ed8\u63a5\u53e3\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
            return responseBody;
        }
        if ("\u5173\u7cfb\u4eba\u59d3\u540d\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\uff01".equals(responseBody.getResultMessage())) {
            responseBody.setResultMessage("\u5173\u7cfb\u4eba\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25\uff1a\u8eab\u4efd\u8bc1\u53f7\u4e0e\u59d3\u540d\u4e0d\u5339\u914d\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u586b\u5199\uff01");
        }
        return responseBody;
    }

    public QueryPolicyResponse queryLastPolicyPay(String recommendId) {
        QueryPolicyResponse queryPolicyResponse = new QueryPolicyResponse();
        RecommendRequest histroyRequest = this.recommendRequestService.findByRecommendId(recommendId);
        if (!Lang.isEmpty((Object)histroyRequest) && !Lang.isEmpty((Object)histroyRequest.getRequestId())) {
            return this.queryPolicyPay(histroyRequest.getRequestId(), recommendId);
        }
        return queryPolicyResponse;
    }

    public QueryPolicyResponse queryPolicyPay(String requestId, String recommendId) {
        QueryPolicyResponse queryPolicyResponse = new QueryPolicyResponse();
        if (!Lang.isEmpty((Object)requestId)) {
            UUID uuid = UUID.randomUUID();
            QueryPolicyRequest queryPolicyRequest = new QueryPolicyRequest();
            queryPolicyRequest.setRequestHead(this.setRequestHead(uuid.toString(), recommendId));
            queryPolicyRequest.setRequestBody(new QueryRequestBody(requestId));
            String xml = XmlUtil.toXml((Object)queryPolicyRequest);
            CusRecommend cusRecommend = this.recommendService.findById(recommendId);
            String respStrXml = null;
            respStrXml = cusRecommend.getRiskCode().equals("WCD") ? this.httpClientService.postXmlRequest(this.policyUrls, xml) : this.httpClientService.postXmlRequest(this.queryUrl, xml);
            try {
                queryPolicyResponse = (QueryPolicyResponse)XmlUtil.toBean((String)respStrXml, QueryPolicyResponse.class);
                ResponseHead responseHead = queryPolicyResponse.getResponseHead();
                if (queryPolicyRequest.getRequestHead().getRequestUUID().equals(responseHead.getRequestUUID()) && queryPolicyRequest.getRequestHead().getPipeCode().equals(responseHead.getPipeCode()) && queryPolicyRequest.getRequestHead().getMd5EncryptedValue().equals(responseHead.getMd5EncryptedValue())) {
                    return queryPolicyResponse;
                }
            }
            catch (StreamException e) {
                e.printStackTrace();
                queryPolicyResponse = new QueryPolicyResponse();
                queryPolicyResponse.setResponseBody(new ResponseBody());
                queryPolicyResponse.getResponseBody().setResultFlag("false");
                queryPolicyResponse.getResponseBody().setResultMessage(e.getMessage());
                return queryPolicyResponse;
            }
        }
        return queryPolicyResponse;
    }

    private RequestHead setRequestHead(String requestId, String recommendId) {
        RequestHead requestHead = new RequestHead();
        requestHead.setRequestUUID(requestId);
        CusRecommend cusRecommend = this.recommendService.findById(recommendId);
        if (cusRecommend.getRiskCode().equals("WCD")) {
            requestHead.setPipeCode(this.pipeCodeWCD);
        } else {
            requestHead.setPipeCode(this.pipeCode);
        }
        requestHead.setMd5EncryptedValue(MD5Utils.encode((String)requestId, (String)this.md5key));
        return requestHead;
    }

    private RequestBody setRequestBody(String recommendId, int number, String amountSelect, String oldPolicyNo, String feeRate) throws ParseException {
        RequestBody requestBody = new RequestBody();
        CusRecommend cusRecommend = this.recommendService.findById(recommendId);
        requestBody.setBusinessUnitInfo(this.setBusinessUnitInfo(cusRecommend));
        requestBody.setProductInfo(this.setProductInfo(cusRecommend, number));
        requestBody.setPolicyInfo(this.setPolicyInfo(cusRecommend, recommendId, number, amountSelect));
        requestBody.setApplicantInfo(this.setApplicantInfo(recommendId));
        requestBody.setInsuredInfo(this.setInsuredInfo(cusRecommend, recommendId));
        requestBody.setInternalInfo(this.setInternalInfo(cusRecommend, recommendId, feeRate));
        requestBody.setStakeHolderInfo(this.setStakeHolderInfo(recommendId));
        requestBody.setJabRequiredInfo(this.setJabRequiredInfo(recommendId));
        requestBody.setRequiredInfo(this.setRequiredInfo(recommendId));
        requestBody.setEddRequiredInfo(this.setEddRequiredInfo(recommendId));
        requestBody.setEauRequiredInfo(this.setEauRequiredInfo(cusRecommend, recommendId));
        requestBody.setYelRequiredInfo(this.setYelRequiredInfo(recommendId));
        requestBody.setDzfpRequiredInfo(this.setDzfpRequiredInfo(cusRecommend));
        requestBody.setLdoRequiredInfo(this.setLdoRequiredInfo(recommendId));
        requestBody.setZciRequiredInfo(this.setZciRequiredInfo(recommendId));
        requestBody.setPlanInfo(this.setPlanInfo(cusRecommend, number));
        StakeHolderInfo stakeHolderInfo = this.setStakeHolderInfo(recommendId);
        if (!Lang.isEmpty((Object)stakeHolderInfo)) {
            requestBody.setStakeHolderInfo(stakeHolderInfo);
            requestBody.getProductInfo().setRationType(String.format("%sa", requestBody.getProductInfo().getRationType()));
        }
        requestBody.setExtraRequiredInfo(this.createExtraRequiredInfo(cusRecommend, oldPolicyNo));
        return requestBody;
    }

    private PlanInfo setPlanInfo(CusRecommend cusRecommend, int number) {
        PlanInfo planInfo = new PlanInfo();
        InsuranceProductItem productItem = this.productItemService.findByProductCode(cusRecommend.getProductItemCode());
        planInfo.setRiskCode(cusRecommend.getRealRiskCode());
        Double premium = Double.valueOf(productItem.getInsurancePremium());
        Double Amount = Double.valueOf(productItem.getInsuranceAmount());
        planInfo.setRationType(productItem.getProductCode());
        planInfo.setPremium(String.valueOf(premium));
        planInfo.setAmount(String.valueOf(Amount));
        return planInfo;
    }

    private BusinessUnitInfo setBusinessUnitInfo(CusRecommend cusRecommend) {
        BusinessUnitInfo businessUnitInfo = new BusinessUnitInfo();
        BusinessUnit businessUnit = this.businessUnitService.findByRiskCode(cusRecommend.getRealRiskCode());
        businessUnitInfo.setBusinessUnitCode(businessUnit.getBusinessUnitCode());
        return businessUnitInfo;
    }

    private ProductInfo setProductInfo(CusRecommend cusRecommend, int number) {
        ProductInfo productInfo = new ProductInfo();
        InsuranceProductItem productItem = this.productItemService.findByProductCode(cusRecommend.getProductItemCode());
        productInfo.setRiskCode(cusRecommend.getRealRiskCode());
        if ("WCD".equals(cusRecommend.getRealRiskCode())) {
            Double premium = Double.valueOf(productItem.getInsurancePremium());
            Double Amount = Double.valueOf(productItem.getInsuranceAmount());
            if (number == 2) {
                productInfo.setRationType("WCD0000two");
                productInfo.setPremium(String.valueOf(premium * (double)number));
                productInfo.setAmount(String.valueOf(Amount * (double)number));
            } else if (number == 3) {
                productInfo.setRationType("WCD00three");
                productInfo.setPremium(String.valueOf(premium * (double)number));
                productInfo.setAmount(String.valueOf(Amount * (double)number));
            } else if (number == 4) {
                productInfo.setRationType("WCD000four");
                productInfo.setPremium(String.valueOf(premium * (double)number));
                productInfo.setAmount(String.valueOf(Amount * (double)number));
            } else if (number == 5) {
                productInfo.setRationType("WCD000five");
                productInfo.setPremium(String.valueOf(premium * (double)number));
                productInfo.setAmount(String.valueOf(Amount * (double)number));
            } else if (number == 6) {
                productInfo.setRationType("WCD000six");
                productInfo.setPremium(String.valueOf(premium * (double)number));
                productInfo.setAmount(String.valueOf(Amount * (double)number));
            } else if (number == 7) {
                productInfo.setRationType("WCD00seven");
                productInfo.setPremium(String.valueOf(premium * (double)number));
                productInfo.setAmount(String.valueOf(Amount * (double)number));
            }
        } else {
            productInfo.setRationType(productItem.getProductCode());
            productInfo.setPremium(productItem.getInsurancePremium());
            productInfo.setAmount(productItem.getInsuranceAmount());
        }
        return productInfo;
    }

    private PolicyInfo setPolicyInfo(CusRecommend cusRecommend, String recommendId, int number, String amountSelect) throws ParseException {
        PolicyInfo policyInfo = new PolicyInfo();
        InsuranceProductItem productItem = this.productItemService.findByProductCode(cusRecommend.getProductItemCode());
        policyInfo.setOperateTime(DateUtils.getFullNowTime());
        policyInfo.setStartDate(DateUtils.dateToStr((Date)cusRecommend.getInsuranceStartDate()));
        policyInfo.setEndDate(DateUtils.dateToStr((Date)cusRecommend.getInsuranceEndDate()));
        policyInfo.setStartHour("0");
        policyInfo.setEndHour("24");
        if ("EAU".equals(cusRecommend.getRealRiskCode())) {
            EauRequiredInfo eauRequiredInfo = this.extAttrService.findEauInfoByRecommendId(recommendId);
            policyInfo.setInsureCount(eauRequiredInfo.getVehicleSeat());
            policyInfo.setUnit(cusRecommend.getUnit());
            DecimalFormat df = new DecimalFormat("0.00");
            Double sumAmount = Double.valueOf(productItem.getInsuranceAmount()) * Double.valueOf(eauRequiredInfo.getVehicleSeat()) * Double.valueOf(cusRecommend.getUnit());
            Double sumPremium = Double.valueOf(productItem.getInsurancePremium()) * Double.valueOf(eauRequiredInfo.getVehicleSeat()) * Double.valueOf(cusRecommend.getUnit());
            policyInfo.setSumAmount(df.format(sumAmount));
            policyInfo.setSumPremium(df.format(sumPremium));
        } else if ("WCD".equals(cusRecommend.getRealRiskCode())) {
            double sumAmount = 0.0;
            double sumPremium = 0.0;
            policyInfo.setUnit(cusRecommend.getUnit());
            policyInfo.setInsureCount("1");
            DecimalFormat df = new DecimalFormat("0.00");
            List cusRecommendPersonnelList = new ArrayList();
            Example selectExamp = new Example(CusRecommendPersonnel.class);
            selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("type", (Object)2).andEqualTo("recommendId", (Object)recommendId);
            cusRecommendPersonnelList = this.recommendPersonnelMapper.selectByExample((Object)selectExamp);
            InsuranceProductItem insuranceProductItem = new InsuranceProductItem();
            if (cusRecommendPersonnelList != null) {
                for (int i = 0; i < number; ++i) {
                    CusRecommendPersonnel personnel = (CusRecommendPersonnel)cusRecommendPersonnelList.get(i);
                    String applicantIsSocialSe = personnel.getApplicantIsSocialSe();
                    int age = StringUtil.getAgeByBirth((Date)personnel.getBirthDay());
                    String ages = String.valueOf(age);
                    List insuranceProductItemList = this.productItemService.findBySocialInsuranceAndAgeAndAmountSelect(applicantIsSocialSe, ages, amountSelect);
                    insuranceProductItem = (InsuranceProductItem)insuranceProductItemList.get(0);
                    Double sumAmountNew = Double.valueOf(insuranceProductItem.getInsuranceAmount());
                    sumAmount += sumAmountNew.doubleValue();
                    Double sumPremiumNew = Double.valueOf(insuranceProductItem.getInsurancePremium());
                    sumPremium += sumPremiumNew.doubleValue();
                }
            }
            policyInfo.setSumAmount(df.format(sumAmount));
            policyInfo.setSumPremium(df.format(sumPremium));
        } else {
            policyInfo.setUnit(cusRecommend.getUnit());
            policyInfo.setInsureCount("1");
            DecimalFormat df = new DecimalFormat("0.00");
            Double sumAmount = Double.valueOf(productItem.getInsuranceAmount()) * Double.valueOf(cusRecommend.getUnit());
            Double sumPremium = Double.valueOf(productItem.getInsurancePremium()) * Double.valueOf(cusRecommend.getUnit());
            policyInfo.setSumAmount(df.format(sumAmount));
            policyInfo.setSumPremium(df.format(sumPremium));
        }
        return policyInfo;
    }

    private ApplicantInfo setApplicantInfo(String recommendId) {
        ApplicantInfo applicantInfo = new ApplicantInfo();
        CusRecommendPersonnel personnel = this.recommendPersonnelService.findApplicantInfoByRecommendId(recommendId);
        applicantInfo.setName(personnel.getName());
        applicantInfo.setIdType(personnel.getIdType());
        applicantInfo.setIdNumber(personnel.getIdNumber());
        applicantInfo.setGender(String.valueOf(personnel.getGender()));
        applicantInfo.setBirthDay(DateUtils.dateToStr((Date)personnel.getBirthDay()));
        applicantInfo.setMobile(personnel.getMobile());
        applicantInfo.setEmail(personnel.getEmail());
        applicantInfo.setAddress(personnel.getAddress());
        applicantInfo.setInsuredIdentity(personnel.getInsuredIdentity());
        applicantInfo.setApplicantIsSocialSe(personnel.getApplicantIsSocialSe());
        return applicantInfo;
    }

    private InsuredInfo setInsuredInfo(CusRecommend cusRecommend, String recommendId) {
        InsuredInfo insuredInfo = new InsuredInfo();
        CusRecommendPersonnel personnel = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
        insuredInfo.setName(personnel.getName());
        insuredInfo.setIdType(personnel.getIdType());
        insuredInfo.setIdNumber(personnel.getIdNumber());
        insuredInfo.setGender(String.valueOf(personnel.getGender()));
        insuredInfo.setBirthDay(DateUtils.dateToStr((Date)personnel.getBirthDay()));
        insuredInfo.setMobile(personnel.getMobile());
        insuredInfo.setEmail(personnel.getEmail());
        insuredInfo.setAddress(personnel.getAddress());
        insuredInfo.setInsuredIdentity(personnel.getInsuredIdentity());
        insuredInfo.setInsuredIsSocialSe(personnel.getApplicantIsSocialSe());
        if (cusRecommend.getRealRiskCode().equals("ECD")) {
            List cusRecommendExtAttrList = this.extAttrService.findByRecommendTwo(recommendId);
            for (int i = 0; i < cusRecommendExtAttrList.size(); ++i) {
                if (((CusRecommendExtAttr)cusRecommendExtAttrList.get(i)).getAttrName().equals("occupationCode")) {
                    insuredInfo.setOccupationCode(((CusRecommendExtAttr)cusRecommendExtAttrList.get(i)).getAttrValue());
                    continue;
                }
                if (((CusRecommendExtAttr)cusRecommendExtAttrList.get(i)).getAttrName().equals("businessDetail")) {
                    insuredInfo.setBusinessDetail(((CusRecommendExtAttr)cusRecommendExtAttrList.get(i)).getAttrValue());
                    continue;
                }
                if (((CusRecommendExtAttr)cusRecommendExtAttrList.get(i)).getAttrName().equals("houseProperty")) {
                    insuredInfo.setHouseProperty(((CusRecommendExtAttr)cusRecommendExtAttrList.get(i)).getAttrValue());
                    continue;
                }
                if (!((CusRecommendExtAttr)cusRecommendExtAttrList.get(i)).getAttrName().equals("incomeSource")) continue;
                insuredInfo.setIncomeSource(((CusRecommendExtAttr)cusRecommendExtAttrList.get(i)).getAttrValue());
            }
        }
        return insuredInfo;
    }

    private StakeHolderInfo setStakeHolderInfo(String recommendId) {
        StakeHolderInfo stakeHolderInfo = new StakeHolderInfo();
        CusRecommendPersonnel personnel = this.recommendPersonnelService.findBeneficiaryByRecommendId(recommendId);
        if (Lang.isEmpty((Object)personnel.getIdNumber())) {
            return null;
        }
        stakeHolderInfo.setName(personnel.getName());
        stakeHolderInfo.setType("1");
        stakeHolderInfo.setIdentifytype("01");
        stakeHolderInfo.setIdentifynumber(personnel.getIdNumber());
        stakeHolderInfo.setGender(String.valueOf(personnel.getGender()));
        stakeHolderInfo.setBirth(DateUtils.dateToStr((Date)personnel.getBirthDay()));
        stakeHolderInfo.setAddress("-");
        return stakeHolderInfo;
    }

    private InternalInfo setInternalInfo(CusRecommend cusRecommend, String recommendId, String feeRate) {
        InternalInfo internalInfo = new InternalInfo();
        Salesman salesman = this.salesmanService.findByUsercode(cusRecommend.getTsUserCode());
        CusRecommendSaler salerQueryTpl = new CusRecommendSaler();
        salerQueryTpl.setIsDelete(Integer.valueOf(0));
        salerQueryTpl.setRecommendId(recommendId);
        salerQueryTpl.setVersion(null);
        List salers = this.cusRecommendSalerMapper.select((Object)salerQueryTpl);
        InsuranceProductItem productItem = this.productItemService.findByProductCode(cusRecommend.getProductItemCode());
        CusRecommendSaler saler = this.salerSelectorFactory.get().select(salers, new BigDecimal(productItem.getInsurancePremium()));
        if (saler != null) {
            cusRecommend.setComCode(saler.getComCode());
            cusRecommend.setMakeCode(saler.getMakeCode());
            cusRecommend.setHandlerCode(saler.getHandlerCode());
            cusRecommend.setHandler1Code(saler.getHandler1Code());
            cusRecommend.setOperatorCode(saler.getOperatorCode());
            cusRecommend.setSellerno(saler.getSellerno());
            cusRecommend.setSellername(saler.getSellername());
            cusRecommend.setAgentcode(saler.getAgentcode());
            cusRecommend.setSellfeerate(saler.getSellfeerate());
        }
        CusRecommendPersonnel insurer = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
        boolean renewFlag = false;
        boolean claimFlag = false;
        boolean outRenewFlag = false;
        InsureRiskSalesRate insureRiskSalesRate = null;
        if (saler != null && saler.getSellfeerate().equals(0)) {
            cusRecommend.setSellfeerate(Integer.valueOf(0));
        } else if (cusRecommend.getRiskCode().equals("EAU")) {
            String planCode = cusRecommend.getProductItemCode();
            String riskCode = cusRecommend.getRiskCode();
            if (!String.valueOf(saler.getSellfeerate()).equals("0")) {
                insureRiskSalesRate = this.feeRateService.findByRiskCode(salesman.getComcode(), riskCode, planCode);
            }
        } else {
            List insureDOList = this.renewalService.getRenewal(insurer.getIdNumber(), cusRecommend.getRealRiskCode());
            if (insureDOList != null && insureDOList.size() > 0) {
                insureDOList.sort((o1, o2) -> o2.getEnddate().compareTo(o1.getEnddate()));
                InsureDO lastInsure = (InsureDO)insureDOList.get(0);
                InsuranceProductItem insuranceProductItem = this.productItemService.findByProductCode(cusRecommend.getProductItemCode());
                LocalDateTime lastEndDate = LocalDateTime.ofInstant(lastInsure.getEnddate().toInstant(), ZoneId.systemDefault()).withHour(0).withMinute(0).withSecond(0).withNano(0);
                LocalDateTime curStartDate = LocalDateTime.ofInstant(cusRecommend.getInsuranceStartDate().toInstant(), ZoneId.systemDefault()).withHour(0).withMinute(0).withSecond(0).withNano(0);
                LocalDateTime limitedEndDate = lastEndDate.plusDays(insuranceProductItem.getEnddateLimits() + 1);
                if (limitedEndDate.isBefore(curStartDate)) {
                    outRenewFlag = true;
                    cusRecommend.setRemark(String.format("%s;\u8be5\u5ba2\u6237\u4e3a\u8131\u4fdd\u5ba2\u6237\uff08\u4e0a\u5e74\u7ec8\u4fdd\u65e5\u671f\uff1a%s, \u672c\u5355\u8d77\u4fdd\u65e5\u671f\uff1a%s, \u5bbd\u6cdb\u5929\u6570\uff1a%d\uff09", cusRecommend.getRemark(), lastEndDate.format(dateFormatter), curStartDate.format(dateFormatter), insuranceProductItem.getEnddateLimits()));
                    renewFlag = false;
                } else {
                    renewFlag = true;
                }
                Integer lastClaimFlag = lastInsure.getFlagLp();
                lastClaimFlag = lastClaimFlag == null ? 0 : lastClaimFlag;
                if (lastClaimFlag > 0) {
                    claimFlag = true;
                }
                cusRecommend.setRemark(String.format("%s;\u8be5\u5ba2\u6237\u4e3a\u7eed\u4fdd\u5ba2\u6237\uff08\u4e0a\u5e74\u7406\u8d54\u6570\u91cf%s\uff09", cusRecommend.getRemark(), lastClaimFlag));
                if (saler != null && !String.valueOf(saler.getSellfeerate()).equals("0")) {
                    insureRiskSalesRate = this.feeRateService.findByProduct(salesman.getComcode(), cusRecommend.getRiskCode(), cusRecommend.getProductItemCode(), Boolean.valueOf(renewFlag), Boolean.valueOf(claimFlag));
                }
            } else {
                insureRiskSalesRate = this.feeRateService.findByProduct(salesman.getComcode(), cusRecommend.getRiskCode(), cusRecommend.getProductItemCode(), Boolean.valueOf(false), Boolean.valueOf(false));
            }
        }
        if (insureRiskSalesRate != null) {
            cusRecommend.setSellfeerate(Integer.valueOf(insureRiskSalesRate.getSalesRate().intValue()));
            if (StringUtils.isEmpty((Object)cusRecommend.getRemark())) {
                // empty if block
            }
        }
        this.recommendService.saveCusRecommend(cusRecommend);
        internalInfo.setAgencyCode(cusRecommend.getAgentcode());
        internalInfo.setBusinessnature(cusRecommend.getAgentcode().substring(4, 5));
        internalInfo.setComCode(cusRecommend.getComCode());
        internalInfo.setMakeCode(cusRecommend.getMakeCode());
        internalInfo.setHandlerCode(cusRecommend.getHandlerCode());
        internalInfo.setHandler1Code(cusRecommend.getHandler1Code());
        internalInfo.setOperatorCode(cusRecommend.getOperatorCode());
        ReqSellerInfo reqSellerInfo = new ReqSellerInfo();
        reqSellerInfo.setSerialno("1");
        reqSellerInfo.setSellerno(cusRecommend.getSellerno());
        reqSellerInfo.setSellername(cusRecommend.getSellername());
        reqSellerInfo.setAgentcode(cusRecommend.getAgentcode());
        Integer selfFeeRate = cusRecommend.getSellfeerate();
        reqSellerInfo.setSellfeerate(String.valueOf(selfFeeRate));
        if (!StringUtils.isEmpty((Object)feeRate)) {
            reqSellerInfo.setSellfeerate(feeRate);
        }
        reqSellerInfo.setMainflag("1");
        ArrayList<ReqSellerInfo> reqSellerInfos = new ArrayList<ReqSellerInfo>();
        reqSellerInfos.add(reqSellerInfo);
        internalInfo.setReqSellerInfos(reqSellerInfos);
        return internalInfo;
    }

    private ExtraRequiredInfo createExtraRequiredInfo(CusRecommend cusRecommend, String oldPolicyNo) {
        ExtraRequiredInfo extraRequiredInfo = new ExtraRequiredInfo();
        extraRequiredInfo.setRemark(StringUtils.isEmpty((Object)cusRecommend.getTsUserCode()) ? "00000000" : cusRecommend.getTsUserCode());
        if (cusRecommend.getRiskCode().equals("WBK") && !StringUtils.isEmpty((Object)oldPolicyNo)) {
            extraRequiredInfo.setOldPolicyNo(oldPolicyNo);
        }
        return extraRequiredInfo;
    }

    private JabRequiredInfo setJabRequiredInfo(String recommendId) {
        JabRequiredInfo jabRequiredInfo = new JabRequiredInfo();
        CusRecommendPersonnel personnel = this.recommendPersonnelService.findInsuredInfoByRecommendId(recommendId);
        jabRequiredInfo.setAddress(personnel.getAddress());
        if (!Lang.isEmpty((Object)personnel.getArea())) {
            Address address = this.addressService.findById(personnel.getArea());
            if (!Lang.isEmpty((Object)address) && !Lang.isEmpty((Object)address.getZipCode())) {
                jabRequiredInfo.setPostCode(address.getZipCode());
            } else {
                jabRequiredInfo.setPostCode(personnel.getArea());
            }
        } else {
            jabRequiredInfo.setPostCode("100000");
        }
        return jabRequiredInfo;
    }

    private EddRequiredInfo setEddRequiredInfo(String recommendId) {
        EddRequiredInfo eddRequiredInfo = new EddRequiredInfo();
        eddRequiredInfo.setDriverType("089");
        eddRequiredInfo.setDrivingCarType("C1");
        return eddRequiredInfo;
    }

    private EauRequiredInfo setEauRequiredInfo(CusRecommend cusRecommend, String recommendId) {
        EauRequiredInfo eauRequiredInfo = new EauRequiredInfo();
        InsuranceProductItem productItem = this.productItemService.findByProductCode(cusRecommend.getProductItemCode());
        eauRequiredInfo = this.extAttrService.findEauInfoByRecommendId(recommendId);
        eauRequiredInfo.setUseNatureCode(productItem.getExtArrt());
        if ("0".equals(eauRequiredInfo.getIsCarNo())) {
            eauRequiredInfo.setLicenseNo("-");
        } else if ("1".equals(eauRequiredInfo.getIsCarNo())) {
            eauRequiredInfo.setEngineNo("-");
            eauRequiredInfo.setVinNo("-");
        }
        return eauRequiredInfo;
    }

    private YelRequiredInfo setYelRequiredInfo(String recommendId) {
        YelRequiredInfo yelRequiredInfo = new YelRequiredInfo();
        EauRequiredInfo eauRequiredInfo = this.extAttrService.findEauInfoByRecommendId(recommendId);
        yelRequiredInfo.setFuelName(eauRequiredInfo.getVinNo());
        yelRequiredInfo.setModel("2");
        yelRequiredInfo.setDeviceNo(eauRequiredInfo.getLicenseNo());
        yelRequiredInfo.setMakeFactory(eauRequiredInfo.getBrandName());
        yelRequiredInfo.setLadingNo("1");
        yelRequiredInfo.setInvoiceNo("1");
        return yelRequiredInfo;
    }

    private DzfpRequiredInfo setDzfpRequiredInfo(CusRecommend cusRecommend) {
        String comCode;
        DzfpRequired dzfpRequired;
        DzfpRequiredInfo dzfpRequiredInfo = new DzfpRequiredInfo();
        if (!Lang.isEmpty((Object)cusRecommend.getComCode()) && !Lang.isEmpty((Object)(dzfpRequired = this.dzfpRequiredService.getByComCode(comCode = cusRecommend.getComCode().substring(0, 4))))) {
            dzfpRequiredInfo.setComCode(dzfpRequired.getComCode());
            dzfpRequiredInfo.setTitletype(dzfpRequired.getTitleType());
            dzfpRequiredInfo.setFhname(dzfpRequired.getFhName());
            dzfpRequiredInfo.setKpcode(dzfpRequired.getKpCode());
        }
        return dzfpRequiredInfo;
    }

    private LdoRequiredInfo setLdoRequiredInfo(String recommendId) {
        LdoRequiredInfo ldoRequiredInfo = new LdoRequiredInfo();
        ldoRequiredInfo = this.extAttrService.findLdoInfoByRecommendId(recommendId);
        return ldoRequiredInfo;
    }

    private ZciRequiredInfo setZciRequiredInfo(String recommendId) {
        ZciRequiredInfo zciRequiredInfo = new ZciRequiredInfo();
        zciRequiredInfo = this.extAttrService.findZciInfoByRecommendId(recommendId);
        return zciRequiredInfo;
    }

    private Map setRequiredInfo(String recommendId) {
        Map resultMap = new HashMap();
        resultMap = this.extAttrService.findExtAttrInfo(recommendId);
        return resultMap;
    }
}

