/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.picc.gz.admin.dao.CusRecommendMapper;
import com.picc.gz.admin.dao.RecommendRequestMapper;
import com.picc.gz.admin.service.InsuranceProductItemService;
import com.picc.gz.admin.service.RecommendRequestService;
import com.picc.gz.model.model.CusRecommend;
import com.picc.gz.model.model.InsuranceProductItem;
import com.picc.gz.model.model.RecommendRequest;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class RecommendRequestServiceImpl
implements RecommendRequestService {
    @Autowired
    private RecommendRequestMapper recommendRequestMapper;
    @Autowired
    private CusRecommendMapper cusRecommendMapper;
    @Autowired
    private InsuranceProductItemService insuranceProductItemService;

    @Transactional(noRollbackFor={Exception.class})
    public void saveRecommendRequest(RecommendRequest recommendRequest) {
        recommendRequest.setDateCreated(new Date());
        this.recommendRequestMapper.insertSelective((Object)recommendRequest);
    }

    public int updateProposalNo(String id, String proposalNo) {
        return this.recommendRequestMapper.updateProposalNo(id, proposalNo);
    }

    public RecommendRequest findByRecommendId(String recommendId) {
        List recommendRequests = this.recommendRequestMapper.findByRecommendId(recommendId);
        if (recommendRequests.size() > 0) {
            return (RecommendRequest)recommendRequests.get(0);
        }
        return null;
    }

    public RecommendRequest findByRecommendIdAndProposalNo(String recommendId, String proposalNo) {
        Example selectExamp = new Example(RecommendRequest.class);
        selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("recommendId", (Object)recommendId).andEqualTo("proposalNo", (Object)proposalNo);
        List recommendRequests = this.recommendRequestMapper.selectByExample((Object)selectExamp);
        if (recommendRequests.size() > 0) {
            return (RecommendRequest)recommendRequests.get(0);
        }
        return null;
    }

    public RecommendRequest findByProposalNo(String proposalNo) {
        Example selectExamp = new Example(RecommendRequest.class);
        selectExamp.createCriteria().andEqualTo("isDelete", (Object)0).andEqualTo("proposalNo", (Object)proposalNo);
        List recommendRequests = this.recommendRequestMapper.selectByExample((Object)selectExamp);
        if (recommendRequests.size() > 0) {
            return (RecommendRequest)recommendRequests.get(0);
        }
        return null;
    }

    public List<RecommendRequest> findAllPropasaled() {
        return this.recommendRequestMapper.findAllPropasaled();
    }

    public List<RecommendRequest> findAllPropasaledBetweenDate(Date begin, Date end) {
        return this.recommendRequestMapper.findAllPropasaledBetweenDate(begin, end);
    }

    public void updatePolicy(String requestId, String propasalNo, String policyNo) {
        String recommendId = this.recommendRequestMapper.findRecommendIdByRequestId(requestId);
        if (!StringUtils.isEmpty((Object)recommendId)) {
            CusRecommend cusRecommend = (CusRecommend)this.cusRecommendMapper.selectByPrimaryKey((Object)recommendId);
            InsuranceProductItem item = this.insuranceProductItemService.findByProductCode(cusRecommend.getPlanCode());
            BigDecimal commission = new BigDecimal(item.getInsurancePremium()).multiply(new BigDecimal(cusRecommend.getSellfeerate()).divide(BigDecimal.valueOf(100L)));
            this.cusRecommendMapper.updatePolicyNo(recommendId, propasalNo, policyNo, "2", commission);
        }
    }
}

