/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.picc.gz.admin.service.DuplicateRequestDefender;
import com.picc.gz.admin.vo.RequestResultInfo;
import com.picc.gz.sfzn.api.vo.basic.BaseResponse;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="duplicateRequestDefender")
public class RedisDuplicateRequestDefender
implements DuplicateRequestDefender {
    private static final Logger log = LoggerFactory.getLogger(RedisDuplicateRequestDefender.class);
    public static final String REDIS_KEY_PREFIX = "duplicaterequestdefender:requestresult:";
    @Value(value="${duplicate-request-defender.timeout:30000}")
    private Long timeout;
    @Value(value="${duplicate-request-defender.keep-result-time:60000}")
    private Long keepResultTime;
    @Value(value="${duplicate-request-defender.retry-time:100}")
    private Long retrySpan;
    @Autowired
    RedisTemplate redisTemplate;

    public BaseResponse getResult(String key) {
        RequestResultInfo requestResultInfo = this.getRequestResultInfo(key);
        LocalDateTime now = LocalDateTime.now();
        if (requestResultInfo != null) {
            if (requestResultInfo.getStatus().equals(RequestResultInfo.STATUS.FINISHED.toString())) {
                long finishedMillis = ChronoUnit.MILLIS.between(now, requestResultInfo.getFinishTime());
                if (finishedMillis <= this.keepResultTime) {
                    log.debug("Processing[{}]\u5904\u7406\u7ed3\u679c\u5df2\u751f\u6210\uff0c\u7ed3\u679c\u4ea7\u751f\u65f6\u95f4\uff1a{}", (Object)key, (Object)requestResultInfo.getFinishTime());
                    return requestResultInfo.getResponse();
                }
                log.debug("Processing[{}]\u5904\u7406\u7ed3\u679c\u5df2\u5931\u6548\uff0c\u7ed3\u679c\u5df2\u4fdd\u7559{}ms", (Object)key, (Object)finishedMillis);
                this.putRequestResultInfo(key, null);
            } else if (RequestResultInfo.STATUS.PROCESSING.toString().equals(requestResultInfo.getStatus())) {
                while ((requestResultInfo = this.getRequestResultInfo(key)) != null && ChronoUnit.MILLIS.between(LocalDateTime.now(), requestResultInfo.getStartTime()) <= this.timeout && RequestResultInfo.STATUS.PROCESSING.toString().equals(requestResultInfo.getStatus())) {
                    try {
                        log.debug("Processing[{}]\u7ed3\u679c\u5904\u7406\u4e2d\uff0c{}\u6beb\u79d2\u540e\u91cd\u8bd5", (Object)key, (Object)this.retrySpan);
                        TimeUnit.MILLISECONDS.sleep(this.retrySpan);
                    }
                    catch (InterruptedException e) {
                        log.error("Processing[{}]\u7b49\u5f85\u51fa\u9519", (Object)key, (Object)e);
                    }
                }
                RequestResultInfo info = this.getRequestResultInfo(key);
                if (info != null && RequestResultInfo.STATUS.FINISHED.toString().equals(info.getStatus())) {
                    log.debug("Processing[{}]\u5904\u7406\u72b6\u6001\u4e3a\u5b8c\u6210\uff0c\u5c1d\u8bd5\u83b7\u53d6\u7ed3\u679c", (Object)key);
                    requestResultInfo = this.getRequestResultInfo(key);
                    if (requestResultInfo == null) {
                        log.warn("Processing[{}]\u5904\u7406\u7ed3\u679c\u83b7\u53d6\u5931\u8d25", (Object)key);
                        return null;
                    }
                    log.debug("Processing[{}]\u5904\u7406\u7ed3\u679c\u5df2\u751f\u6210\uff0c\u7ed3\u679c\u4ea7\u751f\u65f6\u95f4\uff1a{}", (Object)key, (Object)requestResultInfo.getFinishTime());
                    return requestResultInfo.getResponse();
                }
                log.debug("Processing[{}]\u5904\u7406\u7ed3\u679c\u7b49\u5f85\u8d85\u65f6", (Object)key);
            }
        } else {
            log.debug("Processing[{}]\u6ca1\u6709\u5904\u7406\u4e2d\u7684\u8bf7\u6c42", (Object)key);
        }
        return null;
    }

    public void startProcessing(String key) {
        RequestResultInfo requestResultInfo = this.getRequestResultInfo(key);
        if (requestResultInfo != null && RequestResultInfo.STATUS.PROCESSING.toString().equals(requestResultInfo.getStatus())) {
            throw new RuntimeException("\u8be5\u8bf7\u6c42\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u5728\u8c03\u7528finish\u65b9\u6cd5\u540e\u518d\u91cd\u65b0\u542f\u52a8");
        }
        requestResultInfo = new RequestResultInfo();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime tempNow = LocalDateTime.now();
        requestResultInfo.setStartTime(now);
        requestResultInfo.setStatus(RequestResultInfo.STATUS.PROCESSING.toString());
        requestResultInfo.setOverTime(ChronoUnit.MILLIS.addTo(tempNow, this.timeout));
        this.putRequestResultInfo(key, requestResultInfo);
    }

    public void finish(String key, BaseResponse response) {
        RequestResultInfo requestResultInfo = this.getRequestResultInfo(key);
        if (requestResultInfo != null) {
            requestResultInfo.setResponse(response);
            requestResultInfo.setFinishTime(LocalDateTime.now());
            requestResultInfo.setStatus(RequestResultInfo.STATUS.FINISHED.toString());
            this.putRequestResultInfo(key, requestResultInfo);
        }
    }

    public void stop(String key) {
        RequestResultInfo requestResultInfo = this.getRequestResultInfo(key);
        if (requestResultInfo != null) {
            requestResultInfo.setFinishTime(LocalDateTime.now());
            requestResultInfo.setStatus(RequestResultInfo.STATUS.STOPED.toString());
            this.putRequestResultInfo(key, requestResultInfo);
        }
    }

    private RequestResultInfo getRequestResultInfo(String key) {
        BoundValueOperations operations = this.redisTemplate.boundValueOps((Object)String.format("%skey:%s", REDIS_KEY_PREFIX, key));
        return (RequestResultInfo)operations.get();
    }

    private void putRequestResultInfo(String key, RequestResultInfo requestResultInfo) {
        String redisKey = String.format("%skey:%s", REDIS_KEY_PREFIX, key);
        BoundValueOperations operations = this.redisTemplate.boundValueOps((Object)redisKey);
        if (requestResultInfo == null) {
            operations.set(null);
            this.redisTemplate.delete((Object)redisKey);
        } else {
            operations.set((Object)requestResultInfo, this.timeout.longValue(), TimeUnit.MILLISECONDS);
        }
    }
}

