/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.picc.gz.admin.service.QuartzLockUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="quartzLockUtil")
public class RedisQuartzLockUtil
implements QuartzLockUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisQuartzLockUtil.class);
    @Autowired
    RedisTemplate redisTemplate;

    public Boolean addJobLock(String jobName, Long timeout) {
        String key = String.format("%s:%S%s", "quartz:lock:", "QUARTZ_JOB_", jobName);
        this.redisTemplate.expire((Object)key, timeout == null ? 30000L : timeout, TimeUnit.MILLISECONDS);
        log.debug("redis-lock[{}]: {}", (Object)key, this.redisTemplate.opsForValue().get((Object)key));
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)String.valueOf(System.currentTimeMillis()));
    }

    public void releaseJobLock(String jobName) {
        String key = String.format("%s:%S%s", "quartz:lock:", "QUARTZ_JOB_", jobName);
        this.redisTemplate.delete((Object)key);
    }
}

