/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.admin.service.impl;

import com.picc.gz.admin.dao.RenewalMapper;
import com.picc.gz.admin.datasource.DatabaseContextHolder;
import com.picc.gz.admin.datasource.DatabaseType;
import com.picc.gz.admin.service.RenewalService;
import com.picc.gz.admin.vo.insure.LastInsuredInfo;
import com.picc.gz.model.model.InsureDO;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RenewalServiceImpl
implements RenewalService {
    private static final Logger log = LoggerFactory.getLogger(RenewalServiceImpl.class);
    @Autowired
    private RenewalMapper renewalMapper;
    @Autowired
    RedisTemplate redisTemplate;

    public List<InsureDO> getRenewal(String idNumber, String riskCode) {
        String queryKey = String.format("%s_%s", riskCode, idNumber);
        BoundValueOperations operations = this.redisTemplate.boundValueOps((Object)queryKey);
        List data = null;
        data = (List)operations.get();
        if (data == null) {
            DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.hdr);
            try {
                data = this.renewalMapper.getRenewal(StringUtils.trimToEmpty((String)idNumber) + "%", riskCode);
                if (data != null) {
                    operations.set((Object)data, 10L, TimeUnit.HOURS);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
            }
        }
        return data;
    }

    public Integer countClaim(String policyno) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.hdr);
        try {
            Integer data = this.renewalMapper.countClaim(policyno);
            DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
            Integer n = data;
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        }
    }

    public String findCode(String applicantIdNumber) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.hdr);
        try {
            String data = this.renewalMapper.findCode(applicantIdNumber);
            DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
            String string = data;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        }
    }

    public LastInsuredInfo findXuBaoCusRecommendPersonnel(String proposalno) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.hdr);
        try {
            LastInsuredInfo lastInsuredInfo = this.renewalMapper.findXuBaoCusRecommendPersonnel(proposalno);
            DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
            LastInsuredInfo lastInsuredInfo2 = lastInsuredInfo;
            return lastInsuredInfo2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        }
    }

    public LastInsuredInfo findXuBaoApplicantInfo(String proposalno) {
        DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.hdr);
        try {
            LastInsuredInfo lastApplicantInfo = this.renewalMapper.findXuBaoApplicantInfo(proposalno);
            DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
            LastInsuredInfo lastInsuredInfo = lastApplicantInfo;
            return lastInsuredInfo;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            DatabaseContextHolder.setDatabaseType((DatabaseType)DatabaseType.sfzn);
        }
    }
}

